/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search;

import com.google.common.util.concurrent.ListenableFuture;
import com.splunk.commons.ast.nodes.CommandNode;
import com.splunk.commons.ast.nodes.CommandOrderInfo;
import com.splunk.commons.ast.nodes.commands.HeadCommand;
import com.splunk.commons.ast.nodes.commands.RdOutCommand;
import com.splunk.commons.ast.nodes.commands.SearchCommand;
import com.splunk.commons.search.HostPort;
import com.splunk.commons.visitors.NodeVisitor;
import com.splunk.commons.visitors.SplFormatter;
import com.splunk.df.search.BaseInputDDFactory;
import com.splunk.df.search.ChunkToDispatch;
import com.splunk.df.search.DFCCallable;
import com.splunk.df.search.DFSExecutionState;
import com.splunk.df.search.DFSExecutorService;
import com.splunk.df.search.DFSPhaseFacilitator;
import com.splunk.df.search.DFSProtocolConstants;
import com.splunk.df.search.DFSSearchCoordinator;
import com.splunk.df.search.DFSSidGenerator;
import com.splunk.df.search.FSHMetaPhaseExecutor;
import com.splunk.df.search.FSHMetricsInfo;
import com.splunk.df.search.FSHTriggerDDFactory;
import com.splunk.df.search.FederatedDataSetInfo;
import com.splunk.df.search.FederatedDeploymentInfo;
import com.splunk.df.search.ReceiversDDFactory;
import com.splunk.df.search.RemoteSearchInfo;
import com.splunk.df.search.SearchResultInfoUtils;
import com.splunk.df.search.SearchResultsWriter;
import com.splunk.df.search.SplunkReleaseVersion;
import com.splunk.df.search.compute.ComputeEngine;
import com.splunk.df.search.compute.ComputeEngineConstants;
import com.splunk.df.search.compute.ComputeEngineContext;
import com.splunk.df.search.compute.ComputeEngineFactory;
import com.splunk.df.search.compute.DistributedDataset;
import com.splunk.df.search.compute.ExecutionHints;
import com.splunk.df.search.compute.SearchResult;
import com.splunk.df.search.compute.SearchResultFactory;
import com.splunk.df.search.compute.SearchResultsReceiverStreaming;
import com.splunk.df.search.compute.sdk.Pair;
import com.splunk.df.security.NIOTls;
import com.splunk.df.security.SSLConfig;
import com.splunk.df.util.DFSException;
import com.splunk.df.util.EstimatedEventCount;
import com.splunk.df.util.Utils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.log4j.Logger;
import org.apache.spark.api.java.JavaSparkContext;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DFSSearchExecutor
extends DFCCallable {
    static final Logger logger = Logger.getLogger(DFSSearchExecutor.class);
    private final int dfcNumCores;
    private int DEFAULT_MAX_SEARCH_RESULTS = 100000;
    private int numberOfSplunkPeers;
    private int numberOfLocalPeers;
    private final int dfcExecutorMemMbs;
    private final int dfcDriverMemMbs;
    private final long maxReducePartitionSize;
    private JSONObject receivedInfo;
    private final String shSignature;
    private final String sid;
    private final JSONObject dfsSearchAST;
    private final SearchResultInfoUtils searchResultsInfo;
    private BufferedWriter bw;
    private final OutputStream rawosToSplunk;
    private BufferedReader br;
    private ArrayList<HostPort> splunkPeerList;
    private JSONObject fshInfo;
    private DFSExecutionState dfsExecutionState;
    private boolean ackSent = false;
    private boolean exceededTimeout = false;
    private boolean processedLogs = false;
    private ComputeEngineContext savedCtxForFailure = null;
    private JavaSparkContext jsc;
    private boolean isFshExecution = false;
    private static boolean isSRIKeysCached = false;
    private static SearchResult.FieldMeta[] sriKeysCached = null;
    private long maxKeepAliveTime;
    private int maxNumKeepAlive;
    private DFSSidGenerator dfsSidGenerator;
    private DFSPhaseFacilitator dfsPhaseFacilitator;
    private Socket connection;
    private final int dfcCoresPerExecutor;
    private DFSSearchCoordinator dfc;
    private final int dfcConcurrentSearches;
    private final String splunkConf;
    private final int dfcReceiverPort;
    private final int dfcReceiverPortCount;
    private final String dfcIpAddress;
    private final DFSExecutorService searchExecutorSes;
    private final long estimatedEventCount;
    private final String originalUser;
    private HashMap<Integer, FederatedDataSetInfo> datasetInfoMap = null;
    private HashMap<String, FederatedDeploymentInfo> deploymentInfoMap = null;
    DistributedDataset fshExecutorDD = null;

    public DFSSearchExecutor(DFSSearchCoordinator dfc, String searchId, JSONObject info, BufferedReader br, OutputStream rawos, JavaSparkContext jsc, Socket connection, long startConnect, int dfcNumCores, int dfcNumExecutors, int dfcExecutorMemMbs, int dfcDriverMemMbs, int dfcConcurrentSearches, long maxReducePartitionSize, int dfcReceiverPort, int dfcReceiverPortCount, String splunkConf, DFSExecutorService searchExecutorSes, SearchResultInfoUtils srInfoHelper) {
        this.searchExecutorSes = searchExecutorSes;
        this.dfcReceiverPort = dfcReceiverPort;
        this.dfcReceiverPortCount = dfcReceiverPortCount;
        this.dfcConcurrentSearches = dfcConcurrentSearches;
        this.dfc = dfc;
        this.dfcNumCores = dfcNumCores;
        this.dfcExecutorMemMbs = dfcExecutorMemMbs;
        this.dfcCoresPerExecutor = Math.max(1, dfcNumCores / dfcNumExecutors);
        this.dfcDriverMemMbs = dfcDriverMemMbs;
        this.maxReducePartitionSize = maxReducePartitionSize;
        this.splunkConf = splunkConf;
        Pair<Integer, Long> estimationInfo = this.getEstimatedEventCount(splunkConf);
        this.estimatedEventCount = estimationInfo.second();
        this.numberOfSplunkPeers = estimationInfo.first();
        logger.debug((Object)String.format("Estimated event count of the index being searched: %d", this.estimatedEventCount));
        this.connection = connection;
        this.receivedInfo = info;
        this.sid = searchId;
        this.searchResultsInfo = srInfoHelper;
        this.searchResultsInfo.getSRI().getDataMap().put(REMOTE_SEARCH_QUERY_FINISHED, false);
        String searchHeadInstanceName = this.receivedInfo.getString(DFSProtocolConstants.PROTO_DFS_SPLUNK_SERVER_NAME.toString());
        if (searchHeadInstanceName == null) {
            logger.error((Object)String.format("Splunk search head instance name not set: %s", this.sid));
            throw new RuntimeException(String.format("splunk search head instance name not set: %s", this.sid));
        }
        this.shSignature = searchHeadInstanceName;
        logger.info((Object)String.format("Search head instance name used for generating remote sids on dfs side is: %s", searchHeadInstanceName));
        this.originalUser = this.receivedInfo.getString(DFSProtocolConstants.PROTO_DFS_USER_ID.toString());
        String dfcIpAddressStr = this.receivedInfo.getString(DFSProtocolConstants.PROTO_DFS_DFC_IP_ADDRESS.toString());
        if (dfcIpAddressStr == null || "".equals(dfcIpAddressStr.trim())) {
            logger.info((Object)"Splunk server.conf does not have dfc_ip_address set. So try to get from localhost address.");
            dfcIpAddressStr = Utils.getLocalHostAddress();
        } else if ("127.0.0.1".equals(dfcIpAddressStr.trim())) {
            throw new DFSException(logger, "Invalid host IP address '127.0.0.1' is defined in server.conf for the Data Fabric Coordinator (DFC) process.");
        }
        this.dfcIpAddress = dfcIpAddressStr;
        logger.debug((Object)("dfcIpAddress=" + this.dfcIpAddress));
        JSONObject dfsjob = (JSONObject)this.receivedInfo.get(DFSProtocolConstants.PROTO_DFS_SEARCH_STR.toString());
        this.dfsSearchAST = dfsjob.getJSONArray("sources").getJSONObject(0);
        logger.debug((Object)("dfsSearchAST=" + this.dfsSearchAST));
        if (this.receivedInfo.has(DFSProtocolConstants.PROTO_DFS_FSH_INFO.toString())) {
            this.isFshExecution = true;
            this.fshInfo = this.receivedInfo.getJSONObject(DFSProtocolConstants.PROTO_DFS_FSH_INFO.toString());
            logger.debug((Object)("The FSH blob-->" + this.fshInfo.toString()));
            this.loadFSHInfo(this.receivedInfo.getJSONObject(DFSProtocolConstants.PROTO_DFS_FSH_INFO.toString()));
        }
        this.dfsPhaseFacilitator = new DFSPhaseFacilitator(this.dfsSearchAST, this.datasetInfoMap);
        this.jsc = jsc;
        this.br = br;
        this.rawosToSplunk = rawos;
        this.bw = new BufferedWriter(new OutputStreamWriter(rawos, StandardCharsets.UTF_8));
        this.dfsSidGenerator = new DFSSidGenerator(this.shSignature, this.sid);
        this.splunkPeerList = new ArrayList();
        this.maxKeepAliveTime = 0L;
        this.maxNumKeepAlive = 0;
        this.dfsExecutionState = DFSExecutionState.UNKNOWN;
        logger.info((Object)String.format("Number of cores: %d, indexers: %d, executor memory in mbs: %d, driver memory in mbs: %d", dfcNumCores, this.numberOfSplunkPeers, dfcExecutorMemMbs, dfcDriverMemMbs));
    }

    private void loadFSHInfo(JSONObject jsonObject) {
        this.datasetInfoMap = new HashMap();
        this.deploymentInfoMap = new HashMap();
        JSONObject fshObject = this.fshInfo.getJSONObject("fshServiceAccountInfo");
        JSONArray dataSetArray = fshObject.getJSONArray("datasets");
        for (int i = 0; i < dataSetArray.length(); ++i) {
            JSONObject element = dataSetArray.getJSONObject(i);
            FederatedDataSetInfo federatedDataSetInfo = new FederatedDataSetInfo(element.getString("dataset"), element.getString("search"), element.getString("federated.provider"), i);
            this.datasetInfoMap.put(i, federatedDataSetInfo);
        }
        JSONArray deploymentArray = fshObject.getJSONArray("providers");
        for (int i = 0; i < deploymentArray.length(); ++i) {
            JSONObject element = deploymentArray.getJSONObject(i);
            FederatedDeploymentInfo federatedDeploymentInfo = new FederatedDeploymentInfo(element.getString("ip"), element.getInt("splunk.port"), element.getString("federated.provider"), element.getString("splunk.serviceAccount"), element.getString("password"));
            this.deploymentInfoMap.put(element.getString("federated.provider"), federatedDeploymentInfo);
        }
    }

    private static Double getSRITimeValue(SearchResult searchResultsInfo, SearchResult.FieldMeta field) {
        if (searchResultsInfo.containsField(field)) {
            String val = (String)searchResultsInfo.getFieldValue(field);
            return new Double(val);
        }
        return null;
    }

    private Pair<Integer, Long> getEstimatedEventCount(String splunkConf) {
        JSONObject dfsExecution = new JSONObject(splunkConf).getJSONObject("limits").getJSONObject("dfs");
        long estimatedEventCount = 0L;
        int numIndexServers = 0;
        if (dfsExecution.has("estimatedEventCount")) {
            EstimatedEventCount ec = new EstimatedEventCount(dfsExecution.getJSONArray("estimatedEventCount"));
            estimatedEventCount = ec.getTotalEventCount();
            numIndexServers = ec.getSplunkServerCount();
        }
        logger.info((Object)("Estimated Event Count = " + estimatedEventCount));
        logger.info((Object)String.format("number of index servers: %d", numIndexServers));
        return new Pair<Integer, Long>(numIndexServers, estimatedEventCount);
    }

    private static double getRdinBoost() {
        double boost = 2.0;
        String boostStr = System.getenv("DFS_RDIN_BOOST");
        if (boostStr != null) {
            try {
                boost = Double.valueOf(boostStr);
            }
            catch (Throwable t) {
                logger.info((Object)String.format("rdin boost envvar was invalid: %s, reason: %s, hence the default would be used: %.2f", boostStr, t.getMessage(), boost));
            }
        }
        return boost;
    }

    private static long getMaxRdOutRecords(long estimatedEventCount) {
        long numRdoutRecs = 1000000000L;
        String temp = System.getenv("MAX_NUM_RDOUT_RECORDS");
        if (temp != null) {
            numRdoutRecs = Long.valueOf(temp);
            logger.info((Object)String.format("setting the max rdout records to: %d based on envvar, this will override event count estimation from splunkd", numRdoutRecs));
        } else if (estimatedEventCount > 0L) {
            double rdinBoost = DFSSearchExecutor.getRdinBoost();
            numRdoutRecs = (long)((double)estimatedEventCount * rdinBoost);
            logger.info((Object)String.format("setting the max rdout records to: %d based on estimation count from splunkd, boost: %.2f", numRdoutRecs, rdinBoost));
        } else {
            logger.info((Object)String.format("setting the max rdout records to: %d as default since no envvar or count estimation has been received", numRdoutRecs));
        }
        return numRdoutRecs;
    }

    private static HeadCommand getHeadSource(CommandNode cn) {
        if (cn instanceof SearchCommand) {
            logger.info((Object)String.format("stopping since command node is search node", new Object[0]));
            return null;
        }
        CommandNode parent = cn.getSource();
        if (parent == null) {
            return null;
        }
        if (parent instanceof HeadCommand) {
            return (HeadCommand)parent;
        }
        return DFSSearchExecutor.getHeadSource(parent);
    }

    private static int getRdinPars(ExecutionHints hints, CommandNode cn, long rdinRecs, int numPeers) {
        if (!(cn instanceof RdOutCommand)) {
            throw new RuntimeException(String.format("expected rdout command node but got %s", cn.getClass().getName()));
        }
        RdOutCommand rcn = (RdOutCommand)cn;
        HeadCommand hc = DFSSearchExecutor.getHeadSource((CommandNode)rcn);
        long maxHead = -1L;
        if (hc != null && (maxHead = Long.parseLong(hc.getLimit().toString())) > -1L && numPeers > 0) {
            long totalRecs = maxHead * (long)numPeers;
            rdinRecs = Math.min(totalRecs, rdinRecs);
            logger.info((Object)String.format("capping number of recs from rdout to: %d based on pre-head assumption, and num index peers: %d, pre-head on each indexer: %d", rdinRecs, numPeers, maxHead));
        }
        int numFields = rcn.getAvailableFields().size();
        logger.info((Object)String.format("Number of fields in rdout command node: %d, the fields are: %s", numFields, rcn.getAvailableFields().toString()));
        int numPars = hints.defaultPartitionCount(rdinRecs, numFields);
        return numPars;
    }

    private static int getRdInPartitionsForFSH(ExecutionHints hints, long rdInRecs, int numFields) {
        logger.info((Object)String.format("Number of records %d and fields %d", rdInRecs, numFields));
        int numPars = hints.defaultPartitionCount(rdInRecs, numFields);
        return numPars;
    }

    private static Pair<Long, Integer> getPartitioningInfoFromDataSet(String dataSet, JSONObject fshInfo) {
        Long maxRecords = Long.MAX_VALUE;
        Integer numFields = 0;
        try {
            JSONObject fshObject = fshInfo.getJSONObject("fshServiceAccountInfo");
            JSONArray dataSetArray = fshObject.getJSONArray("datasets");
            for (int i = 0; i < dataSetArray.length(); ++i) {
                JSONObject element = dataSetArray.getJSONObject(i);
                if (!element.getString("dataset").equalsIgnoreCase(dataSet)) continue;
                maxRecords = element.getLong("estimatedResultCount");
                numFields = element.getInt("numFields");
            }
        }
        catch (JSONException je) {
            logger.error((Object)je.toString());
            throw je;
        }
        return new Pair<Long, Integer>(maxRecords, numFields);
    }

    private static String getDataSetForSid(String remoteSid, HashMap<String, List<String>> dataSetToRemoteSid) {
        String dataSet = null;
        block0: for (Map.Entry<String, List<String>> entry : dataSetToRemoteSid.entrySet()) {
            ListIterator<String> litr = entry.getValue().listIterator();
            while (litr.hasNext()) {
                if (!remoteSid.equalsIgnoreCase(litr.next())) continue;
                dataSet = entry.getKey();
                continue block0;
            }
        }
        assert (dataSet != null);
        return dataSet;
    }

    private String[] convert(Collection<SearchResult.FieldMeta> fields) {
        String[] strFields = new String[fields.size()];
        Iterator<SearchResult.FieldMeta> fieldsItr = fields.iterator();
        int idx = 0;
        while (fieldsItr.hasNext()) {
            SearchResult.FieldMeta field = fieldsItr.next();
            strFields[idx] = field.fieldName();
            ++idx;
        }
        return strFields;
    }

    private static boolean getRemoteDownloadMode(SearchResult searchResultsInfo) {
        String frsl;
        return searchResultsInfo.containsField(ComputeEngineConstants.FETCH_REMOTE_SEARCH_LOG) && ((frsl = (String)searchResultsInfo.getFieldValue(ComputeEngineConstants.FETCH_REMOTE_SEARCH_LOG)).equals("enabled") || frsl.equals("disabledSavedSearches") && searchResultsInfo.containsField(ComputeEngineConstants.IS_SAVED_SEARCH) && Boolean.valueOf((String)searchResultsInfo.getFieldValue(ComputeEngineConstants.IS_SAVED_SEARCH)) == false);
    }

    @Override
    protected Object runInternal() throws Exception {
        ComputeEngine engine = null;
        long start = System.currentTimeMillis();
        logger.info((Object)String.format("Dfs search executor: running new search: sid: %s", this.sid));
        ComputeEngineContext ctx = new ComputeEngineContext();
        this.setEngineContext(ctx);
        this.savedCtxForFailure = ctx;
        engine = ComputeEngineFactory.getInstance().newInstance(ComputeEngineConstants.EngineType.SPARK, ctx);
        ExecutionHints hints = (ExecutionHints)ctx.get("execution.hints");
        if (this.isFshExecution) {
            long metaProcessingStart = System.currentTimeMillis();
            FSHMetaPhaseExecutor fshMetaPhaseExecutor = new FSHMetaPhaseExecutor();
            logger.info((Object)String.format("The number of federated datasets is %d", this.datasetInfoMap.size()));
            this.fshExecutorDD = fshMetaPhaseExecutor.executeDistributedMetaPhase(engine.emptyDataset(), this.datasetInfoMap, this.deploymentInfoMap);
            logger.info((Object)String.format("FSH MetaProcessing time taken=%d milliseconds.", System.currentTimeMillis() - metaProcessingStart));
        }
        this.dfsPhaseFacilitator.generatePhases(this.dfsSidGenerator);
        int numberOfRemoteSearches = this.dfsPhaseFacilitator.getNumberOfRemoteSearches();
        int numberOfFSHSearches = this.dfsPhaseFacilitator.getNumberOfFederatedSearch();
        HashMap<String, List<String>> dataSetToRemoteSid = null;
        DistributedDataset root = null;
        Pair<DistributedDataset, List<HostPort>> receiversAndHostPorts = null;
        DistributedDataset receiversdd = null;
        HashMap<String, String> logicalToPhysicalSid = null;
        HashMap<String, Integer> logicalToFieldNum = new HashMap<String, Integer>();
        Pair<Integer, Long> pInfo = null;
        List<HostPort> hostPortsList = null;
        assert (numberOfRemoteSearches >= 0);
        assert (numberOfFSHSearches >= 0);
        ArrayList<RemoteSearchInfo> remoteSearchInfoArrayList = new ArrayList<RemoteSearchInfo>();
        long parSize = Long.MAX_VALUE;
        int numPars = 1;
        int keyStoreProviderPort = -1;
        if (SSLConfig.getInstance().isTlsEnabled()) {
            try {
                keyStoreProviderPort = NIOTls.startSSLConfigInfoProviderServer(this.sid, this.dfcIpAddress, this.searchExecutorSes, this.dfc, this.searchResultsInfo);
            }
            catch (Exception ex) {
                logger.error((Object)"Error starting the keystore info provider");
                logger.error((Object)ex.getMessage());
            }
        }
        this.dfsExecutionState = this.dfsPhaseFacilitator.getCurrentDFSExecutionState();
        logger.debug((Object)("Post Phase Facilitation DFS execution state:" + this.dfsExecutionState.toString()));
        switch (this.dfsExecutionState) {
            case LOCAL_ONLY: {
                assert (numberOfRemoteSearches > 0);
                assert (numberOfFSHSearches == 0);
                ArrayList<String> remoteSidList = this.dfsSidGenerator.getRemoteSidList();
                pInfo = this.estimatePartitionForLocalDep(remoteSearchInfoArrayList, remoteSidList, hints, numberOfRemoteSearches);
                numPars = pInfo.first();
                parSize = pInfo.second();
                root = engine.emptyDataset();
                receiversAndHostPorts = ReceiversDDFactory.createReceiversDD(root, this.dfcReceiverPort, this.dfcReceiverPortCount, numPars, keyStoreProviderPort, this.dfcIpAddress, this.dfcNumCores, false, this.dfcCoresPerExecutor);
                receiversdd = receiversAndHostPorts.first();
                hostPortsList = receiversAndHostPorts.second();
                this.dfsPhaseFacilitator.updateRDoutWithListeners(hostPortsList);
                break;
            }
            case FEDERATED_ONLY: {
                String currentSid;
                assert (numberOfRemoteSearches == 0);
                assert (numberOfFSHSearches > 0);
                ArrayList<String> remoteSidList = this.dfsSidGenerator.getFSHRemoteSidList();
                dataSetToRemoteSid = this.dfsPhaseFacilitator.getDataSetToRemoteSid();
                assert (dataSetToRemoteSid != null);
                pInfo = this.estimateFederatedEventCount(remoteSearchInfoArrayList, remoteSidList, dataSetToRemoteSid, logicalToFieldNum, hints);
                numPars = pInfo.first();
                parSize = pInfo.second();
                root = engine.emptyDataset();
                receiversAndHostPorts = ReceiversDDFactory.createReceiversDD(root, this.dfcReceiverPort, this.dfcReceiverPortCount, numPars, keyStoreProviderPort, this.dfcIpAddress, this.dfcNumCores, true, this.dfcCoresPerExecutor);
                receiversdd = receiversAndHostPorts.first();
                hostPortsList = receiversAndHostPorts.second();
                if (this.fshExecutorDD == null) {
                    this.fshExecutorDD = engine.emptyDataset();
                    logicalToPhysicalSid = FSHTriggerDDFactory.executeFSHPartitioningAndTrigger(this.fshExecutorDD, this.datasetInfoMap, this.deploymentInfoMap, dataSetToRemoteSid, hostPortsList, this.originalUser);
                } else {
                    logicalToPhysicalSid = FSHTriggerDDFactory.executeFSHTrigger(this.fshExecutorDD, this.datasetInfoMap, dataSetToRemoteSid, hostPortsList, this.originalUser);
                }
                assert (logicalToPhysicalSid != null);
                for (int i = 0; i < remoteSearchInfoArrayList.size(); ++i) {
                    currentSid = remoteSearchInfoArrayList.get(i).sid();
                    if (!currentSid.startsWith("fsh")) {
                        throw new DFSException(logger, String.format("FSH Execution missing physical SID for logical Sid=%s.", currentSid));
                    }
                    remoteSearchInfoArrayList.get(i).setSid(logicalToPhysicalSid.get(currentSid));
                    remoteSearchInfoArrayList.get(i).setFshSid(currentSid);
                }
                ctx.addContext("fshRemoteSidMap", logicalToPhysicalSid);
                ctx.addContext("fshRemoteFieldNumMap", logicalToFieldNum);
                break;
            }
            case MIXED_MODE: {
                String currentSid;
                assert (numberOfRemoteSearches > 0);
                assert (numberOfFSHSearches > 0);
                ArrayList<String> remoteSidList = this.dfsSidGenerator.getRemoteSidList();
                pInfo = this.estimatePartitionForLocalDep(remoteSearchInfoArrayList, remoteSidList, hints, numberOfRemoteSearches);
                numPars = pInfo.first();
                parSize = pInfo.second();
                remoteSidList = this.dfsSidGenerator.getFSHRemoteSidList();
                dataSetToRemoteSid = this.dfsPhaseFacilitator.getDataSetToRemoteSid();
                assert (dataSetToRemoteSid != null);
                assert (dataSetToRemoteSid != null);
                pInfo = this.estimateFederatedEventCount(remoteSearchInfoArrayList, remoteSidList, dataSetToRemoteSid, logicalToFieldNum, hints);
                parSize = Math.max(parSize, pInfo.second());
                root = engine.emptyDataset();
                receiversAndHostPorts = ReceiversDDFactory.createReceiversDD(root, this.dfcReceiverPort, this.dfcReceiverPortCount, numPars += pInfo.first().intValue(), keyStoreProviderPort, this.dfcIpAddress, this.dfcNumCores, true, this.dfcCoresPerExecutor);
                receiversdd = receiversAndHostPorts.first();
                hostPortsList = receiversAndHostPorts.second();
                this.dfsPhaseFacilitator.updateRDoutWithListeners(hostPortsList);
                if (this.fshExecutorDD == null) {
                    this.fshExecutorDD = engine.emptyDataset();
                    logicalToPhysicalSid = FSHTriggerDDFactory.executeFSHPartitioningAndTrigger(this.fshExecutorDD, this.datasetInfoMap, this.deploymentInfoMap, dataSetToRemoteSid, hostPortsList, this.originalUser);
                } else {
                    logicalToPhysicalSid = FSHTriggerDDFactory.executeFSHTrigger(this.fshExecutorDD, this.datasetInfoMap, dataSetToRemoteSid, hostPortsList, this.originalUser);
                }
                assert (logicalToPhysicalSid != null);
                for (int i = 0; i < remoteSearchInfoArrayList.size(); ++i) {
                    currentSid = remoteSearchInfoArrayList.get(i).sid();
                    if (!currentSid.startsWith("fsh")) continue;
                    remoteSearchInfoArrayList.get(i).setSid(logicalToPhysicalSid.get(currentSid));
                    remoteSearchInfoArrayList.get(i).setFshSid(currentSid);
                }
                ctx.addContext("fshRemoteSidMap", logicalToPhysicalSid);
                ctx.addContext("fshRemoteFieldNumMap", logicalToFieldNum);
                break;
            }
            case UNKNOWN: {
                throw new UnsupportedOperationException("Phase generation failed, DFS execution state unknown.");
            }
        }
        this.numberOfSplunkPeers = this.sendResponseAndReceive();
        this.numberOfLocalPeers = this.splunkPeerList.size();
        logger.info((Object)String.format("updated the number of splunk indexer peer based on response from sh: %d", numberOfFSHSearches));
        if (this.numberOfSplunkPeers == 0) {
            throw new DFSException(logger, "Number of indexers is 0 so shutting down the search.");
        }
        logger.info((Object)String.format("The number of searches being registered for execution in the data layer in remoteSearchInfoArrayList is=%d.", remoteSearchInfoArrayList.size()));
        for (int i = 0; i < remoteSearchInfoArrayList.size(); ++i) {
            RemoteSearchInfo currInfo = remoteSearchInfoArrayList.get(i);
            if (currInfo.fshSid() != null) {
                logger.info((Object)("FSH Sid " + currInfo.sid()));
                currInfo.setNumPeers(1);
                continue;
            }
            currInfo.setNumPeers(this.numberOfLocalPeers);
        }
        RemoteSearchInfo[] remoteSearchInfos = new RemoteSearchInfo[remoteSearchInfoArrayList.size()];
        remoteSearchInfoArrayList.toArray(remoteSearchInfos);
        DistributedDataset baseDD = BaseInputDDFactory.createInputDD(receiversdd, remoteSearchInfos, parSize, ctx);
        ctx.addContext("baseInputDD", new Pair<DistributedDataset, Long>(baseDD, parSize));
        ctx.addContext("numSplunkIndexers", this.numberOfSplunkPeers);
        ctx.addContext("numRemoteSearches", numberOfFSHSearches + numberOfRemoteSearches);
        logger.debug((Object)String.format("Number of remote searches set into context: %d", numberOfRemoteSearches));
        engine = ComputeEngineFactory.getInstance().newInstance(ComputeEngineConstants.EngineType.SPARK, ctx);
        final boolean[] shutdownDispatch = new boolean[]{false};
        final LinkedBlockingDeque<ChunkToDispatch> chunkDispatchQueue = new LinkedBlockingDeque<ChunkToDispatch>(10);
        Throwable[] abort = new Throwable[1];
        ListenableFuture dispatchFuture = this.searchExecutorSes.submit(new DFCCallable(){
            private int currentKeepAliveCount = 0;
            private boolean isCached = false;
            private ChunkToDispatch keepAlive;

            @Override
            protected Object runInternal() throws Exception {
                boolean shutdownRequested = false;
                long lastTransmitTime = System.currentTimeMillis();
                while (true) {
                    long curTime = System.currentTimeMillis();
                    ChunkToDispatch chunkToDispatch = (ChunkToDispatch)chunkDispatchQueue.poll(10L, TimeUnit.MILLISECONDS);
                    long pollingTime = System.currentTimeMillis() - curTime;
                    if (pollingTime > 1000L) {
                        logger.debug((Object)("Time spent to poll from dispatch queue: " + pollingTime));
                    }
                    if (chunkToDispatch == null) {
                        if (shutdownRequested) break;
                        if (shutdownDispatch[0]) {
                            logger.debug((Object)"Requesting shutdown of dispatch thread after all remaining result chunks are sent to splunkd");
                            shutdownRequested = true;
                        }
                        long timeSinceLastTransmit = System.currentTimeMillis() - lastTransmitTime;
                        if (shutdownRequested || timeSinceLastTransmit <= DFSSearchExecutor.this.maxKeepAliveTime) continue;
                        if (this.currentKeepAliveCount >= DFSSearchExecutor.this.maxNumKeepAlive) {
                            throw new DFSException(logger, String.format("Search timed out, dfc has sent %d keep alive; maxKeepAliveTime %d", this.currentKeepAliveCount, DFSSearchExecutor.this.maxKeepAliveTime));
                        }
                        chunkToDispatch = this.getKeepAlive();
                        ++this.currentKeepAliveCount;
                        logger.debug((Object)("Sending keep alive number: " + this.currentKeepAliveCount + " at " + System.currentTimeMillis()));
                    } else {
                        this.currentKeepAliveCount = 0;
                    }
                    logger.debug((Object)"Dispatching chunk...");
                    String payload = chunkToDispatch.getSRSetSize() == 0 ? String.format("%s\n%s", chunkToDispatch.getHeader(), chunkToDispatch.getSri()) : String.format("%s\n%s%s", chunkToDispatch.getHeader(), chunkToDispatch.getSri(), chunkToDispatch.getSrSet());
                    byte[] payloadToSend = payload.getBytes(StandardCharsets.UTF_8);
                    int sizeOfPayload = payloadToSend.length;
                    ByteBuffer bb = ByteBuffer.allocate(4);
                    bb.putInt(sizeOfPayload);
                    byte[] sizebuff = bb.array();
                    ArrayUtils.reverse((byte[])sizebuff);
                    DFSSearchExecutor.this.rawosToSplunk.write(sizebuff);
                    DFSSearchExecutor.this.rawosToSplunk.write(payloadToSend);
                    DFSSearchExecutor.this.rawosToSplunk.flush();
                    lastTransmitTime = System.currentTimeMillis();
                }
                logger.debug((Object)"Shutting down dispatcher since shutdown had been requested and no more chunks left to process");
                ByteBuffer bb = ByteBuffer.allocate(4);
                bb.putInt(0);
                byte[] endMarkerBuff = bb.array();
                DFSSearchExecutor.this.rawosToSplunk.write(endMarkerBuff);
                DFSSearchExecutor.this.rawosToSplunk.flush();
                DFSSearchExecutor.this.rawosToSplunk.close();
                return null;
            }

            @Override
            protected Object runOnFailure(Throwable t) {
                logger.error((Object)String.format("error executing search: %s", t.getMessage()), t);
                if (!(t instanceof DFSException)) {
                    t = new DFSException(logger, String.format("Error caused while sending chunk to splunk search process , error cause=%s", t.getMessage()));
                }
                DFSSearchExecutor.this.searchResultsInfo.sendEndofSearchErrorSRI(Thread.currentThread(), t);
                DFSSearchExecutor.this.dfc.informMasterDfcShutdown();
                return t;
            }

            private ChunkToDispatch getKeepAlive() throws Exception {
                if (!this.isCached) {
                    SearchResult.FieldMeta[] sriKeys = DFSSearchExecutor.getSriKeys(DFSSearchExecutor.this.searchResultsInfo.getSRI());
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    BufferedWriter chunkWriter = new BufferedWriter(new OutputStreamWriter(baos));
                    CSVPrinter csvPrinter = CSVFormat.DEFAULT.withHeader(SearchResultsWriter.convert(sriKeys)).print((Appendable)chunkWriter);
                    Object[] sriValues = new Object[sriKeys.length];
                    System.arraycopy(DFSSearchExecutor.this.searchResultsInfo.getSRI().getDataMap().values().toArray(), 0, sriValues, 0, sriKeys.length);
                    csvPrinter.printRecord(sriValues);
                    csvPrinter.flush();
                    String sriPayload = new String(baos.toByteArray());
                    this.keepAlive = new ChunkToDispatch(sriPayload, new String());
                    this.isCached = true;
                }
                return this.keepAlive;
            }
        });
        SplunkReleaseVersion version = this.dfc.getSplunkVersion();
        logger.debug((Object)("Splunk version:" + version.toString()));
        DistributedDataset srdd = engine.executeBatchSearch(this.dfsPhaseFacilitator.getDFSPhase());
        HashMap<String, Pair<String, String>> remoteSidToDataSetDeployment = new HashMap<String, Pair<String, String>>();
        if (!this.dfsExecutionState.equals((Object)DFSExecutionState.LOCAL_ONLY)) {
            this.populateFSHMetricsLookup(remoteSidToDataSetDeployment, logicalToPhysicalSid, dataSetToRemoteSid);
        }
        this.dispatchResults(srdd, chunkDispatchQueue, shutdownDispatch, abort, this.sid, ctx, remoteSidToDataSetDeployment);
        dispatchFuture.get();
        logger.info((Object)String.format("Sid: %s: all srs dispatched to splunkd, hence shutting down the search executor, total time taken: %d millis", this.sid, System.currentTimeMillis() - start));
        engine.close();
        return null;
    }

    private void populateFSHMetricsLookup(HashMap<String, Pair<String, String>> remoteSidToDataSetDeployment, HashMap<String, String> logicalToPhysicalSid, HashMap<String, List<String>> dataSetToLogicalSid) {
        for (Map.Entry<String, String> entry : logicalToPhysicalSid.entrySet()) {
            String logicalSid = entry.getKey();
            String physicalSid = entry.getValue();
            logger.info((Object)("Logical sid=" + logicalSid + " mapping to physical sid=" + physicalSid));
            for (Map.Entry<String, List<String>> dataSetItem : dataSetToLogicalSid.entrySet()) {
                String dataset = dataSetItem.getKey();
                List<String> remoteSidList = dataSetItem.getValue();
                for (String remoteSid : remoteSidList) {
                    if (!remoteSid.equalsIgnoreCase(logicalSid)) continue;
                    String deployment = this.getDeploymentForDataSet(dataset);
                    remoteSidToDataSetDeployment.put(physicalSid, new Pair<String, String>(dataset, deployment));
                }
            }
        }
    }

    private String getDeploymentForDataSet(String dataset) {
        String[] kindAndName = dataset.split(":", 2);
        String dataSetName = kindAndName[1];
        JSONObject fshObject = this.fshInfo.getJSONObject("fshServiceAccountInfo");
        JSONArray dataSetArray = fshObject.getJSONArray("datasets");
        String deploymentName = null;
        for (int i = 0; i < dataSetArray.length(); ++i) {
            JSONObject element = dataSetArray.getJSONObject(i);
            if (!element.getString("dataset").equalsIgnoreCase(dataSetName)) continue;
            deploymentName = element.getString("federated.provider");
            break;
        }
        assert (deploymentName != null);
        return deploymentName;
    }

    @Override
    protected Object runOnFailure(Throwable t) throws Exception {
        logger.error((Object)String.format("error received while running search executor: %s", t.getMessage()), t);
        if (!this.ackSent) {
            logger.error((Object)"Exception encountered prior to sending acknowledgement response for search query");
            this.searchResultsInfo.sendAckError(Thread.currentThread(), t);
        } else if (!this.exceededTimeout) {
            Pair pair;
            if (!this.processedLogs && (pair = (Pair)this.savedCtxForFailure.get("baseInputDD")) != null) {
                DistributedDataset srdd = (DistributedDataset)pair.first();
                logger.error((Object)"Processing logs when an exception occurs");
                DFSSearchExecutor.processLogs(DFSSearchExecutor.getSriList(srdd.getsriDD()), Utils.isDownloadRemoteLogEnabled(this.savedCtxForFailure));
            }
            logger.error((Object)"Exception encountered during execution. Sending exception details to splunk search process");
            this.searchResultsInfo.sendEndofSearchErrorSRI(Thread.currentThread(), t);
        }
        logger.error((Object)String.format("Error running search: sid: %s, reason: %s", this.sid, t.getMessage()), t);
        this.dfc.informMasterDfcShutdown();
        this.closeConnectionToSplunkdSCP(t);
        return t;
    }

    @Override
    protected void cleanup() {
        this.dfc.informMasterDfcShutdown();
        logger.info((Object)String.format("Will shutdown dfc process since search is over, dfc id: %s", this.sid));
    }

    private void setEngineContext(ComputeEngineContext ctx) {
        ctx.addContext("java.spark.context", this.jsc);
        ctx.addContext("numCores", this.dfcNumCores);
        ctx.addContext("sid", this.sid);
        ctx.addContext("executor.memory.mbs", this.dfcExecutorMemMbs);
        ctx.addContext("driver.memory.mbs", this.dfcDriverMemMbs);
        ctx.addContext("cores.per.executor", this.dfcCoresPerExecutor);
        ctx.addContext("dfc.concurrent.searches", this.dfcConcurrentSearches);
        ctx.addContext("MAX_REDUCE_PARTITION_SIZE", this.maxReducePartitionSize);
        ctx.addContext("splunkConf", this.splunkConf);
        ctx.addContext("externalSource", "RdinTransformer");
        ctx.addContext("splunkConf", this.splunkConf);
        ctx.addContext(ComputeEngineConstants.FETCH_REMOTE_SEARCH_LOG.toString(), DFSSearchExecutor.getRemoteDownloadMode(this.searchResultsInfo.getSRI()));
        ctx.addContext(ComputeEngineConstants.SRI_START_TIME.toString(), DFSSearchExecutor.getSRITimeValue(this.searchResultsInfo.getSRI(), ComputeEngineConstants.SRI_START_TIME));
        ctx.addContext(ComputeEngineConstants.SRI_END_TIME.toString(), DFSSearchExecutor.getSRITimeValue(this.searchResultsInfo.getSRI(), ComputeEngineConstants.SRI_END_TIME));
    }

    private Pair<Integer, Long> estimatePartitionForLocalDep(ArrayList<RemoteSearchInfo> remoteSearchInfoArrayList, ArrayList<String> remoteSidList, ExecutionHints hints, int numberOfRemoteSearches) {
        int numPartitions = 1;
        long parSize = Long.MAX_VALUE;
        long maxRecords = DFSSearchExecutor.getMaxRdOutRecords(this.estimatedEventCount);
        for (int i = 0; i < numberOfRemoteSearches; ++i) {
            String curRemoteSid = remoteSidList.get(i);
            logger.debug((Object)String.format("Remote sid: %s", curRemoteSid));
            int lnumPars = DFSSearchExecutor.getRdinPars(hints, this.dfsPhaseFacilitator.getRdOutCommand(i), maxRecords, this.numberOfSplunkPeers);
            numPartitions = Math.max(lnumPars, numPartitions);
            long lparSize = Math.max(1L, maxRecords / (long)lnumPars);
            parSize = Math.min(parSize, lparSize);
            remoteSearchInfoArrayList.add(new RemoteSearchInfo(curRemoteSid, -1));
            logger.info((Object)String.format("Remote search to be executed: sid: %s, max recs expected: %d, number of partitions: %d, partition size: %d", curRemoteSid, maxRecords, lnumPars, lparSize));
        }
        return new Pair<Integer, Long>(numPartitions, parSize);
    }

    private Pair<Integer, Long> estimateFederatedEventCount(ArrayList<RemoteSearchInfo> remoteSearchInfoArrayList, ArrayList<String> remoteSidList, HashMap<String, List<String>> dataSetToRemoteSid, HashMap<String, Integer> logicalToFieldNum, ExecutionHints hints) {
        int numPartitions = 1;
        long parSize = Long.MAX_VALUE;
        long fshEventCount = 0L;
        int maxFshNumFields = 0;
        int sidCntr = 0;
        logger.info((Object)String.format("The number of federated datasets being executed is %d.", this.datasetInfoMap.size()));
        for (FederatedDataSetInfo dsInfo : this.datasetInfoMap.values()) {
            String curRemoteSid = remoteSidList.get(sidCntr);
            ++sidCntr;
            fshEventCount += dsInfo.getEstimatedEventCount().longValue();
            maxFshNumFields = Math.max(maxFshNumFields, dsInfo.getNumFields());
            remoteSearchInfoArrayList.add(new RemoteSearchInfo(curRemoteSid, -1));
            logicalToFieldNum.put(curRemoteSid, dsInfo.getNumFields());
        }
        logger.info((Object)String.format("For federated datasets total event count=%d and number of fields=%d", fshEventCount, maxFshNumFields));
        long maxRecords = DFSSearchExecutor.getMaxRdOutRecords(fshEventCount);
        int fshNumPartitions = DFSSearchExecutor.getRdInPartitionsForFSH(hints, maxRecords, maxFshNumFields);
        parSize = Math.min(parSize, Math.max(1L, maxRecords / (long)fshNumPartitions));
        return new Pair<Integer, Long>(numPartitions, parSize);
    }

    private void closeConnectionToSplunkdSCP(Throwable t) {
        if (this.bw != null && t != null) {
            try {
                this.bw.write(String.format("%s,error from dfc: %s\n", t.getMessage()));
            }
            catch (Throwable t1) {
                logger.error((Object)String.format("Error writing response to splunkd search child process: %s, reason: %s", this.sid, t.getMessage()), t);
            }
        }
        if (this.br != null) {
            try {
                this.br.close();
            }
            catch (Throwable t1) {
                logger.error((Object)String.format("Error closing read stream with splunkd search child process: sid: %s, reason: %s", this.sid, t1.getMessage()), t1);
            }
        }
        if (this.bw != null) {
            try {
                this.bw.close();
            }
            catch (Throwable t1) {
                logger.error((Object)String.format("Error closing write stream with splunkd search child process: sid: %s, reason: %s", this.sid, t1.getMessage()), t1);
            }
        }
    }

    private static Pair<SearchResult, Pair<JSONObject, String>> getSri(Iterator<SearchResult> sris, HashMap<String, Pair<String, String>> remoteSidToDataSetDeployment) {
        SearchResult retSr = null;
        long totalUnread = 0L;
        long totalRecs = 0L;
        long totalReadTime = 0L;
        long totalWriteTime = 0L;
        ArrayList<String> fshMetricsArray = new ArrayList<String>();
        long consolidatedEventCount = 0L;
        long consolidatedScanCount = 0L;
        long consolidatedResultCount = 0L;
        HashSet<String> fshTracker = new HashSet<String>();
        JSONObject fshConsolidated = null;
        int numSris = 0;
        while (sris.hasNext()) {
            ++numSris;
            SearchResult sr = sris.next();
            if (sr.getDataMap().isEmpty()) continue;
            retSr = sr;
            if (retSr.containsField(RDIN_NUM_UNREAD_SRS)) {
                long unread = (Long)retSr.getDataMap().get(RDIN_NUM_UNREAD_SRS);
                totalUnread += unread;
            }
            if (retSr.containsField(RDIN_CACHE_READ_STATS)) {
                long[] rdinstats = (long[])retSr.getDataMap().get(RDIN_CACHE_READ_STATS);
                totalRecs += rdinstats[0];
                totalWriteTime += rdinstats[1];
                totalReadTime += rdinstats[2];
            }
            if (!retSr.containsField(FSH_REMOTE_METRICS)) continue;
            List fshMetricsInfoList = (List)retSr.getDataMap().get(FSH_REMOTE_METRICS);
            logger.info((Object)("Number of fshMetrics: " + fshMetricsInfoList.size()));
            for (FSHMetricsInfo fshMetricsInfo : fshMetricsInfoList) {
                if (fshMetricsInfo == null) {
                    logger.warn((Object)"FSH metrics is null, should not happen since dfs workers already filter out null metrics");
                    continue;
                }
                if (fshTracker.contains(fshMetricsInfo.getRemoteSid())) continue;
                Pair<String, String> info = remoteSidToDataSetDeployment.get(fshMetricsInfo.getRemoteSid());
                fshMetricsInfo.setDataSetName(info.first());
                fshMetricsInfo.setDeploymentName(info.second());
                consolidatedEventCount += (long)fshMetricsInfo.getEventCount();
                consolidatedResultCount += (long)fshMetricsInfo.getResultCount();
                consolidatedScanCount += (long)fshMetricsInfo.getScanCount();
                DFSSearchExecutor.lookupAndPopulate(fshMetricsInfo);
                fshMetricsArray.add(fshMetricsInfo.toString());
                fshTracker.add(fshMetricsInfo.getRemoteSid());
            }
        }
        StringBuilder sb = new StringBuilder();
        if (fshMetricsArray.size() > 0) {
            fshMetricsArray.add(String.format("FSH Total Counts: totalEventCount=%d totalScanCount=%d totalResultCount=%d ", consolidatedEventCount, consolidatedScanCount, consolidatedResultCount));
            fshConsolidated = new JSONObject();
            fshConsolidated.put("_fsh_consolidated_event_count", consolidatedEventCount);
            fshConsolidated.put("_fsh_consolidated_scan_count", consolidatedScanCount);
            fshConsolidated.put("_fsh_consolidated_result_count", consolidatedResultCount);
            for (String s : fshMetricsArray) {
                sb.append(s);
                sb.append("#");
            }
        }
        logger.info((Object)("FSH metrics collected at the DFC:" + sb.toString()));
        logger.debug((Object)String.format("Number of sris read: %d", numSris));
        retSr.getDataMap().put(RDIN_NUM_UNREAD_SRS, totalUnread);
        retSr.getDataMap().put(RDIN_TOTAL_RECS_READ, totalRecs);
        retSr.getDataMap().put(RDIN_TOTAL_READ_TIME, totalReadTime);
        retSr.getDataMap().put(RDIN_TOTAL_WRITE_TIME, totalWriteTime);
        Pair<JSONObject, String> toSend = new Pair<JSONObject, String>(fshConsolidated, sb.toString());
        return new Pair<SearchResult, Pair<JSONObject, String>>(retSr, toSend);
    }

    private static void lookupAndPopulate(FSHMetricsInfo fshMetricsInfo) {
    }

    private static void close(Object receiver) throws IOException {
        if (receiver == null) {
            return;
        }
        if (receiver instanceof SearchResultsReceiverStreaming) {
            SearchResultsReceiverStreaming srr = (SearchResultsReceiverStreaming)receiver;
            srr.close();
        }
    }

    private static SearchResult.FieldMeta[] convertToArray(Collection<SearchResult.FieldMeta> fields) {
        SearchResult.FieldMeta[] fieldsMeta = new SearchResult.FieldMeta[fields.size()];
        Iterator<SearchResult.FieldMeta> iter = fields.iterator();
        int i = 0;
        while (iter.hasNext()) {
            SearchResult.FieldMeta field;
            fieldsMeta[i] = field = iter.next();
            ++i;
        }
        return fieldsMeta;
    }

    public static SearchResult.FieldMeta[] getSriKeys(SearchResult sri) {
        if (!isSRIKeysCached) {
            SearchResult.SRHashMap<SearchResult.FieldMeta, Object> sriData = sri.getDataMap();
            Set<SearchResult.FieldMeta> sriKeys = sriData.keySet();
            sriKeysCached = DFSSearchExecutor.convertToArray(sriKeys);
            logger.info((Object)("SRI Header " + Arrays.toString(sriKeysCached)));
            isSRIKeysCached = true;
        }
        return sriKeysCached;
    }

    private static Pair<SearchResult, Pair<JSONObject, String>> processSri(ArrayList<SearchResult> sris, String sid, HashMap<String, Pair<String, String>> remoteSidToDataSetDeployment) {
        Pair<SearchResult, Pair<JSONObject, String>> info = DFSSearchExecutor.getSri(sris.iterator(), remoteSidToDataSetDeployment);
        SearchResult sri = info.first();
        if (sri == null) {
            throw new DFSException(logger, String.format("Could not find sri for search: sid: %s", sid));
        }
        logger.debug((Object)String.format("SRI processing done, %s", sri.toString()));
        return info;
    }

    private static ArrayList<SearchResult> getSriList(DistributedDataset dd) {
        ArrayList<SearchResult> srs = new ArrayList<SearchResult>();
        Iterator<SearchResult> itr = dd.retrieve();
        while (itr.hasNext()) {
            srs.add(itr.next());
        }
        return srs;
    }

    private static boolean processLogs(ArrayList<SearchResult> sris, boolean downloadRemoteLog) {
        if (!downloadRemoteLog) {
            return true;
        }
        logger.debug((Object)"Gathering executor logs..");
        Iterator<SearchResult> logItr = sris.iterator();
        HashMap<SearchResult.FieldMeta, List> remoteLogs = new HashMap<SearchResult.FieldMeta, List>();
        while (logItr.hasNext()) {
            String receiver;
            SearchResult.FieldMeta fm;
            SearchResult sr = logItr.next();
            if (sr.getDataMap().isEmpty() || !sr.containsField(DFC_RECEIVER_HOST) || !sr.containsField(fm = SearchResult.FieldMeta.newFieldMeta(receiver = (String)sr.getFieldValue(DFC_RECEIVER_HOST))) || remoteLogs.containsKey(fm)) continue;
            remoteLogs.put(fm, (List)sr.getFieldValue(fm));
        }
        File remoteLogDir = new File(new File(System.getProperty("DISPATCH_DIR"), "phase_dfs"), "remote_logs");
        Iterator it = remoteLogs.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry pair = it.next();
            File remoteLogFile = new File(remoteLogDir, pair.getKey() + "." + "dfs.log");
            try {
                logger.debug((Object)("Writing log " + remoteLogFile.toString()));
                FileUtils.writeLines((File)remoteLogFile, (String)StandardCharsets.UTF_8.name(), (Collection)((List)pair.getValue()));
            }
            catch (IOException ex) {
                logger.error((Object)("Exception writing log " + remoteLogFile.toString()));
            }
            it.remove();
        }
        return true;
    }

    private static int estimateNumFlds(DistributedDataset srdd) {
        List<SearchResult> sample = srdd.retrieve(100);
        Iterator<SearchResult> iter = sample.iterator();
        int numFlds = -1;
        while (iter.hasNext()) {
            SearchResult sr = iter.next();
            int srNumFlds = sr.getDataMap().size();
            numFlds = Math.max(srNumFlds, numFlds);
        }
        if (numFlds < 1) {
            numFlds = 6;
        }
        return numFlds;
    }

    private void dispatchResults(DistributedDataset srdd, LinkedBlockingDeque<ChunkToDispatch> chunkDispatchQueue, boolean[] shutdownDispatch, Throwable[] abort, String sid, ComputeEngineContext ctx, HashMap<String, Pair<String, String>> remoteSidToDataSetDeployment) {
        SearchResultsReceiverStreaming srr = null;
        try {
            boolean firstSR = true;
            srdd = srdd.cacheDisk();
            long count = srdd.count();
            if (!srdd.ordered()) {
                int numFlds = DFSSearchExecutor.estimateNumFlds(srdd);
                logger.info((Object)String.format("estimated number of fields in the search results: %d", numFlds));
                ExecutionHints hints = (ExecutionHints)ctx.get("execution.hints");
                if (hints != null) {
                    int numPars = hints.defaultPartitionCount(count, numFlds);
                    if (numPars < srdd.partitions()) {
                        int oldPars = srdd.partitions();
                        srdd = srdd.coalesce(numPars);
                        logger.info((Object)String.format("reduced partition count of the results dd to: %d, previous: %d", srdd.partitions(), oldPars));
                    } else {
                        logger.info((Object)String.format("results dd num partitions: %d is less or equal to the calculated: %d hence will not change:", srdd.partitions(), numPars));
                    }
                }
            }
            logger.info((Object)String.format("number of partitions in results dd: %d", srdd.partitions()));
            DistributedDataset sriDD = srdd.getsriDD();
            logger.debug((Object)String.format("Number of partitions of the sri dd: %d", sriDD.partitions()));
            Iterator<SearchResult> sriItr = sriDD.retrieve();
            ArrayList<SearchResult> sris = new ArrayList<SearchResult>();
            while (sriItr.hasNext()) {
                sris.add(sriItr.next());
            }
            Pair<SearchResult, Pair<JSONObject, String>> sriInfo = DFSSearchExecutor.processSri(sris, sid, remoteSidToDataSetDeployment);
            SearchResult consolidatedSri = sriInfo.first();
            long totalUnreadSrs = (Long)consolidatedSri.getFieldValue(RDIN_NUM_UNREAD_SRS);
            long totalRdinRecs = (Long)consolidatedSri.getFieldValue(RDIN_TOTAL_RECS_READ);
            long totalRdinReadTime = (Long)consolidatedSri.getFieldValue(RDIN_TOTAL_READ_TIME);
            long totalRdinWriteTime = (Long)consolidatedSri.getFieldValue(RDIN_TOTAL_WRITE_TIME);
            double rdinReadTimePerRec = (double)totalRdinReadTime / (double)totalRdinRecs;
            double rdinWriteTimePerRec = (double)totalRdinWriteTime / (double)totalRdinRecs;
            if (totalUnreadSrs > 0L) {
                logger.warn((Object)String.format("Rdin could not process all records (unread recs: %d) due to lack of read partitions", totalUnreadSrs));
            }
            logger.debug((Object)String.format("num rdin recs: %d, write time: %d millis,  read time: %d millis, write millis per record: %.5f, read millis per record: %.5f", totalRdinRecs, totalRdinWriteTime, totalRdinReadTime, rdinWriteTimePerRec, rdinReadTimePerRec));
            logger.info((Object)("DFS EXECUTION STATE: " + this.dfsExecutionState.toString()));
            if (this.dfsExecutionState != DFSExecutionState.LOCAL_ONLY) {
                Pair<JSONObject, String> fshInfo = sriInfo.second();
                this.searchResultsInfo.getSRI().getDataMap().put(FSH_CONSOLIDATED_METRICS, fshInfo.first());
                this.searchResultsInfo.getSRI().getDataMap().put(FSH_REMOTE_METRICS, fshInfo.second());
                logger.debug((Object)("Adding to SRI: " + sriInfo.second()));
            }
            boolean[] toAddWarning = new boolean[]{false};
            if (totalUnreadSrs > 0L) {
                String message = String.format("Number of SearchResults not processed is %d, please increase either DEFAULT_PARTITION_BOOST or DFS_RDIN_BOOST.", totalUnreadSrs);
                this.searchResultsInfo.addWarning(message);
                toAddWarning[0] = true;
            }
            String[] sriKeys = SearchResultsWriter.convert(DFSSearchExecutor.getSriKeys(this.searchResultsInfo.getSRI()));
            logger.info((Object)String.format("dag to be executed for fetching final search results: %s, number of records: %d", srdd.toString(), count));
            if (SSLConfig.getInstance().isTlsEnabled()) {
                srr = new SearchResultsReceiverStreaming(sid, 19000, 500, srdd, Long.MAX_VALUE, this.dfcIpAddress);
                logger.info((Object)String.format("Will execute streaming reads since tls is enabled, number of records: %s", count));
            } else if (count < 100000L) {
                srr = srdd.retrieve();
                logger.info((Object)String.format("Will bulk fetch since the number of records is low: %d", count));
            } else {
                srr = new SearchResultsReceiverStreaming(sid, 19000, 500, srdd, Long.MAX_VALUE, this.dfcIpAddress);
                logger.info((Object)String.format("Will execute streaming reads since records are higher: %d", count));
            }
            SearchResultsReceiverStreaming srsItr = srr;
            ArrayList<SearchResult> toSendSRChunk = new ArrayList<SearchResult>(this.DEFAULT_MAX_SEARCH_RESULTS);
            HashSet<SearchResult.FieldMeta> srKeys = new HashSet<SearchResult.FieldMeta>();
            long srsCounter = 0L;
            long headerCost = 0L;
            while (srsItr.hasNext()) {
                SearchResult sr = (SearchResult)srsItr.next();
                ++srsCounter;
                if (count <= 1000L && logger.isDebugEnabled()) {
                    logger.debug((Object)String.format("Received sr: %s", sr.toString()));
                }
                if (abort[0] != null) {
                    logger.error((Object)"DispatchQueue Thread has aborted, DFC will not be sending any more results to Splunk Search Process");
                    throw new IllegalStateException("DispatchQueue has shutdown, search:" + sid + " aborted; possible cause timeout.");
                }
                long start = System.currentTimeMillis();
                boolean keysChanged = Utils.updateHeaderFields(srKeys, sr);
                headerCost += System.currentTimeMillis() - start;
                if (keysChanged) {
                    logger.debug((Object)String.format("Search results keys have changed hence the header to search head would change: new keys: %s", srKeys.toString()));
                }
                if (firstSR) {
                    logger.debug((Object)("SR Header " + srKeys.toString()));
                    firstSR = false;
                }
                toSendSRChunk.add(sr);
                if (toSendSRChunk.size() < this.DEFAULT_MAX_SEARCH_RESULTS) continue;
                this.sendToDispatchQueue(toSendSRChunk, this.searchResultsInfo.getSRI(), srKeys, sriKeys, chunkDispatchQueue, abort, toAddWarning);
                logger.info((Object)String.format("Pushed %d srs to splunkd dispatch queue, total srs dispatched till now: %d", toSendSRChunk.size(), srsCounter));
                toSendSRChunk.clear();
            }
            if (!toSendSRChunk.isEmpty()) {
                this.searchResultsInfo.getSRI().getDataMap().put(REMOTE_SEARCH_QUERY_FINISHED, true);
                this.sendToDispatchQueue(toSendSRChunk, this.searchResultsInfo.getSRI(), srKeys, sriKeys, chunkDispatchQueue, abort, toAddWarning);
                logger.info((Object)String.format("Pushed %d srs to splunkd dispatch queue, total srs dispatched till now: %d", toSendSRChunk.size(), srsCounter));
                toSendSRChunk.clear();
            }
            logger.info((Object)String.format("Will close the receiver since all records read", new Object[0]));
            DFSSearchExecutor.close(srr);
            logger.info((Object)String.format("Cost of processing header for all records: %d millis, number of records processed: %d", headerCost, count));
            logger.info((Object)String.format("Search has ended and all possible search results (count: %d, actual srses received: %d) have been pushed to the dispatch queue", count, srsCounter));
            sriItr = sriDD.retrieve();
            sris.clear();
            while (sriItr.hasNext()) {
                sris.add(sriItr.next());
            }
            this.processedLogs = DFSSearchExecutor.processLogs(sris, Utils.isDownloadRemoteLogEnabled(ctx));
            shutdownDispatch[0] = true;
        }
        catch (Throwable t) {
            logger.error((Object)"Receiver error", t);
            if (srr != null) {
                try {
                    DFSSearchExecutor.close(srr);
                }
                catch (Throwable t1) {
                    logger.error((Object)String.format("Error closing the search results receiver, reason: %s, sid: %s", t1.getMessage(), sid));
                }
            }
            throw new DFSException(logger, String.format("Error dispatching search results (sid=%s), reason=%s", sid, t.getMessage()), t);
        }
    }

    private void sendToDispatchQueue(ArrayList<SearchResult> toSendSRChunk, SearchResult sri, HashSet<SearchResult.FieldMeta> srkeys, String[] sriKeys, LinkedBlockingDeque<ChunkToDispatch> chunkDispatchQueue, Throwable[] abort, boolean[] toAddWarning) throws IOException, InterruptedException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BufferedWriter chunkWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)baos, StandardCharsets.UTF_8));
        SearchResult.FieldMeta[] srKeysArr = DFSSearchExecutor.convertToArray(srkeys);
        CSVPrinter csvPrinter = CSVFormat.DEFAULT.withHeader(SearchResultsWriter.convert(srKeysArr)).print((Appendable)chunkWriter);
        for (int i = 0; i < toSendSRChunk.size(); ++i) {
            SearchResult.SRHashMap<SearchResult.FieldMeta, Object> data = toSendSRChunk.get(i).getDataMap();
            for (int j = 0; j < srKeysArr.length; ++j) {
                SearchResult.FieldMeta key = srKeysArr[j];
                Object value = ((HashMap)data).get(key);
                if (value == null || value != null && value instanceof SearchResultFactory.NullField || value != null && value.toString().equals("__null__")) {
                    csvPrinter.print((Object)"");
                    continue;
                }
                csvPrinter.print(value);
            }
            csvPrinter.println();
        }
        csvPrinter.flush();
        String srsPayload = new String(baos.toByteArray(), StandardCharsets.UTF_8);
        baos = new ByteArrayOutputStream();
        chunkWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)baos, StandardCharsets.UTF_8));
        csvPrinter = CSVFormat.DEFAULT.withHeader(sriKeys).print((Appendable)chunkWriter);
        Object[] sriValues = new Object[sriKeys.length];
        System.arraycopy(sri.getDataMap().values().toArray(), 0, sriValues, 0, sriKeys.length);
        csvPrinter.printRecord(sriValues);
        if (toAddWarning[0]) {
            csvPrinter.printRecord(sriValues);
            toAddWarning[0] = false;
        }
        csvPrinter.flush();
        String sriPayload = new String(baos.toByteArray(), StandardCharsets.UTF_8);
        ChunkToDispatch chunkToDispatch = new ChunkToDispatch(sriPayload, srsPayload);
        while (!chunkDispatchQueue.offer(chunkToDispatch, 1L, TimeUnit.SECONDS)) {
            if (abort[0] == null) continue;
            throw new DFSException(logger, String.format("Aborting search results dispatch (sid: %s) since abort requested due to error: %s", this.sid, abort[0].getMessage()), abort[0]);
        }
    }

    private int sendResponseAndReceive() {
        JSONObject toSend = this.createResponseToSplunkSP();
        try {
            String payload = String.format("%s,%s\n", DFSProtocolConstants.PROTO_DFS_ACK.toString(), toSend.toString());
            this.bw.write(payload);
            this.bw.flush();
            logger.info((Object)String.format("Payload sent to splunkd: %s", payload));
            this.ackSent = true;
            Instant start = Instant.now();
            while (!this.br.ready()) {
                if (Duration.between(start, Instant.now()).toMillis() > 900000L) {
                    this.exceededTimeout = true;
                    throw new DFSException("Timeout exceeded while waiting for trigger from Splunk search process to execute search \n");
                }
                if (!this.connection.isConnected()) {
                    String error = String.format("connection closed: %s", this.sid);
                    throw new RuntimeException(error);
                }
                try {
                    Thread.sleep(10L);
                }
                catch (Throwable error) {}
            }
            String request = this.br.readLine();
            if (request == null) {
                throw new DFSException(logger, String.format("Splunkd returned null response: %s", this.sid));
            }
            logger.info((Object)("Splunk Search Process has started the distributed search execution, notifying DFC:request received at DFC from  Splunkd:--->" + request));
            if (request.startsWith(DFSProtocolConstants.PROTO_DFS_RUN_SEARCH.toString())) {
                request = request.substring(DFSProtocolConstants.PROTO_DFS_RUN_SEARCH.toString().length() + 1);
                logger.debug((Object)String.format("Meta info received from sh (%s): %s", this.sid, request));
                JSONObject j = new JSONObject(request);
                JSONArray a = j.getJSONArray("splunkpeers");
                for (int i = 0; i < a.length(); ++i) {
                    String[] split = a.getString(i).split(":");
                    this.splunkPeerList.add(new HostPort(split[0], Integer.parseInt(split[1])));
                }
                this.maxKeepAliveTime = (long)j.getDouble(DFSProtocolConstants.PROTO_DFS_KEEPALIVE.toString());
                this.maxNumKeepAlive = j.getInt(DFSProtocolConstants.PROTO_DFS_MAX_NUM_KEEPALIVE.toString());
                if (this.maxKeepAliveTime <= 0L) {
                    logger.warn((Object)("Invalid splunkd side time out specified: " + this.maxKeepAliveTime));
                    this.maxKeepAliveTime = 900L;
                } else {
                    this.maxKeepAliveTime = (long)Math.ceil((double)this.maxKeepAliveTime / 4.0);
                }
                this.maxKeepAliveTime *= 1000L;
                if (this.dfsExecutionState == DFSExecutionState.LOCAL_ONLY) {
                    return this.splunkPeerList.size();
                }
                return 1;
            }
            throw new DFSException(logger, String.format("Received incorrect response from splunk search process: %s", request));
        }
        catch (Throwable t) {
            throw new DFSException(logger, "Error communicating with splunk search process", t);
        }
    }

    private JSONObject createResponseToSplunkSP() {
        JSONObject response = null;
        switch (this.dfsExecutionState) {
            case LOCAL_ONLY: {
                response = this.createLocalOnlyJsonPayload();
                break;
            }
            case FEDERATED_ONLY: {
                response = this.createFederatedOnlyJsonPayload();
                break;
            }
            case MIXED_MODE: {
                response = this.createLocalOnlyJsonPayload();
                break;
            }
            case UNKNOWN: {
                throw new UnsupportedOperationException("DFS:Unknown execution state.");
            }
        }
        return response;
    }

    private JSONObject createFederatedOnlyJsonPayload() {
        JSONObject obj = new JSONObject();
        JSONObject dfsObject = new JSONObject();
        dfsObject.put("dfsExecutionMode", this.dfsExecutionState.ordinal());
        dfsObject.put("dfsSearch", this.dfsPhaseFacilitator.getDFSPhase().accept((NodeVisitor)new SplFormatter()));
        JSONArray sidList = new JSONArray();
        dfsObject.put("remoteSID", (Object)sidList);
        JSONArray columnOrder = new JSONArray();
        for (String coOrder : this.dfsPhaseFacilitator.getColumnOrder()) {
            columnOrder.put((Object)coOrder);
        }
        dfsObject.put("columnOrder", (Object)columnOrder);
        JSONArray remoteSearchList = new JSONArray();
        dfsObject.put("remoteSearches", (Object)remoteSearchList);
        JSONArray orderArray = new JSONArray();
        JSONObject object = new JSONObject();
        object.put("field", (Object)"_time");
        object.put("ASC", (Object)"false");
        orderArray.put((Object)object);
        dfsObject.put("orderInfo", (Object)orderArray);
        JSONObject meta = new JSONObject();
        meta.put("isStartPaused", false);
        meta.put("allowRemoteTimeLine", false);
        meta.put("shouldShortCircuit", false);
        meta.put("isPrevPhaseOrdered", true);
        meta.put("FshOnlyExecution", this.dfsExecutionState == DFSExecutionState.FEDERATED_ONLY);
        dfsObject.put("metaInfo", (Object)meta);
        obj.put("dfsInfo", (Object)dfsObject);
        return obj;
    }

    private JSONObject createLocalOnlyJsonPayload() {
        JSONObject obj = new JSONObject();
        JSONObject dfsObject = new JSONObject();
        dfsObject.put("dfsExecutionMode", this.dfsExecutionState.ordinal());
        dfsObject.put("dfsSearch", this.dfsPhaseFacilitator.getDFSPhase().accept((NodeVisitor)new SplFormatter()));
        JSONArray sidList = new JSONArray();
        for (String string : this.dfsSidGenerator.getToSendSidList()) {
            sidList.put((Object)string);
        }
        dfsObject.put("remoteSID", (Object)sidList);
        JSONArray columnOrder = new JSONArray();
        for (String string : this.dfsPhaseFacilitator.getColumnOrder()) {
            columnOrder.put((Object)string);
        }
        dfsObject.put("columnOrder", (Object)columnOrder);
        JSONArray jSONArray = new JSONArray();
        for (String search : this.dfsPhaseFacilitator.getRemoteSearchJobs()) {
            jSONArray.put((Object)search);
            logger.debug((Object)String.format("remote search: %s", search));
        }
        dfsObject.put("remoteSearches", (Object)jSONArray);
        JSONArray jSONArray2 = new JSONArray();
        for (CommandOrderInfo coInfo : this.dfsPhaseFacilitator.getOrderForSearchPhases()) {
            JSONObject object = new JSONObject();
            object.put("field", (Object)coInfo.getOrderField());
            object.put("ASC", coInfo.getOrder());
            jSONArray2.put((Object)object);
        }
        dfsObject.put("orderInfo", (Object)jSONArray2);
        JSONObject meta = new JSONObject();
        meta.put("isStartPaused", this.dfsPhaseFacilitator.isSearchStartPaused());
        meta.put("allowRemoteTimeLine", false);
        meta.put("shouldShortCircuit", this.dfsPhaseFacilitator.isShortCircuit());
        meta.put("isPrevPhaseOrdered", true);
        meta.put("FshOnlyExecution", this.dfsExecutionState == DFSExecutionState.FEDERATED_ONLY);
        dfsObject.put("metaInfo", (Object)meta);
        obj.put("dfsInfo", (Object)dfsObject);
        return obj;
    }
}

