/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search.compute;

import com.splunk.df.search.compute.SearchResult;
import com.splunk.df.search.compute.SearchResultFactory;
import com.splunk.df.util.MultiValueFieldParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.csv.CSVRecord;
import org.apache.log4j.Logger;

public class SearchResultImpl
implements SearchResult {
    static final Logger logger = Logger.getLogger(SearchResultImpl.class);
    private static final long serialVersionUID = 1L;
    private int cachedHashCode;
    private boolean dirty = true;
    private boolean hashCodeCalculated = false;
    private String sid;
    private Long seed;
    private final SearchResult.SRHashMap<SearchResult.FieldMeta, Object> data;
    private SearchResult.FieldMeta[] fieldNames;
    private Object[] fieldValues;
    private final int size;

    SearchResultImpl(SearchResult.FieldMeta[] fieldNames, Object[] fieldValues) {
        int len;
        SearchResult.SRHashMap<SearchResult.FieldMeta, Object> localData = new SearchResult.SRHashMap<SearchResult.FieldMeta, Object>(fieldNames.length * 2);
        this.fieldNames = fieldNames;
        this.fieldValues = fieldValues;
        this.size = len = fieldNames.length;
        for (int i = 0; i < len; ++i) {
            localData.put(fieldNames[i], fieldValues[i]);
        }
        this.data = localData;
    }

    SearchResultImpl(SearchResult src) {
        SearchResult.SRHashMap<SearchResult.FieldMeta, Object> data = new SearchResult.SRHashMap<SearchResult.FieldMeta, Object>((Map<SearchResult.FieldMeta, Object>)src.getDataMap());
        SearchResult.FieldMeta[] srcFlds = src.getFieldNames();
        Object[] srcVals = src.getFieldValues();
        SearchResult.FieldMeta[] fields = new SearchResult.FieldMeta[srcFlds.length];
        Object[] vals = new Object[srcVals.length];
        System.arraycopy(src.getFieldNames(), 0, fields, 0, srcFlds.length);
        System.arraycopy(srcVals, 0, vals, 0, srcVals.length);
        this.data = data;
        this.fieldNames = fields;
        this.fieldValues = vals;
        this.size = this.fieldNames.length;
    }

    SearchResultImpl(SearchResult.SRHashMap<SearchResult.FieldMeta, Object> data, SearchResult.FieldMeta[] fieldNames, Object[] fieldValues) {
        this.data = data;
        this.fieldNames = fieldNames;
        this.fieldValues = fieldValues;
        this.size = this.fieldNames.length;
    }

    SearchResultImpl(SearchResult.FieldMeta[] fieldNames, CSVRecord csvData) {
        int metadataSize = fieldNames.length;
        SearchResult.SRHashMap<SearchResult.FieldMeta, Object> localData = new SearchResult.SRHashMap<SearchResult.FieldMeta, Object>(metadataSize * 2);
        this.data = localData;
        this.size = metadataSize;
        SearchResult.FieldMeta[] locFieldNames = fieldNames;
        this.fieldNames = locFieldNames;
        Object[] localFieldValues = new Object[metadataSize];
        this.fieldValues = localFieldValues;
        int dataSize = csvData.size();
        for (int i = 0; i < metadataSize; ++i) {
            SearchResult.FieldMeta fieldName = fieldNames[i];
            Object fieldValue = null;
            if (i >= dataSize) continue;
            String fieldValueStr = csvData.get(i);
            SearchResult.FieldType type = fieldName.type();
            fieldValue = SearchResultImpl.getFieldValue(fieldName, type, fieldValueStr);
            localData.put(fieldName, fieldValue);
            localFieldValues[i] = fieldValue;
        }
    }

    private int getHashCode(SearchResult.FieldMeta[] fieldNames, Object[] fieldValues) {
        if (!this.dirty && this.hashCodeCalculated) {
            return this.cachedHashCode;
        }
        int prime = 31;
        int hashCode = 1;
        for (Object fieldValue : fieldValues) {
            hashCode = hashCode * 31 + (fieldValue != null ? fieldValue.hashCode() : 0);
        }
        if (this.seed != null) {
            hashCode = hashCode * 31 + this.seed.hashCode();
        }
        this.cachedHashCode = hashCode;
        this.hashCodeCalculated = true;
        this.dirty = false;
        return this.cachedHashCode;
    }

    private static Object getFieldValue(SearchResult.FieldMeta fieldName, SearchResult.FieldType type, String fieldValueStr) {
        if (type.equals((Object)SearchResult.FieldType.TIME_FIELD)) {
            return new SearchResultFactory.TimeField(fieldValueStr);
        }
        return new SearchResultFactory.StringField(fieldValueStr);
    }

    @Override
    public Object getFieldValue(SearchResult.FieldMeta fieldName) {
        return this.data.get(fieldName);
    }

    @Override
    public SearchResult.FieldMeta[] getFieldNames() {
        return this.fieldNames;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    public boolean equals(Object rhs) {
        if (rhs == null) {
            return false;
        }
        if (rhs == this) {
            return true;
        }
        SearchResult rhsSr = (SearchResult)rhs;
        if (rhsSr.getSize() != this.getSize()) {
            return false;
        }
        if (this.hashCode() != rhsSr.hashCode()) {
            return false;
        }
        int len = this.fieldNames.length;
        Object[] rhsVals = rhsSr.getFieldValues();
        Object[] lhsVals = this.fieldValues;
        for (int i = 0; i < len; ++i) {
            Object rhsVal = rhsVals[i];
            Object lhsVal = lhsVals[i];
            if (lhsVal == null && rhsVal == null) continue;
            if (lhsVal == null && rhsVal != null) {
                return false;
            }
            if (lhsVal != null && rhsVal == null) {
                return false;
            }
            if (lhsVal == rhsVal) continue;
            if (lhsVal.hashCode() != rhsVal.hashCode()) {
                return false;
            }
            if (lhsVal.equals(rhsVal)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsField(SearchResult.FieldMeta fieldName) {
        return this.data.containsKey(fieldName);
    }

    @Override
    public SearchResult.SRHashMap<SearchResult.FieldMeta, Object> getDataMap() {
        return this.data;
    }

    @Override
    public LinkedHashMap<SearchResult.FieldMeta, Object> getLinkedDataMap() {
        SearchResult.FieldMeta[] fieldNames;
        LinkedHashMap<SearchResult.FieldMeta, Object> dataMap = new LinkedHashMap<SearchResult.FieldMeta, Object>();
        for (SearchResult.FieldMeta fieldName : fieldNames = this.getFieldNames()) {
            dataMap.put(fieldName, this.data.get(fieldName));
        }
        return dataMap;
    }

    public int hashCode() {
        return this.getHashCode(this.fieldNames, this.fieldValues);
    }

    @Override
    public Object[] getFieldValues() {
        return this.fieldValues;
    }

    public String toString() {
        return Arrays.toString(this.data.entrySet().toArray());
    }

    @Override
    public void updateField(SearchResult.FieldMeta fieldName, Object fieldValue) {
        this.data.put(fieldName, fieldValue);
        this.fieldNames = this.data.keySet().toArray(new SearchResult.FieldMeta[this.fieldNames.length]);
        this.fieldValues = this.data.values().toArray(new Object[this.fieldValues.length]);
        this.dirty = true;
    }

    @Override
    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public void renameField(SearchResult.FieldMeta oldName, SearchResult.FieldMeta newName) {
        this.data.put(newName, this.data.remove(oldName));
        this.fieldNames = this.data.keySet().toArray(new SearchResult.FieldMeta[this.fieldNames.length]);
        this.fieldValues = this.data.values().toArray(new Object[this.fieldValues.length]);
        this.dirty = true;
    }

    public int compareTo(Object rhs) {
        SearchResult rhsSr = (SearchResult)rhs;
        Object[] rhsVals = rhsSr.getFieldValues();
        SearchResult.FieldMeta[] lhsFields = this.getFieldNames();
        Object[] lhsVals = this.getFieldValues();
        int len = lhsFields.length;
        for (int i = 0; i < len; ++i) {
            Object lhsVal = lhsVals[i];
            Object rhsVal = rhsVals[i];
            int ret = SearchResultFactory.getInstance().compareTo(lhsVal, rhsVal);
            if (ret == 0) continue;
            return ret;
        }
        return 0;
    }

    @Override
    public void setSid(String sid) {
        this.sid = sid;
    }

    @Override
    public String sid() {
        return this.sid;
    }

    @Override
    public SearchResult filterMVs() {
        SearchResult.FieldMeta field;
        int i;
        SearchResult.FieldMeta[] fields = this.fieldNames;
        Object[] vals = this.fieldValues;
        int len = fields.length;
        ArrayList<SearchResult.FieldMeta> retFlds = new ArrayList<SearchResult.FieldMeta>(len);
        ArrayList<Object> retVals = new ArrayList<Object>(len);
        SearchResult.SRHashMap<SearchResult.FieldMeta, Object> data = new SearchResult.SRHashMap<SearchResult.FieldMeta, Object>(len * 2);
        HashMap<String, String> mvFields = new HashMap<String, String>();
        for (i = 0; i < len; ++i) {
            field = fields[i];
            if (field.length() < "__mv_".length() || !field.fieldName().startsWith("__mv_") || vals[i] == null || String.valueOf(vals[i]).length() == 0) continue;
            mvFields.put(field.fieldName().substring("__mv_".length()), String.valueOf(vals[i]));
        }
        for (i = 0; i < len; ++i) {
            field = fields[i];
            Object val = vals[i];
            if (mvFields.containsKey(field.fieldName())) {
                retFlds.add(field);
                String[] parsedValues = MultiValueFieldParser.parse((String)mvFields.get(field.fieldName()));
                StringBuilder sb = new StringBuilder();
                for (String parsedValue : parsedValues) {
                    sb.append(parsedValue);
                    sb.append(" ");
                }
                if (sb.length() > 0) {
                    sb.setLength(sb.length() - 1);
                }
                retVals.add(sb.toString());
                data.put(field, sb.toString());
                continue;
            }
            if (field.length() >= "__mv_".length() && field.fieldName().startsWith("__mv_")) continue;
            retFlds.add(field);
            retVals.add(val);
            data.put(field, val);
        }
        len = retFlds.size();
        SearchResult.FieldMeta[] retFldsArr = new SearchResult.FieldMeta[len];
        Object[] retValsArr = new Object[len];
        for (int i2 = 0; i2 < len; ++i2) {
            retFldsArr[i2] = (SearchResult.FieldMeta)retFlds.get(i2);
            retValsArr[i2] = retVals.get(i2);
        }
        SearchResult ret = SearchResultFactory.getInstance().createSearchResult(data, retFldsArr, retValsArr);
        if (this.sid != null) {
            ret.setSid(this.sid);
        }
        return ret;
    }

    @Override
    public void setSeed(long seed) {
        this.seed = seed;
        this.dirty = true;
    }

    @Override
    public Long seed() {
        return this.seed;
    }
}

