/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search.compute;

import com.splunk.df.search.DFCRunnable;
import com.splunk.df.search.SearchResultsReader;
import com.splunk.df.search.SearchResultsWriter;
import com.splunk.df.search.compute.ComputeEngineConstants;
import com.splunk.df.search.compute.DistributedDataset;
import com.splunk.df.search.compute.MapPartitioner;
import com.splunk.df.search.compute.SearchResult;
import com.splunk.df.search.compute.sdk.Pair;
import com.splunk.df.search.compute.transformers.FieldExtractor;
import com.splunk.df.security.NIOTls;
import com.splunk.df.util.DFSException;
import com.splunk.df.util.Utils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLEngine;
import org.apache.log4j.Logger;

public class SearchResultsReceiverStreaming
implements Iterator<SearchResult>,
ComputeEngineConstants,
Closeable {
    static final Logger logger = Logger.getLogger(SearchResultsReceiverStreaming.class);
    private LinkedBlockingDeque<SearchResult> srcache = new LinkedBlockingDeque(500);
    private int numpars;
    private String host = null;
    private boolean[] shutdown = new boolean[1];
    private String sid;
    private Thread srreceiver;
    private Thread srtransmitter;
    private boolean closed;
    private SearchResult nextsr;

    private static void closeChannels(ServerSocketChannel serverSocketChannel, Selector selector) {
        if (serverSocketChannel != null && serverSocketChannel.isOpen()) {
            try {
                serverSocketChannel.close();
            }
            catch (IOException ex) {
                logger.error((Object)"CloseChannels::Exception while closing server socket :: ", (Throwable)ex);
            }
        }
        try {
            for (SelectionKey key : selector.keys()) {
                SelectableChannel channel = key.channel();
                if (!(channel instanceof SocketChannel)) continue;
                SocketChannel socketChannel = (SocketChannel)channel;
                Socket socket = socketChannel.socket();
                String remoteHost = socket.getRemoteSocketAddress().toString();
                try {
                    socketChannel.close();
                }
                catch (IOException ex) {
                    logger.error((Object)"CloseChannels::Exception while closing socket", (Throwable)ex);
                }
                key.cancel();
            }
            selector.close();
            logger.info((Object)"CloseChannels::selector closed");
        }
        catch (Exception ex) {
            logger.error((Object)"CloseChannels::Exception while closing selector", (Throwable)ex);
        }
    }

    public SearchResultsReceiverStreaming(final String sid, int port, int portCount, final DistributedDataset dd, final long numsrs, final String host) throws IOException {
        this.shutdown[0] = false;
        this.closed = false;
        this.nextsr = null;
        this.sid = sid;
        this.numpars = dd.partitions();
        logger.debug((Object)("Number of partitions to retrieve search results from=" + this.numpars));
        final Selector selector = Selector.open();
        Pair<ServerSocketChannel, Integer> socPort = NIOTls.bindWithRetries(host, port, portCount);
        final ServerSocketChannel serverSocketChannel = socPort.first();
        port = socPort.second();
        serverSocketChannel.configureBlocking(false);
        int ops = serverSocketChannel.validOps();
        serverSocketChannel.register(selector, ops, null);
        logger.info((Object)String.format("Started nio receiver on port: %s:%d, sid: %s", host, port, sid));
        final long[] srsCounter = new long[]{0L};
        final boolean[] receiverStarted = new boolean[]{false};
        this.srreceiver = new Thread(new DFCRunnable(true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void runInternal() throws Exception {
                try {
                    block10: while (true) {
                        int ready = selector.select(1000L);
                        receiverStarted[0] = true;
                        if (ready <= 0 && !SearchResultsReceiverStreaming.this.shutdown[0]) continue;
                        if (SearchResultsReceiverStreaming.this.shutdown[0]) {
                            try {
                                serverSocketChannel.close();
                                logger.info((Object)String.format("Closed receiver socket since shutdown requested: %s", sid));
                            }
                            catch (Throwable t) {
                                logger.error((Object)String.format("Error closing receiver channel %s, reason=%s", sid, t.getMessage()));
                            }
                            break;
                        }
                        Set<SelectionKey> clientKeys = selector.selectedKeys();
                        Iterator<SelectionKey> clientKeysIter = clientKeys.iterator();
                        while (true) {
                            Pair remainingBuffers;
                            if (!clientKeysIter.hasNext()) continue block10;
                            SelectionKey clientKey = clientKeysIter.next();
                            clientKeysIter.remove();
                            if (!clientKey.isValid()) {
                                logger.warn((Object)String.format("Ignoring channel key since it is not valid, sid=%s", sid));
                                continue;
                            }
                            if (clientKey.isAcceptable()) {
                                NIOTls.accept(clientKey, selector, false);
                                continue;
                            }
                            if (!clientKey.isReadable()) continue;
                            SocketChannel clientSocketChannel = (SocketChannel)clientKey.channel();
                            logger.debug((Object)String.format("Sender connection accepted from ip: %s %s", clientSocketChannel.getRemoteAddress().toString(), clientSocketChannel.getLocalAddress().toString()));
                            NIOTls.ChannelAttachment attachment = (NIOTls.ChannelAttachment)clientKey.attachment();
                            SSLEngine sslEngine = null;
                            if (attachment != null) {
                                sslEngine = attachment.sslEngine;
                            }
                            ByteBuffer intbuff = ByteBuffer.allocate(4);
                            ByteBuffer remainingNetBuffer = null;
                            ByteBuffer remainingAppBuffer = null;
                            if (attachment != null) {
                                remainingNetBuffer = attachment.remainingNetBuffer;
                                remainingAppBuffer = attachment.remainingAppBuffer;
                            }
                            if ((remainingBuffers = SearchResultsReceiverStreaming.this.read(clientSocketChannel, sslEngine, intbuff, remainingNetBuffer, remainingAppBuffer)) == null) {
                                logger.debug((Object)String.format("End of stream reached for sid: %s", sid));
                                continue;
                            }
                            if (sslEngine != null && attachment != null) {
                                if (remainingBuffers != null) {
                                    attachment.remainingNetBuffer = (ByteBuffer)remainingBuffers.first();
                                    attachment.remainingAppBuffer = (ByteBuffer)remainingBuffers.second();
                                } else {
                                    attachment.remainingNetBuffer.clear();
                                    attachment.remainingAppBuffer.clear();
                                    attachment.remainingNetBuffer = null;
                                    attachment.remainingAppBuffer = null;
                                }
                            }
                            int payloadSize = intbuff.getInt(0);
                            intbuff.clear();
                            ByteBuffer payloadBuff = ByteBuffer.allocate(payloadSize);
                            if (attachment != null) {
                                remainingNetBuffer = attachment.remainingNetBuffer;
                                remainingAppBuffer = attachment.remainingAppBuffer;
                            }
                            if ((remainingBuffers = SearchResultsReceiverStreaming.this.read(clientSocketChannel, sslEngine, payloadBuff, remainingNetBuffer, remainingAppBuffer)) == null) {
                                logger.info((Object)String.format("End of stream reached, sid: %s, remote client address: %s", sid, clientSocketChannel.getRemoteAddress().toString()));
                                throw new DFSException(logger, String.format("Cannot get end of stream here, was expecting the entire payload of size= %d", payloadSize));
                            }
                            if (sslEngine != null && attachment != null) {
                                if (remainingBuffers != null) {
                                    attachment.remainingNetBuffer = (ByteBuffer)remainingBuffers.first();
                                    attachment.remainingAppBuffer = (ByteBuffer)remainingBuffers.second();
                                } else {
                                    attachment.remainingNetBuffer.clear();
                                    attachment.remainingAppBuffer.clear();
                                    attachment.remainingNetBuffer = null;
                                    attachment.remainingAppBuffer = null;
                                }
                            }
                            byte[] payload = payloadBuff.array();
                            ByteArrayInputStream bais = new ByteArrayInputStream(payload);
                            SearchResultsReader srs = new SearchResultsReader(new InputStreamReader((InputStream)bais, StandardCharsets.UTF_8));
                            int numSrs = 0;
                            while (srs.hasNext()) {
                                SearchResult sr = (SearchResult)srs.next();
                                while (!SearchResultsReceiverStreaming.this.srcache.offer(sr, 1000L, TimeUnit.MILLISECONDS)) {
                                    if (!SearchResultsReceiverStreaming.this.shutdown[0]) continue;
                                    throw new DFSException(logger, String.format("Aborting pushing to cache since shutdown requested, sid=%s", sid));
                                }
                                srsCounter[0] = srsCounter[0] + 1L;
                                ++numSrs;
                            }
                            if (srsCounter[0] >= numsrs) {
                                logger.debug((Object)String.format("Received all required search results from the workers %s, will shutdown receiver", sid));
                                boolean[] blArray = SearchResultsReceiverStreaming.this.shutdown;
                                synchronized (blArray) {
                                    ((SearchResultsReceiverStreaming)SearchResultsReceiverStreaming.this).shutdown[0] = true;
                                }
                            }
                            intbuff.putInt(payloadSize);
                            NIOTls.write(clientSocketChannel, sslEngine, intbuff);
                            intbuff.clear();
                            if (SearchResultsReceiverStreaming.this.shutdown[0]) break;
                        }
                    }
                }
                catch (Throwable t) {
                    logger.error((Object)String.format("error while executing parallel reads from dfs workers: %s", t.getMessage()), t);
                    if (!SearchResultsReceiverStreaming.this.shutdown[0]) {
                        throw new DFSException(logger, "Error occurred=%s" + t.getMessage());
                    }
                    logger.warn((Object)String.format("Not raising alert since shutdown requested, sid=%s, but receiver received some traffic on the wire=%s", sid, t.getMessage()));
                }
                finally {
                    SearchResultsReceiverStreaming.closeChannels(serverSocketChannel, selector);
                }
                logger.info((Object)String.format("Chunked search results over nio server receiver thread completed, sid=%s", sid));
            }
        });
        final int fport = port;
        this.srreceiver.start();
        logger.info((Object)String.format("Receiver started and ready to accept connection: %d", fport));
        this.srtransmitter = new Thread(new DFCRunnable(true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void runInternal() throws Exception {
                logger.info((Object)String.format("About to transfer srs to the receiver= %s numsrs=%d", sid, numsrs));
                long srstoread = numsrs;
                if (dd.ordered()) {
                    logger.info((Object)String.format("Ordered streaming fetch would be executed which is slower than unordered fetch", new Object[0]));
                    for (int i = 0; i < SearchResultsReceiverStreaming.this.numpars; ++i) {
                        boolean[] blArray = SearchResultsReceiverStreaming.this.shutdown;
                        synchronized (blArray) {
                            if (SearchResultsReceiverStreaming.this.shutdown[0]) {
                                logger.warn((Object)String.format("Partition %d would not be processed since shutdown requested", i));
                                break;
                            }
                        }
                        if ((srstoread -= srsCounter[0]) > 0L) {
                            DistributedDataset transferdd = SearchResultsReceiverStreaming.createTransferSrsDD(dd, host, fport, sid, i, srstoread);
                            transferdd.count();
                            continue;
                        }
                        break;
                    }
                } else {
                    logger.info((Object)String.format("Unordered streaming fetch would be executed since dataset is not sorted", new Object[0]));
                    DistributedDataset transferdd = SearchResultsReceiverStreaming.createTransferSrsDD(dd, host, fport, sid, -1, srstoread);
                    transferdd.count();
                    logger.info((Object)String.format("Unordered streaming dispatch has completed", new Object[0]));
                }
                ((SearchResultsReceiverStreaming)SearchResultsReceiverStreaming.this).shutdown[0] = true;
                logger.info((Object)String.format("Worker to receiver srs transmitter thread completed: numpars: %d, sid: %s", SearchResultsReceiverStreaming.this.numpars, sid));
            }
        });
        this.srtransmitter.start();
    }

    private static DistributedDataset createTransferSrsDD(DistributedDataset dd, final String receiverHost, final int receiverPort, final String sid, int parid, final long numsrs) {
        DistributedDataset ret = dd.transform(new MapPartitioner(){
            private static final long serialVersionUID = 1L;

            @Override
            public FieldExtractor.ExtractionHint fieldExtractionHint() {
                return FieldExtractor.ExtractionHint.NOT_PRECOMPUTED;
            }

            @Override
            public boolean repartition() {
                return false;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public Iterator<SearchResult> mapPartitions(int parid, Iterator<SearchResult> srs) {
                long totalSrs;
                block21: {
                    SocketChannel clientChannel = null;
                    totalSrs = 0L;
                    Pair<SocketChannel, SSLEngine> pairSoc = null;
                    SSLEngine sslEngine = null;
                    try {
                        int chunkCounter = 0;
                        ArrayList<SearchResult> chunkSrs = new ArrayList<SearchResult>(100000);
                        HashSet<SearchResult.FieldMeta> srKeys = new HashSet<SearchResult.FieldMeta>();
                        SearchResult.FieldMeta[] fields = null;
                        boolean first = false;
                        int chunkId = 0;
                        while (srs.hasNext()) {
                            boolean nomore;
                            SearchResult sr = srs.next();
                            chunkSrs.add(sr);
                            ++chunkCounter;
                            ++totalSrs;
                            boolean keysChanged = Utils.updateHeaderFields(srKeys, sr);
                            fields = srKeys.toArray(new SearchResult.FieldMeta[srKeys.size()]);
                            if (keysChanged) {
                                logger.debug((Object)String.format("Search results keys have changed hence the header to search head would change: new keys: %s", fields.toString()));
                            }
                            if (!first) {
                                first = true;
                                while (true) {
                                    try {
                                        pairSoc = NIOTls.connect(receiverHost, receiverPort);
                                        clientChannel = pairSoc.first();
                                        sslEngine = pairSoc.second();
                                    }
                                    catch (IOException ioe) {
                                        logger.error((Object)String.format("Could not connect to receiver reason: %s, will retry to connect", ioe.getMessage()));
                                        continue;
                                    }
                                    break;
                                }
                                logger.debug((Object)String.format("Connected to search results receiver: host: %s, port: %d", receiverHost, receiverPort));
                            }
                            boolean bl = nomore = totalSrs >= numsrs;
                            if (!nomore && chunkCounter < 100000) continue;
                            ++chunkId;
                            while (true) {
                                try {
                                    SearchResultsReceiverStreaming.writePayload(clientChannel, fields, chunkSrs, sid, sslEngine);
                                }
                                catch (IOException ioe) {
                                    logger.error((Object)String.format("Error sending chunk to receiver: %s, will try resending the chunk after reconnecting, chunkd id: %d", ioe.getMessage(), chunkId));
                                    NIOTls.disconnect(pairSoc.first(), pairSoc.second());
                                    pairSoc = NIOTls.connect(receiverHost, receiverPort);
                                    clientChannel = pairSoc.first();
                                    sslEngine = pairSoc.second();
                                    continue;
                                }
                                break;
                            }
                            chunkCounter = 0;
                            chunkSrs.clear();
                            if (!nomore) continue;
                        }
                        if (!chunkSrs.isEmpty()) {
                            while (true) {
                                try {
                                    SearchResultsReceiverStreaming.writePayload(clientChannel, fields, chunkSrs, sid, sslEngine);
                                }
                                catch (IOException ioe) {
                                    logger.error((Object)String.format("Error sending chunk to receiver: %s, will try resending the chunk after reconnecting, chunk id: %d", ioe.getMessage(), chunkId));
                                    NIOTls.disconnect((SocketChannel)pairSoc.first(), (SSLEngine)pairSoc.second());
                                    pairSoc = NIOTls.connect(receiverHost, receiverPort);
                                    clientChannel = pairSoc.first();
                                    sslEngine = pairSoc.second();
                                    continue;
                                }
                                break;
                            }
                        }
                        if (clientChannel == null) break block21;
                    }
                    catch (Throwable t) {
                        try {
                            throw new DFSException(logger, String.format("Error processing sid=%s, par id=%d, receiver port=%d", sid, parid, receiverPort), t);
                        }
                        catch (Throwable throwable) {
                            if (clientChannel == null) throw throwable;
                            try {
                                NIOTls.disconnect((SocketChannel)pairSoc.first(), (SSLEngine)pairSoc.second());
                                throw throwable;
                            }
                            catch (Throwable t2) {
                                logger.error((Object)String.format("Error closing search results sender channel: %s, sid: %s", t2.getMessage(), sid));
                            }
                            throw throwable;
                        }
                    }
                    try {
                        NIOTls.disconnect((SocketChannel)pairSoc.first(), (SSLEngine)pairSoc.second());
                    }
                    catch (Throwable t) {
                        logger.error((Object)String.format("Error closing search results sender channel: %s, sid: %s", t.getMessage(), sid));
                    }
                }
                if (totalSrs <= 0L) return new ArrayList().iterator();
                logger.info((Object)String.format("Transferred all search results in partition=%s, sid=%s, totalsrs=%d", parid, sid, totalSrs));
                return new ArrayList().iterator();
            }
        }, parid);
        return ret;
    }

    private static void write(SocketChannel channel, ByteBuffer buff) throws IOException {
        buff.rewind();
        while (buff.remaining() > 0) {
            channel.write(buff);
        }
        buff.rewind();
    }

    private static void writePayload(SocketChannel channel, SearchResult.FieldMeta[] fields, List<SearchResult> srs, String sid, SSLEngine sslEngine) throws Exception {
        ByteBuffer intbuff = ByteBuffer.allocate(4);
        byte[] payload = SearchResultsReceiverStreaming.getChunkPayload(fields, srs);
        int payloadSize = payload.length;
        logger.debug((Object)String.format("Payload size=%d, sid=%s", payloadSize, sid));
        intbuff.putInt(payloadSize);
        ByteBuffer payloadBuff = ByteBuffer.wrap(payload);
        NIOTls.write(channel, sslEngine, intbuff);
        NIOTls.write(channel, sslEngine, payloadBuff);
        intbuff.clear();
        Pair<ByteBuffer, ByteBuffer> remainingBuffers = NIOTls.read(channel, sslEngine, intbuff, null, null);
        if (remainingBuffers == null) {
            logger.error((Object)"WritePayload:: read failed to get the ack");
        }
        int receiverack = intbuff.getInt(0);
        logger.info((Object)String.format("Write payload :: Received after write payload:: %d", receiverack));
        intbuff.clear();
        logger.info((Object)String.format("Transferred payload size=%d, sid=%s", payloadSize, sid));
    }

    private static byte[] getChunkPayload(SearchResult.FieldMeta[] fields, List<SearchResult> srs) throws IOException {
        Iterator<SearchResult> srsi = srs.iterator();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OutputStreamWriter bsw = new OutputStreamWriter((OutputStream)baos, StandardCharsets.UTF_8);
        SearchResultsWriter.write(srsi, fields, bsw);
        return baos.toByteArray();
    }

    private static boolean read(SocketChannel channel, ByteBuffer buff, String sid) throws IOException {
        buff.rewind();
        while (buff.remaining() > 0) {
            int ret = channel.read(buff);
            if (ret >= 0) continue;
            if (buff.capacity() != buff.remaining()) {
                throw new DFSException(logger, "Partial read of data, sid=" + sid);
            }
            return false;
        }
        buff.rewind();
        return true;
    }

    private Pair<ByteBuffer, ByteBuffer> read(SocketChannel socketChannel, SSLEngine sslEngine, ByteBuffer buff, ByteBuffer peerNetBuffer, ByteBuffer remainingAppBuffer) throws IOException {
        try {
            Pair<ByteBuffer, ByteBuffer> remainingBuffers = NIOTls.read(socketChannel, sslEngine, buff, peerNetBuffer, remainingAppBuffer);
            return remainingBuffers;
        }
        catch (Exception ex) {
            logger.error((Object)"Read error :: ", (Throwable)ex);
            return null;
        }
    }

    @Override
    public boolean hasNext() {
        if (this.nextsr != null) {
            return true;
        }
        boolean lastTry = false;
        do {
            if (this.shutdown[0]) {
                lastTry = true;
            }
            try {
                this.nextsr = this.srcache.poll(10L, TimeUnit.MILLISECONDS);
                if (this.nextsr != null) {
                    return true;
                }
            }
            catch (Throwable t) {
                throw new DFSException(logger, t.getMessage());
            }
        } while (!lastTry);
        logger.info((Object)("Retrieved all srs from cache=" + this.sid));
        return false;
    }

    @Override
    public SearchResult next() {
        SearchResult ret = this.nextsr;
        this.nextsr = null;
        return ret;
    }

    @Override
    public void remove() {
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        try {
            this.shutdown[0] = true;
            logger.info((Object)String.format("Will wait for all the threads to complete: %s", this.sid));
            this.srreceiver.join();
            this.srtransmitter.join();
            logger.info((Object)("All threads completed, sid=" + this.sid));
        }
        catch (Throwable t) {
            logger.error((Object)("Error while waiting for threads to complete, sid=%s" + t.getMessage()));
        }
        finally {
            this.closed = true;
        }
    }

    public void finalize() {
        try {
            this.close();
            logger.info((Object)"Closed receiver since it is being destroyed");
        }
        catch (Throwable t) {
            logger.error((Object)String.format("Error finalizing search results receiver %s, sid=%s", t.getMessage(), this.sid));
        }
    }
}

