/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search.compute.spark;

import com.splunk.df.search.compute.ComputeEngineClusterInfo;
import com.splunk.df.search.compute.ComputeEngineClusterManager;
import com.splunk.df.search.compute.spark.SparkComputeEngineConstants;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.ArrayList;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class SparkClusterManager
implements SparkComputeEngineConstants,
ComputeEngineClusterManager {
    static final Logger logger = Logger.getLogger(SparkClusterManager.class);
    private int sparkMasterConnectTimeout;
    private String masterUrl;
    private int totalCores;
    private int coresUsed;
    private int totalMemoryMbs;
    private int totalMemoryUsedMbs;
    private int numWorkers;
    private int minWorkerMemMbs;
    private int minWorkerCores;
    private ArrayList<WorkerInfo> workers = new ArrayList();

    public static JSONObject getJson(String masterWebUrl, int sparkMasterConnectTimeout) throws Exception {
        if (masterWebUrl == null) {
            masterWebUrl = System.getenv("SPARK_MASTER_WEB_URL");
        }
        if (masterWebUrl == null) {
            throw new RuntimeException(String.format("%s environment variable not set, the value should be like: http://spark-master-ip:web-ui-port - PLS DO NOT PUT A SLASH 'AKA' '/' AT THE END!!!!!", "SPARK_MASTER_WEB_URL"));
        }
        while (masterWebUrl.charAt(masterWebUrl.length() - 1) == '/') {
            masterWebUrl = masterWebUrl.substring(0, masterWebUrl.length() - 1);
        }
        String masterJsonUrl = String.format("%s/json", masterWebUrl);
        logger.info((Object)String.format("Spark master json url to be used: %s", masterJsonUrl));
        try (InputStream inStream = null;){
            URL masterUrl = new URL(masterJsonUrl);
            URLConnection masterConn = masterUrl.openConnection();
            masterConn.setConnectTimeout(sparkMasterConnectTimeout * 1000);
            masterConn.connect();
            inStream = masterConn.getInputStream();
            String jsonStr = IOUtils.toString((InputStream)inStream, (Charset)Charset.forName("UTF-8"));
            JSONObject jSONObject = new JSONObject(jsonStr);
            return jSONObject;
        }
    }

    public static int activeDFSApps(String masterWebUrl, int sparkMasterConnectTimeout) {
        try {
            JSONObject json = SparkClusterManager.getJson(masterWebUrl, sparkMasterConnectTimeout);
            int activeDFSAppCount = 0;
            JSONArray activeAppArray = json.getJSONArray("activeapps");
            if (activeAppArray != null) {
                int activeDFSApps = 0;
                for (int i = 0; i < activeAppArray.length(); ++i) {
                    JSONObject activeApp = activeAppArray.getJSONObject(i);
                    String state = activeApp.getString("state");
                    String appName = activeApp.getString("name");
                    if (!state.equalsIgnoreCase("RUNNING") || !appName.startsWith("DATA_FABRIC_1.0.0")) continue;
                    ++activeDFSApps;
                }
                activeDFSAppCount = activeDFSApps;
            }
            return activeDFSAppCount;
        }
        catch (Throwable t) {
            logger.error((Object)String.format("Error fetching spark cluster configuration json: %s", t.getMessage()), t);
            throw new RuntimeException(String.format("error fetching spark cluster configuration: %s", t.getMessage()), t);
        }
    }

    public SparkClusterManager(String masterWebUrl, int sparkMasterConnectTimeout) {
        try {
            this.sparkMasterConnectTimeout = sparkMasterConnectTimeout;
            JSONObject json = SparkClusterManager.getJson(masterWebUrl, this.sparkMasterConnectTimeout);
            this.masterUrl = json.getString("url");
            this.totalCores = json.getInt("cores");
            this.coresUsed = json.getInt("coresused");
            this.totalMemoryMbs = json.getInt("memory");
            this.totalMemoryUsedMbs = json.getInt("memoryused");
            JSONArray workerArray = json.getJSONArray("workers");
            if (workerArray == null || workerArray.length() == 0) {
                throw new RuntimeException(String.format("spark cluster (%s) does not have any workers registered with the master, pls add workers before starting to use dfs", masterWebUrl));
            }
            int minWorkerMemMbs = -1;
            int minWorkerCores = -1;
            for (int i = 0; i < workerArray.length(); ++i) {
                JSONObject workerJson = workerArray.getJSONObject(i);
                String state = workerJson.getString("state");
                if (!state.equalsIgnoreCase("ALIVE")) continue;
                WorkerInfo workerInfo = new WorkerInfo(workerJson);
                this.workers.add(workerInfo);
                minWorkerMemMbs = minWorkerMemMbs < 0 ? workerInfo.memoryMbs() : Math.min(minWorkerMemMbs, workerInfo.memoryMbs());
                minWorkerCores = minWorkerCores < 0 ? workerInfo.cores() : Math.min(minWorkerCores, workerInfo.cores());
            }
            this.minWorkerMemMbs = minWorkerMemMbs;
            this.minWorkerCores = minWorkerCores;
            this.numWorkers = this.workers.size();
        }
        catch (Throwable t) {
            logger.error((Object)String.format("Error fetching spark cluster configuration json: %s", t.getMessage()), t);
            throw new RuntimeException(String.format("Error fetching spark cluster configuration: %s", t.getMessage()), t);
        }
    }

    @Override
    public ComputeEngineClusterInfo getClusterInfo() {
        return new ComputeEngineClusterInfo(){

            @Override
            public int totalCores() {
                return SparkClusterManager.this.totalCores;
            }

            @Override
            public int totalMemoryMbs() {
                return SparkClusterManager.this.totalMemoryMbs;
            }

            @Override
            public int usedMemoryMbs() {
                return SparkClusterManager.this.totalMemoryUsedMbs;
            }

            @Override
            public String masterUrl() {
                return SparkClusterManager.this.masterUrl;
            }

            public String toString() {
                return String.format("Spark cluster: master url: %s, total cores: %d, cores used: %d, total memory: %d mb, memory used: %d mb, number of workers: %d, min worker memory: %d mb, min worker cores: %d", SparkClusterManager.this.masterUrl, SparkClusterManager.this.totalCores, SparkClusterManager.this.coresUsed, SparkClusterManager.this.totalMemoryMbs, SparkClusterManager.this.totalMemoryUsedMbs, SparkClusterManager.this.numWorkers, SparkClusterManager.this.minWorkerMemMbs, SparkClusterManager.this.minWorkerCores);
            }

            @Override
            public int coresUsed() {
                return SparkClusterManager.this.coresUsed;
            }

            @Override
            public int minWorkerMemMbs() {
                return SparkClusterManager.this.minWorkerMemMbs;
            }

            @Override
            public int minWorkerCores() {
                return SparkClusterManager.this.minWorkerCores;
            }

            @Override
            public int numWorkers() {
                return SparkClusterManager.this.numWorkers;
            }
        };
    }

    private static class WorkerInfo {
        private int cores;
        private int coresUsed;
        private int memoryMbs;
        private int memoryUsedMbs;
        private String host;

        WorkerInfo(JSONObject json) {
            this.host = json.getString("host");
            this.cores = json.getInt("cores");
            this.coresUsed = json.getInt("coresused");
            this.memoryMbs = json.getInt("memory");
            this.memoryUsedMbs = json.getInt("memoryused");
        }

        int cores() {
            return this.cores;
        }

        int memoryMbs() {
            return this.memoryMbs;
        }

        public String toString() {
            return String.format("Spark worker: host: %s, cores: %d, cores used: %d, memory: %d mb, memory used: %d mb", this.host, this.cores, this.coresUsed, this.memoryMbs, this.memoryUsedMbs);
        }
    }
}

