/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search.compute.transformers;

import com.splunk.commons.ast.nodes.CommandNode;
import com.splunk.commons.ast.nodes.CommandType;
import com.splunk.commons.ast.nodes.commands.UnionCommand;
import com.splunk.df.search.compute.ComputeEngineContext;
import com.splunk.df.search.compute.DistributedDataset;
import com.splunk.df.search.compute.SearchResult;
import com.splunk.df.search.compute.SearchResultFactory;
import com.splunk.df.search.compute.Transformer;
import com.splunk.df.search.compute.TransformerRegistry;
import com.splunk.df.search.compute.transformers.BaseTransformerFactory;
import com.splunk.df.util.DFSException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class UnionTransformer
implements Transformer {
    static final Logger logger = Logger.getLogger(UnionTransformer.class);

    private static DistributedDataset _custom_transform(ComputeEngineContext ctx, DistributedDataset dd, UnionCommand ucmd) {
        CommandNode[] sources = ucmd.getSources();
        ArrayList<SearchResult> subsearchMetaInfoList = new ArrayList<SearchResult>();
        boolean streaming = true;
        int datasetId = 1;
        SearchResult.FieldMeta[] datasetFields = new SearchResult.FieldMeta[]{SearchResult.FieldMeta.newFieldMeta("_dataset_index"), SearchResult.FieldMeta.newFieldMeta("_dataset_streaming")};
        for (int i = 0; i < sources.length; ++i) {
            boolean bl = streaming = streaming && sources[i].getCommandType() == CommandType.SP_STREAM;
            if (!streaming) {
                ++datasetId;
            }
            List<SearchResult> metaInfo = BaseTransformerFactory.getInstance().getMetaInfo(dd, sources[i], ctx);
            if (ucmd.sort() || ucmd.cursored()) {
                for (int m = 0; m < metaInfo.size(); ++m) {
                    metaInfo.set(m, SearchResultFactory.getInstance().merge(metaInfo.get(m), SearchResultFactory.getInstance().createSearchResult(datasetFields, new Object[]{datasetId, streaming || sources[i].getCommandType() == CommandType.SP_STREAM ? Boolean.valueOf(true) : null})));
                }
            }
            subsearchMetaInfoList.addAll(metaInfo);
        }
        DistributedDataset uniondd = BaseTransformerFactory.getInstance().explode(dd, (CommandNode)ucmd, ctx, subsearchMetaInfoList);
        logger.debug((Object)("Custom Union: numPartititions=" + uniondd.partitions()));
        return uniondd.customUnion(ucmd);
    }

    private static List<DistributedDataset> _getUnionRddList(ComputeEngineContext ctx, DistributedDataset dd, UnionCommand ucmd, int index, boolean streamingOnly) {
        CommandNode[] sources = ucmd.getSources();
        ArrayList<DistributedDataset> list = new ArrayList<DistributedDataset>();
        for (int i = index; !(i >= sources.length || streamingOnly && sources[i].getCommandType() != CommandType.SP_STREAM); ++i) {
            boolean executeExternal;
            DistributedDataset localdd = dd;
            boolean bl = executeExternal = !BaseTransformerFactory.getInstance().canExecuteExternal((CommandNode)ucmd, sources[i]);
            if (executeExternal) {
                localdd = BaseTransformerFactory.getInstance().transform(localdd, sources[i], ctx);
                logger.debug((Object)"Will execute base transformer to input create dataset");
            } else {
                String cmdName = sources[i].getCommandName();
                Transformer t = ((TransformerRegistry)ctx.get("dfs.dataset.transformer.registry")).getTransformer(sources[i]);
                if (t == null) {
                    throw new DFSException(logger, "transformer not found for command: " + cmdName);
                }
                localdd = t.transform(localdd, sources[i], streamingOnly || sources[i].getCommandType() == CommandType.SP_STREAM, ctx);
            }
            list.add(localdd);
        }
        return list;
    }

    private static DistributedDataset _transform(ComputeEngineContext ctx, DistributedDataset dd, UnionCommand ucmd) {
        DistributedDataset uniondd = dd;
        ArrayList<DistributedDataset> list = new ArrayList<DistributedDataset>();
        List<DistributedDataset> slist = UnionTransformer._getUnionRddList(ctx, dd, ucmd, 0, true);
        if (slist.size() > 1) {
            uniondd = uniondd.union(slist, ucmd, true);
            logger.debug((Object)("Spark Union: number of streamed datasets= " + slist.size() + " numPartititions=" + uniondd.partitions()));
        } else if (!slist.isEmpty()) {
            list.addAll(slist);
        }
        List<DistributedDataset> remainderList = UnionTransformer._getUnionRddList(ctx, dd, ucmd, slist.size(), false);
        if (remainderList.isEmpty()) {
            return uniondd;
        }
        logger.debug((Object)("Spark Union: number of non-streamed datasets= " + remainderList.size() + " numPartititions=" + uniondd.partitions()));
        list.addAll(remainderList);
        uniondd = uniondd.union(list, ucmd, true);
        return uniondd;
    }

    @Override
    public DistributedDataset transform(DistributedDataset dd, CommandNode qcmd, boolean streaming, ComputeEngineContext ctx) {
        UnionCommand ucmd = (UnionCommand)qcmd;
        CommandNode[] sources = ucmd.getSources();
        if (sources == null) {
            throw new DFSException(logger, "Sources not found for union command");
        }
        logger.debug((Object)("Number of sources=" + sources.length));
        String extras = (String)ctx.get("extras");
        if (extras == null) {
            extras = System.getenv("EXTRAS");
        }
        ucmd.setExtras(extras);
        logger.debug((Object)("Extras = " + extras));
        DistributedDataset uniondd = dd;
        if (ucmd.custom()) {
            return UnionTransformer._custom_transform(ctx, dd, ucmd);
        }
        return UnionTransformer._transform(ctx, dd, ucmd);
    }

    @Override
    public String name() {
        return "UnionTransformer";
    }
}

