/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search.compute.transformers;

import com.splunk.commons.Row;
import com.splunk.commons.ast.nodes.CommandNode;
import com.splunk.commons.ast.nodes.Node;
import com.splunk.commons.ast.nodes.commands.WhereCommand;
import com.splunk.commons.visitors.ExpressionEvaluator;
import com.splunk.df.search.compute.ComputeEngineContext;
import com.splunk.df.search.compute.DistributedDataset;
import com.splunk.df.search.compute.Filter;
import com.splunk.df.search.compute.SearchResult;
import com.splunk.df.search.compute.SearchResultFactory;
import com.splunk.df.search.compute.Transformer;
import com.splunk.df.search.compute.TransformerRegistry;
import com.splunk.df.search.compute.transformers.BaseTransformerFactory;
import com.splunk.df.search.compute.transformers.FieldExtractor;
import org.apache.log4j.Logger;

public class WhereTransformer
implements Transformer {
    static final Logger logger = Logger.getLogger(WhereTransformer.class);

    @Override
    public DistributedDataset transform(DistributedDataset dd, CommandNode qcmd, boolean streaming, ComputeEngineContext ctx) {
        return WhereTransformer._transform(ctx, dd, (WhereCommand)qcmd, streaming);
    }

    private static DistributedDataset _transform(ComputeEngineContext ctx, DistributedDataset dd, WhereCommand whereCmd, boolean streaming) {
        boolean executeExternal;
        DistributedDataset outputdd = dd;
        CommandNode srcCmd = whereCmd.getSource();
        boolean bl = executeExternal = !BaseTransformerFactory.getInstance().canExecuteExternal((CommandNode)whereCmd, srcCmd);
        if (executeExternal) {
            logger.debug((Object)"Will use base transformer to create input dataset");
            outputdd = BaseTransformerFactory.getInstance().transform(outputdd, (CommandNode)whereCmd, ctx);
        } else {
            Transformer t = ((TransformerRegistry)ctx.get("dfs.dataset.transformer.registry")).getTransformer(srcCmd);
            outputdd = t.transform(outputdd, srcCmd, streaming, ctx);
        }
        final Node predNode = whereCmd.getPredicate().getNode();
        if (predNode.toString().isEmpty()) {
            return outputdd;
        }
        final ExpressionEvaluator ee = new ExpressionEvaluator();
        outputdd = outputdd.transform(new Filter(){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean accept(SearchResult sr) {
                Row row = new Row(SearchResultFactory.convert(sr.getDataMap()));
                Object eval = ee.evaluate(predNode, row);
                return (Boolean)eval;
            }

            @Override
            public FieldExtractor.ExtractionHint fieldExtractionHint() {
                return FieldExtractor.ExtractionHint.NOT_PRECOMPUTED;
            }
        });
        return outputdd;
    }

    @Override
    public String name() {
        return "WhereTransformer";
    }
}

