/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search.compute.transformers.aggregatevalues;

import com.splunk.df.search.compute.transformers.aggregatevalues.AggregateValue;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public class ThresholdAggregateValue
implements AggregateValue {
    static final Logger logger = Logger.getLogger(ThresholdAggregateValue.class);
    private Object val = null;
    private THRESHOLD_FUNCTION thresholdFunction;

    private ThresholdAggregateValue(THRESHOLD_FUNCTION thresholdFunction) {
        this.thresholdFunction = thresholdFunction;
    }

    public static ThresholdAggregateValue getInstance(THRESHOLD_FUNCTION thresholdFunction) {
        return new ThresholdAggregateValue(thresholdFunction);
    }

    @Override
    public AggregateValue accumulate(Object item) {
        if (this.val == null) {
            this.val = item;
        } else {
            this.compareAndSet(item);
        }
        return this;
    }

    @Override
    public AggregateValue accumulate(AggregateValue aggregateValue) {
        assert (aggregateValue instanceof ThresholdAggregateValue);
        Object item = aggregateValue.getValue();
        this.compareAndSet(item);
        return this;
    }

    private void compareAndSet(Object item) {
        int result = 0;
        if (null == this.val || this.val.toString().isEmpty()) {
            this.val = item;
        } else if (null != item && !item.toString().isEmpty()) {
            try {
                result = new BigDecimal(this.val.toString()).compareTo(new BigDecimal(item.toString()));
                this.val = this.thresholdFunction == THRESHOLD_FUNCTION.MIN ? (result < 0 ? this.val : item) : (result > 0 ? this.val : item);
            }
            catch (NumberFormatException e) {
                result = this.val.toString().compareTo(item.toString());
                this.val = this.thresholdFunction == THRESHOLD_FUNCTION.MIN ? (result < 0 ? this.val : item) : (result > 0 ? this.val : item);
            }
        }
    }

    @Override
    public Object getValue() {
        return this.val;
    }

    public static enum THRESHOLD_FUNCTION {
        MIN,
        MAX;

    }
}

