/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.datasource.parquet.converter;

import com.splunk.datasource.parquet.converter.Group;
import com.splunk.datasource.parquet.converter.JsonPrimitiveConverter;
import org.apache.parquet.io.api.Converter;
import org.apache.parquet.io.api.GroupConverter;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.Type;

public class JsonGroupConverter
extends GroupConverter {
    private JsonGroupConverter parent;
    private int index;
    private Converter[] converters;
    private GroupType schema;
    private Group current;

    public JsonGroupConverter(JsonGroupConverter parent, int index, GroupType schema) {
        this.parent = parent;
        this.index = index;
        this.schema = schema;
        this.converters = new Converter[schema.getFieldCount()];
        for (int i = 0; i < this.converters.length; ++i) {
            Type type = schema.getType(i);
            this.converters[i] = type.isPrimitive() ? JsonPrimitiveConverter.getInstance(type, this, i) : new JsonGroupConverter(this, i, type.asGroupType());
        }
    }

    public Converter getConverter(int index) {
        if (index < 0 || index >= this.converters.length) {
            throw new IndexOutOfBoundsException("Unable to get converter for group " + this.schema.getName() + " with given index:" + index + ".");
        }
        return this.converters[index];
    }

    public void start() {
        this.current = new Group(this.schema);
    }

    public void end() {
        if (this.parent != null) {
            this.parent.current.add(this.index, this.current);
        }
    }

    public Group getCurrent() {
        return this.current;
    }
}

