/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.collect;

import com.splunk.s2s.Event;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.hadoop.fs.Path;

public class EventPartitioner {
    private static Map<String, Field> fieldLookup = new HashMap<String, Field>();
    static Pattern hdfsDisallowedChars = Pattern.compile("[/:]");
    private StringBuilder builder = new StringBuilder();
    Field[] fields;

    public EventPartitioner(String format) {
        if (null == format) {
            this.fields = new Field[0];
        } else {
            String[] keys = format.split(",");
            this.fields = new Field[keys.length];
            for (int i = 0; i < keys.length; ++i) {
                String orig = keys[i].trim();
                String lower = orig.toLowerCase();
                Field f = fieldLookup.get(lower);
                if (f == null) {
                    keys[i] = orig;
                    try {
                        SimpleDateFormat df = new SimpleDateFormat(orig);
                        f = new DateField(orig, df);
                    }
                    catch (IllegalArgumentException ex) {
                        StringBuilder msg = new StringBuilder();
                        msg.append("Field '").append(orig).append("' is not known. Choices are ");
                        for (String k : fieldLookup.keySet()) {
                            msg.append(k).append(", ");
                        }
                        msg.append(" or a valid Java date format.");
                        throw new IllegalArgumentException(msg.toString());
                    }
                } else {
                    keys[i] = lower;
                }
                this.fields[i] = f;
            }
        }
    }

    public Path getDirectory(Event e, Path baseDir) {
        Path dir = baseDir;
        for (Field f : this.fields) {
            dir = new Path(dir, f.getValue(e));
        }
        return dir;
    }

    public String getLookupKey(Event e) {
        if (this.fields.length == 0) {
            return "";
        }
        this.builder.setLength(0);
        for (Field f : this.fields) {
            this.builder.append(f.getValue(e)).append('\u0000');
        }
        return this.builder.toString();
    }

    public String getKafkaPartitionKey(Event e) {
        if (this.fields.length == 0) {
            return null;
        }
        this.builder.setLength(0);
        if (this.fields.length > 1) {
            throw new IllegalArgumentException("Kafka partitioning key cannot exceed more than one field");
        }
        return this.builder.append(this.fields[0].getValue(e)).toString();
    }

    static {
        fieldLookup.put("host", new Field("host"){

            @Override
            public String getValueImpl(Event e) {
                return e.getChannel().getHost();
            }
        });
        fieldLookup.put("source", new Field("source"){

            @Override
            public String getValueImpl(Event e) {
                return e.getChannel().getSource();
            }
        });
        fieldLookup.put("sourcetype", new Field("sourcetype"){

            @Override
            public String getValueImpl(Event e) {
                return e.getChannel().getSourcetype();
            }
        });
    }

    static class DateField
    extends Field {
        private DateFormat dateFormat;
        Date date = new Date();

        public DateField(String name, DateFormat format) {
            super(name);
            this.dateFormat = format;
        }

        @Override
        public String getValueImpl(Event e) {
            Number time = e.getNonNullTime();
            this.date.setTime(1000L * time.longValue());
            return this.dateFormat.format(this.date);
        }
    }

    static abstract class Field {
        String name;

        public Field(String name) {
            this.name = name;
        }

        protected abstract String getValueImpl(Event var1);

        String getValue(Event e) {
            String val = this.getValueImpl(e);
            return this.makeFsSafe(val);
        }

        protected String makeFsSafe(String fieldVal) {
            if ("".equals(fieldVal) || ".".equals(fieldVal) || "..".equals(fieldVal)) {
                return "_";
            }
            return hdfsDisallowedChars.matcher(fieldVal).replaceAll("_");
        }

        public String toString() {
            return "[Field: " + this.name + "]";
        }
    }
}

