/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mr.cache.reporting;

import com.splunk.mr.cache.GroupedProcessor;
import com.splunk.mr.cache.MapCaches;
import com.splunk.mr.cache.integration.CacheKey;
import com.splunk.mr.cache.reporting.GroupedProbeProcessors;
import com.splunk.mr.cache.reporting.ProbeFactories;
import com.splunk.mr.cache.reporting.Report;
import com.splunk.mr.input.VixInputSplit;
import com.splunk.search.SearchResults;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.apache.log4j.Logger;

public class CacheReporting {
    private static final Logger gLogger = Logger.getLogger(CacheReporting.class);
    private final ProbeFactories probeFactory;
    private final GroupedProcessor<String, VixInputSplit> groupedSplitProcessor;
    private final GroupedProcessor<String, CacheKey> groupedCacheProcessor;
    private final List<CacheKey> pendingCacheKeys;

    public CacheReporting(GroupedProcessor<String, VixInputSplit> groupedSplitProcessor, GroupedProcessor<String, CacheKey> groupedCacheProcessor, ProbeFactories probeFactory) {
        this.groupedSplitProcessor = groupedSplitProcessor;
        this.groupedCacheProcessor = groupedCacheProcessor;
        this.probeFactory = probeFactory;
        this.pendingCacheKeys = new ArrayList<CacheKey>();
    }

    public void offer(VixInputSplit split) {
        this.groupedSplitProcessor.offer(CacheReporting.getKey(split), split);
    }

    public void offer(CacheKey cacheKey) {
        this.groupedCacheProcessor.offer(this.getKey(cacheKey), cacheKey);
    }

    public void addPending(CacheKey cacheKey) {
        this.pendingCacheKeys.add(cacheKey);
    }

    public void offerPending() {
        gLogger.debug((Object)("Adding all pending cache reporting keys: " + this.pendingCacheKeys.size()));
        for (CacheKey cacheKey : this.pendingCacheKeys) {
            this.offer(cacheKey);
        }
    }

    private String getKey(CacheKey cacheKey) {
        return CacheReporting.getKey(cacheKey.getBucketId(), cacheKey.getIndex());
    }

    public void awaitCompletion() {
        this.groupedSplitProcessor.awaitCompletion();
        this.groupedCacheProcessor.awaitCompletion();
    }

    private static String getKey(VixInputSplit split) {
        String bucketId = split.getBucketId();
        String index = split.getIndex();
        return CacheReporting.getKey(bucketId, index);
    }

    private static String getKey(String bucketId, String index) {
        return "resides-in-hadoop" + index + bucketId;
    }

    public void outputResults(SearchResults srs) {
        this.awaitCompletion();
        for (Report report : this.probeFactory.getReports().values()) {
            SearchResults.Result res = srs.addNewResult();
            for (String key : report.keySet()) {
                res.set(key, report.get(key));
            }
        }
    }

    public static CacheReporting create(MapCaches mapCaches, ExecutorService pipeModePool) {
        ProbeFactories probeFactories = new ProbeFactories(mapCaches.getFileSystem(), mapCaches);
        GroupedProcessor<String, VixInputSplit> groupedSplitProcessor = GroupedProbeProcessors.getGroupedSplitProcessor(probeFactories.getSplitFactory(), pipeModePool);
        GroupedProcessor<String, CacheKey> groupedCacheProcessor = GroupedProbeProcessors.getGroupedCacheProcessor(probeFactories.getCacheFactory(), pipeModePool);
        return new CacheReporting(groupedSplitProcessor, groupedCacheProcessor, probeFactories);
    }
}

