/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.roll.slices;

import com.splunk.roll.BucketName;
import com.splunk.roll.slices.BucketRawdataProvider;
import com.splunk.roll.slices.Slices;
import com.splunk.roll.slices.SlicesDatUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;

public class SplunkdSliceMetadataProvider
implements BucketRawdataProvider.SliceMetadataProvider {
    private final SliceProviderExecutor sliceProviderExecutor;

    public SplunkdSliceMetadataProvider(SliceProviderExecutor sliceProviderExecutor) {
        this.sliceProviderExecutor = sliceProviderExecutor;
    }

    @Override
    public Slices getSliceMetadata(File rawDataDir) {
        SliceProviderProcess process = null;
        Integer exit = null;
        try {
            process = this.sliceProviderExecutor.execute(rawDataDir);
            Slices slices = SlicesDatUtil.getSlices(process.getInputStream());
            exit = process.waitFor();
            if (exit == 0) {
                Slices slices2 = slices;
                return slices2;
            }
            try {
                throw new RuntimeException("slice-dat-util process executed with non-zero exit=" + exit);
            }
            catch (Exception e) {
                String stderr;
                StringBuilder message = new StringBuilder();
                message.append("Could not get slice metadata. ");
                message.append(BucketRawdataProvider.loggingContext(rawDataDir));
                if (exit != null) {
                    message.append(" process_exit=" + exit);
                }
                if (process != null && (stderr = this.getStderr(process)) != null) {
                    message.append(" process_stderr=" + stderr);
                }
                if (this.isClusteredBucket(rawDataDir)) {
                    throw new BucketRawdataProvider.CouldNotReadMetadataFromClusteredBucket(message.toString(), e);
                }
                throw new RuntimeException(message.toString(), e);
            }
        }
        finally {
            if (process != null) {
                process.destroy();
            }
        }
    }

    private String getStderr(SliceProviderProcess process) {
        try {
            return IOUtils.toString((InputStream)process.getErrorStream());
        }
        catch (Exception ignore) {
            return null;
        }
    }

    private boolean isClusteredBucket(File rawDataDir) {
        File bucketDirectory = rawDataDir.getParentFile();
        return new BucketName(bucketDirectory.getName()).hasGuid();
    }

    public static SplunkdSliceMetadataProvider create(final String splunkHome) {
        return new SplunkdSliceMetadataProvider(new SliceProviderExecutor(){

            @Override
            public SliceProviderProcess execute(File rawDataDir) throws IOException {
                final Process process = SplunkdSliceMetadataProvider.executeSlicesDatUtil(splunkHome, rawDataDir);
                return new SliceProviderProcess(){

                    @Override
                    public int waitFor() throws InterruptedException {
                        return process.waitFor();
                    }

                    @Override
                    public InputStream getInputStream() {
                        return process.getInputStream();
                    }

                    @Override
                    public InputStream getErrorStream() {
                        return process.getErrorStream();
                    }

                    @Override
                    public void destroy() {
                        process.destroy();
                    }
                };
            }
        });
    }

    private static Process executeSlicesDatUtil(String splunkHome, File rawDataDir) throws IOException {
        File splunk = new File(splunkHome, "bin" + File.separator + "splunk");
        return Runtime.getRuntime().exec(new String[]{splunk.getAbsolutePath(), "cmd", "splunkd", "slices-dat-util", "--print", rawDataDir.getAbsolutePath()});
    }

    public static interface SliceProviderExecutor {
        public SliceProviderProcess execute(File var1) throws IOException;
    }

    public static interface SliceProviderProcess {
        public int waitFor() throws InterruptedException;

        public InputStream getInputStream();

        public InputStream getErrorStream();

        public void destroy();
    }
}

