/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.ast.nodes.commands;

import com.splunk.commons.ast.nodes.CommandNode;
import com.splunk.commons.ast.nodes.CommandType;
import com.splunk.commons.ast.nodes.ISelection;
import com.splunk.commons.ast.nodes.commands.FieldsAndProperties;
import com.splunk.commons.ast.nodes.commands.FieldsCommand;
import com.splunk.commons.ast.nodes.commands.StatsCommand;
import com.splunk.commons.ast.nodes.expressions.AggregateNode;
import com.splunk.commons.ast.nodes.expressions.FieldNode;
import com.splunk.commons.ast.nodes.search.IGroupBy;
import com.splunk.commons.visitors.NodeVisitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class GroupByCommand
extends CommandNode {
    private final IGroupBy[] byFields;
    private final List<String> byFieldNames;

    public GroupByCommand(CommandNode source, String[] byFields) {
        this(source, GroupByCommand.fieldNameToNode(byFields));
    }

    public GroupByCommand(CommandNode source, IGroupBy[] byFields) {
        super(source, "GROUPBY", CommandType.INTERNAL, new FieldsAndProperties().by(byFields).array());
        this.byFields = byFields == null ? new IGroupBy[]{} : byFields;
        this.byFieldNames = new ArrayList<String>();
        for (IGroupBy fn : this.byFields) {
            this.byFieldNames.add(fn.getByName());
        }
    }

    private static FieldNode[] fieldNameToNode(String[] names) {
        FieldNode[] fieldNodes = new FieldNode[names.length];
        for (int i = 0; i < names.length; ++i) {
            fieldNodes[i] = new FieldNode(names[i]);
        }
        return fieldNodes;
    }

    public IGroupBy[] getByFields() {
        return this.byFields;
    }

    @Override
    public <T> T accept(NodeVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public CommandNode select(ISelection[] selections) throws IllegalArgumentException {
        CommandNode source = this.getSources()[0];
        ArrayList<AggregateNode> aggregates = new ArrayList<AggregateNode>();
        ArrayList<FieldNode> fields = new ArrayList<FieldNode>();
        for (ISelection s : selections) {
            if (s instanceof AggregateNode) {
                aggregates.add((AggregateNode)s);
            }
            if (!(s instanceof FieldNode)) continue;
            FieldNode fn = (FieldNode)s;
            fields.add(fn);
            if (this.byFieldNames.contains(fn.getFieldName())) continue;
            throw new IllegalArgumentException("FieldNodes MUST be contained in the byFields of the GroupByCommand to be selected.");
        }
        source = new StatsCommand(source, aggregates, Arrays.asList(this.byFields));
        if (fields.size() < this.byFields.length) {
            FieldNode[] nodes = new FieldNode[selections.length];
            for (int i = 0; i < selections.length; ++i) {
                nodes[i] = GroupByCommand.asField(selections[i]);
            }
            source = new FieldsCommand(source, nodes);
        }
        return source;
    }

    private static FieldNode asField(ISelection selection) {
        if (selection instanceof FieldNode) {
            return (FieldNode)selection;
        }
        if (selection instanceof AggregateNode) {
            return new FieldNode(((AggregateNode)selection).getAsName());
        }
        throw new RuntimeException("Unexpected ISelection class detected.");
    }
}

