/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.ast.nodes.expressions;

import com.splunk.commons.ast.nodes.ISelection;
import com.splunk.commons.ast.nodes.expressions.Cardinality;
import com.splunk.commons.ast.nodes.expressions.IDatasetSource;
import com.splunk.commons.ast.nodes.expressions.NavigationNode;
import com.splunk.commons.ast.nodes.expressions.TypeNode;
import com.splunk.commons.ast.nodes.search.IGroupBy;
import com.splunk.commons.util.StringUtils;
import com.splunk.commons.visitors.NodeVisitor;
import java.util.ArrayList;
import java.util.Objects;

public class FieldNode
extends TypeNode
implements ISelection,
IGroupBy {
    private final IDatasetSource source;
    private final String fieldName;

    public FieldNode(String fieldName) {
        this(null, fieldName);
    }

    public FieldNode(IDatasetSource source, String fieldName) {
        super("field");
        this.fieldName = fieldName;
        this.source = FieldNode.checkValidSource(source);
    }

    private static IDatasetSource checkValidSource(IDatasetSource source) {
        if (source == null) {
            return null;
        }
        if (source instanceof NavigationNode) {
            NavigationNode node = (NavigationNode)source;
            if (node.getCardinality() == Cardinality.MANY) {
                throw new IllegalArgumentException("Navigation cardinality of Cardinality.MANY is not a valid source for a FieldNode.");
            }
            return node;
        }
        throw new IllegalStateException("Unexpected IDatasetSource detected.");
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public IDatasetSource getSource() {
        return this.source;
    }

    @Override
    public <T> T accept(NodeVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public TypeNode getTypeNode() {
        return this;
    }

    public FieldNodeArray and(String fieldName) {
        return new FieldNodeArray().and(this).and(fieldName);
    }

    public FieldNodeArray and(FieldNode field) {
        return new FieldNodeArray().and(this).and(field);
    }

    public FieldNode[] array() {
        return new FieldNode[]{this};
    }

    @Override
    public String getByName() {
        return this.fieldName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldNode fieldNode = (FieldNode)o;
        return Objects.equals(this.source, fieldNode.source) && Objects.equals(this.fieldName, fieldNode.fieldName);
    }

    public int hashCode() {
        return Objects.hash(this.source, this.fieldName);
    }

    public String toString() {
        boolean quoteNeeded = StringUtils.isQuoteNeeded(this.fieldName);
        return quoteNeeded ? "'" + this.fieldName + "'" : this.fieldName;
    }

    public static final class FieldNodeArray {
        private final ArrayList<FieldNode> fieldNames = new ArrayList();

        private FieldNodeArray() {
        }

        private FieldNodeArray and(String name) {
            this.fieldNames.add(new FieldNode(name));
            return this;
        }

        public FieldNodeArray and(FieldNode field) {
            this.fieldNames.add(field);
            return this;
        }

        public FieldNode[] array() {
            return this.fieldNames.toArray(new FieldNode[0]);
        }
    }
}

