/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.providers;

import com.splunk.commons.ast.nodes.CommandNode;
import com.splunk.commons.ast.nodes.ISearchPredicate;
import com.splunk.commons.ast.nodes.IWherePredicate;
import com.splunk.commons.ast.nodes.commands.InputlookupCommand;
import com.splunk.commons.datasets.Dataset;
import com.splunk.commons.providers.handlers.IWhereHandler;
import com.splunk.commons.visitors.WhereToSearchConverter;
import java.io.IOException;

public class InputlookupPlanProvider
implements IWhereHandler {
    private Dataset dataset;
    private ISearchPredicate predicate;

    @Override
    public void initialize(Dataset dataset) throws IOException {
        if (!dataset.getKind().equals("lookup")) {
            throw new IOException("InputlookupPlanProvider only supports lookup datasets.");
        }
        this.dataset = dataset;
        this.predicate = null;
    }

    @Override
    public CommandNode getCommand() {
        return new InputlookupCommand(this.dataset.getModuleQualifiedName(), this.predicate);
    }

    @Override
    public void where(IWherePredicate predicate) {
        WhereToSearchConverter converter = new WhereToSearchConverter();
        this.predicate = predicate.getNode().accept(converter);
    }
}

