/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.nscache;

import com.splunk.nscache.INodeDirectory;
import com.splunk.util.SerialNumberManager;
import com.splunk.util.StrUtil;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.log4j.Logger;

public abstract class INode
implements Comparable<String> {
    INodeDirectory parent;
    byte[] pathOrName;
    byte[] parentPath;
    int gid;
    int uid;
    long mtime;
    long atime;
    long length;
    short permission;
    private static Logger gLogger = Logger.getLogger(INode.class);
    private static SerialNumberManager<String> giManager = new SerialNumberManager();
    private static SerialNumberManager<String> uiManager = new SerialNumberManager();

    public INode(String parentPath, String pathOrName, long mtime, long atime, String group, String owner, long length, short permission) {
        this.parentPath = parentPath == null ? null : parentPath.getBytes(StrUtil.UTF8);
        this.pathOrName = pathOrName.getBytes(StrUtil.UTF8);
        this.mtime = mtime;
        this.atime = atime;
        this.gid = giManager.get(group);
        this.uid = uiManager.get(owner);
        this.length = length;
        this.permission = permission;
    }

    public INode(INodeDirectory parent, FileStatus stat) {
        if (stat == null) {
            throw new IllegalArgumentException("Failed to create inode for stat=" + stat);
        }
        if (parent == null) {
            this.pathOrName = stat.getPath().toString().getBytes(StrUtil.UTF8);
            this.parentPath = null;
        } else {
            this.pathOrName = stat.getPath().getName().getBytes(StrUtil.UTF8);
            this.parentPath = stat.getPath().getParent().toString().getBytes(StrUtil.UTF8);
        }
        this.mtime = stat.getModificationTime();
        this.atime = stat.getAccessTime();
        this.gid = giManager.get(stat.getGroup());
        this.uid = uiManager.get(stat.getOwner());
        this.length = stat.getLen();
        this.permission = stat.getPermission().toShort();
    }

    public abstract INodeType getType();

    public short getReplication() {
        return 0;
    }

    public long getBlockSize() {
        return 0L;
    }

    public String getOwner() {
        return uiManager.get(this.uid);
    }

    public String getGroup() {
        return giManager.get(this.gid);
    }

    public FsPermission getPermission() {
        return new FsPermission(this.permission);
    }

    public INodeDirectory getParent() {
        return this.parent;
    }

    public boolean isDir() {
        return this.getType() == INodeType.DIR;
    }

    public boolean isRoot() {
        return this.parent == null && this.parentPath == null && this.isDir();
    }

    public FileStatus getFileStatus() {
        return new FileStatus(this.length, this.isDir(), (int)this.getReplication(), this.getBlockSize(), this.mtime, this.atime, FsPermission.createImmutable((short)this.permission), this.getOwner(), this.getGroup(), this.getPath());
    }

    public Path getPath() {
        if (this.isRoot()) {
            return new Path(new String(this.pathOrName, StrUtil.UTF8));
        }
        return new Path(new String(this.parentPath, StrUtil.UTF8), new String(this.pathOrName, StrUtil.UTF8));
    }

    public String getName() {
        if (this.isRoot()) {
            return "";
        }
        return new String(this.pathOrName, StrUtil.UTF8);
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null || !(that instanceof INode)) {
            return false;
        }
        return this.getName().equals(((INode)that).getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    @Override
    public int compareTo(String o) {
        return this.getName().compareTo(o);
    }

    public String toString() {
        return this.getPath().toString();
    }

    static String constructPath(int start, int end, String ... components) {
        StringBuilder sb = new StringBuilder();
        for (int i = start; i < end; ++i) {
            sb.append(components[i]);
            sb.append("/");
        }
        return sb.toString();
    }

    static String constructPath(String ... components) {
        return INode.constructPath(0, components.length, components);
    }

    public static enum INodeType {
        DIR(1),
        FILE(2),
        SYMLINK(3);

        private byte value;

        private INodeType(byte value) {
            this.value = value;
        }

        public byte toValue() {
            return this.value;
        }

        public static INodeType fromValue(byte v) {
            switch (v) {
                case 1: {
                    return DIR;
                }
                case 2: {
                    return FILE;
                }
                case 3: {
                    return SYMLINK;
                }
            }
            throw new IllegalArgumentException("Unkown inode type value: " + v + ". Supported values are: 1,2 and 3.");
        }
    }
}

