/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.util;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class MapUtil {
    public static <K, V> Map<K, V> asMap(Object ... kvs) {
        if (kvs.length % 2 != 0) {
            throw new IllegalArgumentException("Key values need to be an even value");
        }
        LinkedHashMap<Object, Object> m = new LinkedHashMap<Object, Object>();
        for (int i = 0; i < kvs.length; i += 2) {
            m.put(kvs[i], kvs[i + 1]);
        }
        return m;
    }

    public static <K, V> void conditionalPut(Map<K, V> m, K key, V val) {
        if (!m.containsKey(key)) {
            m.put(key, val);
        }
    }

    public static <K, V> Map<K, V> lazyMap(final Class valueClass) {
        return new HashMap(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object get(Object key) {
                if (!this.containsKey(key)) {
                    try {
                        this.put(key, valueClass.newInstance());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                return super.get(key);
            }
        };
    }
}

