/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskResult;
import org.apache.hadoop.hive.ql.session.SessionState;

public class TaskRunner
extends Thread {
    protected Task<? extends Serializable> tsk;
    protected TaskResult result;
    protected SessionState ss;
    private static AtomicLong taskCounter = new AtomicLong(0L);
    private static ThreadLocal<Long> taskRunnerID = new ThreadLocal<Long>(){

        @Override
        protected Long initialValue() {
            return taskCounter.incrementAndGet();
        }
    };

    public TaskRunner(Task<? extends Serializable> tsk, TaskResult result) {
        this.tsk = tsk;
        this.result = result;
        this.ss = SessionState.get();
    }

    public Task<? extends Serializable> getTask() {
        return this.tsk;
    }

    @Override
    public void run() {
        SessionState.start(this.ss);
        this.runSequential();
    }

    public void runSequential() {
        int exitVal = -101;
        try {
            exitVal = this.tsk.executeTask();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        this.result.setExitVal(exitVal, this.tsk.getException());
    }

    public static long getTaskRunnerID() {
        return taskRunnerID.get();
    }
}

