/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ppd;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.ql.exec.FilterOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.parse.OpParseContext;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.RowResolver;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.ppd.ExprWalkerInfo;

public class OpWalkerInfo
implements NodeProcessorCtx {
    private final HashMap<Operator<? extends OperatorDesc>, ExprWalkerInfo> opToPushdownPredMap;
    private final Map<Operator<? extends OperatorDesc>, OpParseContext> opToParseCtxMap;
    private final ParseContext pGraphContext;
    private final List<FilterOperator> candidateFilterOps;

    public OpWalkerInfo(ParseContext pGraphContext) {
        this.pGraphContext = pGraphContext;
        this.opToParseCtxMap = pGraphContext.getOpParseCtx();
        this.opToPushdownPredMap = new HashMap();
        this.candidateFilterOps = new ArrayList<FilterOperator>();
    }

    public ExprWalkerInfo getPrunedPreds(Operator<? extends OperatorDesc> op) {
        return this.opToPushdownPredMap.get(op);
    }

    public ExprWalkerInfo putPrunedPreds(Operator<? extends OperatorDesc> op, ExprWalkerInfo value) {
        return this.opToPushdownPredMap.put(op, value);
    }

    public RowResolver getRowResolver(Node op) {
        return this.opToParseCtxMap.get(op).getRowResolver();
    }

    public OpParseContext put(Operator<? extends OperatorDesc> key, OpParseContext value) {
        return this.opToParseCtxMap.put(key, value);
    }

    public ParseContext getParseContext() {
        return this.pGraphContext;
    }

    public List<FilterOperator> getCandidateFilterOps() {
        return this.candidateFilterOps;
    }

    public void addCandidateFilterOp(FilterOperator fop) {
        this.candidateFilterOps.add(fop);
    }
}

