/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.roll.util;

import com.splunk.roll.util.DateU;
import com.splunk.roll.util.Time;
import com.splunk.util.StrUtil;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;

public class ConfU {
    public static final String CONF_ROLL_LOCAL_HOME = "splunk.roll.local.home";
    public static final String CONF_ROLL_REMOTE_HOME = "splunk.roll.remote.home";
    public static final String CONF_ROLL_INDEX = "splunk.roll.index";
    public static final String CONF_ROLL_VIX = "splunk.roll.vix";
    public static final String CONF_PATH_RESOLVER_VERSION = "splunk.roll.path.resolver.version";
    public static final String CONF_SPLUNK_SERVER_UUID = "splunk.server.uuid";
    public static final String CONF_SPLUNK_SERVER_URI = "splunk.server.uri";
    public static final String CONF_SPLUNK_SERVER_AUTH_TOKEN = "splunk.server.auth.token";
    public static final String CONF_ROLL_OLDER_THAN_TIME_IN_SECONDS = "splunk.roll.age.time";
    public static final String CONF_NAMENODE_URI = "fs.default.name";
    public static final String CONF_BUCKET_DIRS = "splunk.roll.local.bucket.dirs";
    public static final String CONF_ROLL_THROTTLE_BITS_PER_SEC = "output.buckets.max.network.bandwidth";
    public static final String CONF_TEMP_STALE_TIMEOUT = "splunk.roll.stale.tempfile.timeout";
    public static final String CONF_JOURNAL_FIXING_ENABLED = "splunk.roll.fix.journals";

    private static <T> T force(T t) {
        if (t == null) {
            throw new RuntimeException("Configuration was not set. stacktrace=" + Arrays.toString(new Exception().getStackTrace()));
        }
        return t;
    }

    public static void setRollRemoteHome(Configuration conf, Path path) {
        conf.set(CONF_ROLL_REMOTE_HOME, path.toUri().toString());
    }

    public static Path getRollRoot(Configuration conf) {
        return new Path(new Path(ConfU.getRemoteHome(conf)), "archive");
    }

    public static Path getRollTemp(Configuration conf) {
        return new Path(new Path(ConfU.getRemoteHome(conf)), "tmp");
    }

    private static URI getRemoteHome(Configuration conf) {
        return URI.create(ConfU.force(conf.get(CONF_ROLL_REMOTE_HOME)));
    }

    public static String getRemoteHomeFromHdfsHome(String value) {
        return value + "/" + "roll";
    }

    public static void setRollIndex(Configuration conf, String index) {
        conf.set(CONF_ROLL_INDEX, index);
    }

    public static String getRollIndex(Configuration conf) {
        return ConfU.force(conf.get(CONF_ROLL_INDEX));
    }

    public static void setSplunkServerUUID(Configuration conf, String uuid) {
        conf.set(CONF_SPLUNK_SERVER_UUID, uuid);
    }

    public static String getSplunkServerUUID(Configuration conf) {
        return ConfU.force(conf.get(CONF_SPLUNK_SERVER_UUID));
    }

    public static int getPathResolverVersion(Configuration conf) {
        return conf.getInt(CONF_PATH_RESOLVER_VERSION, 3);
    }

    public static Date getRollOlderThanTime(Configuration conf) {
        long latestTimeToRoll = conf.getLong(CONF_ROLL_OLDER_THAN_TIME_IN_SECONDS, Long.MAX_VALUE);
        if (latestTimeToRoll == Long.MAX_VALUE) {
            throw new RuntimeException("Must have set an latest time to roll buckets from, so we can roll buckets older than that time.");
        }
        return DateU.getDate(latestTimeToRoll, TimeUnit.SECONDS);
    }

    public static void setRollOlderThanTime(Configuration conf, long time, TimeUnit unit) {
        conf.setLong(CONF_ROLL_OLDER_THAN_TIME_IN_SECONDS, TimeUnit.SECONDS.convert(time, unit));
    }

    public static void setRollLocalHome(Configuration conf, File path) {
        conf.set(CONF_ROLL_LOCAL_HOME, path.getAbsolutePath());
    }

    public static File getRollLocalHome(Configuration conf) {
        return new File(ConfU.force(conf.get(CONF_ROLL_LOCAL_HOME)));
    }

    public static void setFileSystemUri(Configuration conf, URI nameNode) {
        conf.set(CONF_NAMENODE_URI, nameNode.toString());
    }

    public static void setBucketDirs(Configuration conf, List<String> paths) {
        String joined = StringUtils.join(paths, (String)",");
        conf.set(CONF_BUCKET_DIRS, joined);
    }

    public static List<File> getBucketDirs(Configuration conf) {
        ArrayList<File> dirs = new ArrayList<File>();
        for (String dir : ConfU.force(conf.get(CONF_BUCKET_DIRS)).split(",")) {
            dirs.add(new File(dir));
        }
        return dirs;
    }

    public static String getRollVix(Configuration conf) {
        return conf.get(CONF_ROLL_VIX, "unknown");
    }

    public static void setRollVix(Configuration conf, String vixName) {
        conf.set(CONF_ROLL_VIX, vixName);
    }

    public static long getRollThrottleTransferRate(Configuration conf) {
        return conf.getLong(CONF_ROLL_THROTTLE_BITS_PER_SEC, 0L);
    }

    public static Time getStaleTempFilesTimeout(Configuration conf) {
        long timeoutInSecs = conf.getLong(CONF_TEMP_STALE_TIMEOUT, TimeUnit.SECONDS.convert(1L, TimeUnit.HOURS));
        return new Time(timeoutInSecs, TimeUnit.SECONDS);
    }

    public static boolean isJournalFixingEnabled(Configuration conf) {
        return StrUtil.parseBoolean(conf.get(CONF_JOURNAL_FIXING_ENABLED), false);
    }

    public static void setJournalFixingEnabled(Configuration conf, boolean enabled) {
        conf.setBoolean(CONF_JOURNAL_FIXING_ENABLED, enabled);
    }

    public static URI getSplunkServerURI(Configuration conf) {
        return URI.create(ConfU.force(conf.get(CONF_SPLUNK_SERVER_URI)));
    }

    public static String getSplunkServerAuthToken(Configuration conf) {
        return ConfU.force(conf.get(CONF_SPLUNK_SERVER_AUTH_TOKEN));
    }
}

