/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.datamodel;

import com.splunk.datasource.Field;
import com.splunk.datasource.Writer;
import com.splunk.datasource.WriterFactory;
import com.splunk.io.FastByteArrayOutputStream;
import com.splunk.mr.SplunkMR;
import com.splunk.mr.input.VirtualIndex;
import com.splunk.mr.input.VixInputSplit;
import com.splunk.util.StrUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.MD5Hash;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.log4j.Logger;
import org.codehaus.jackson.map.ObjectMapper;

public class DataModelCreator
extends Thread {
    private static Logger gLogger = Logger.getLogger(DataModelCreator.class);
    private FileSystem fs;
    private InputStream in;
    private Writer writer;
    private RuntimeException ex;
    private Path file;
    private Path tmpFile;
    private PipedStreamFlags flags;
    private List<Field> fields;
    private Mapper.Context context;
    private static final String ORC_FILE_FORMAT = "orc";
    private Pattern SPLUNK_HEADER_RE = Pattern.compile("\\s*splunk ([\\d\\.]+),(\\d+),(\\d+)");

    public DataModelCreator(InputStream in, Configuration conf, VixInputSplit split, FileSystem fs, PipedStreamFlags flags, Mapper.Context context) throws IOException {
        this.in = in;
        this.fs = fs;
        this.flags = flags;
        this.ex = null;
        this.context = context;
        this.file = DataModelCreator.getDataModelStagingFile(conf, split.getIndex(), split.getBucketId(), split.getEarliestTime(), split.getLatestTime(), split.getPath());
        gLogger.info((Object)("DataModel staging file::" + this.file.toString()));
        Path tmpDir = DataModelCreator.getTempDir(conf, split.getIndex());
        fs.mkdirs(tmpDir);
        fs.mkdirs(this.file.getParent());
        this.tmpFile = new Path(tmpDir, this.file.getName() + ".tmp_" + SplunkMR.HOSTNAME + UUID.randomUUID().toString());
        ObjectMapper mapper = new ObjectMapper();
        String schema = conf.get(SplunkMR.CONF_DATASOURCE_SCHEMA);
        List list = (List)mapper.readValue(schema, List.class);
        this.fields = new ArrayList<Field>();
        for (Map map : list) {
            if (gLogger.isDebugEnabled()) {
                gLogger.debug((Object)("FieldName::" + (String)map.get("fieldName")));
            }
            Field f = new Field((String)map.get("fieldName"), Field.FieldType.valueOf((String)map.get("fieldType")), Field.Repetition.valueOf((String)map.get("repetition")));
            this.fields.add(f);
        }
        this.writer = WriterFactory.getInstance(conf, this.tmpFile, this.fields);
    }

    public static void deleteTempDir(Configuration conf) throws IOException {
        FileSystem fs = FileSystem.get((Configuration)conf);
        for (VirtualIndex vix : VirtualIndex.parseIndexes(conf)) {
            String name = vix.getName();
            Path p = DataModelCreator.getTempDir(conf, name);
            fs.delete(p, true);
            gLogger.info((Object)("Deleted tmp dir:" + p.toUri().getPath()));
        }
    }

    public static boolean createLockFile(Configuration conf) throws IOException {
        Path p = DataModelCreator.getLockFile(conf);
        FileSystem fs = p.getFileSystem(conf);
        if (fs.exists(p)) {
            gLogger.info((Object)("Found lock file before trying to create it. Abort search because another search process is updating the data model. lock=" + p.toUri().getPath()));
            return false;
        }
        try {
            fs.create(p, false).close();
            gLogger.info((Object)("Created lock file " + p.toUri().getPath()));
        }
        catch (IOException e) {
            if (fs.exists(p)) {
                gLogger.info((Object)("Unable to create lock file. Aborting search. Is another search process is updating the data model?. lock=" + p.toUri().getPath()));
                return false;
            }
            try {
                fs.delete(p, false);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new IOException("Failed to create lock file " + p.toUri().getPath(), e);
        }
        return true;
    }

    public static void deleteLockFile(Configuration conf) throws IOException, InterruptedException {
        Path p = DataModelCreator.getLockFile(conf);
        FileSystem fs = p.getFileSystem(conf);
        int count = 0;
        while (count++ < 5 && fs.exists(p) && !fs.delete(p, false)) {
            gLogger.info((Object)("Failed to delete lock file " + p.toUri().getPath() + ", will try it again a second later."));
            Thread.sleep(1000L);
        }
        if (!fs.exists(p)) {
            gLogger.info((Object)("Deleted lock file " + p.toUri().getPath()));
            return;
        }
        throw new IOException("Failed to delete lock file " + p.toUri().getPath());
    }

    public static List<String> getExistingDataModelDirs(Configuration conf) throws IOException {
        Path baseDataModeDir = new Path(SplunkMR.getHDFSSplunkHome(conf), "datamodel");
        FileSystem fs = baseDataModeDir.getFileSystem(conf);
        ArrayList<String> dataModelDirs = new ArrayList<String>();
        for (FileStatus stat : fs.listStatus(baseDataModeDir)) {
            dataModelDirs.add(stat.getPath().getName());
        }
        return dataModelDirs;
    }

    public static Path getDataModelDirForSummaryId(Configuration conf, String summaryId) {
        String childPath = StringUtils.join((Object[])new String[]{"datamodel", summaryId}, (String)"/");
        return new Path(SplunkMR.getHDFSSplunkHome(conf), childPath);
    }

    public static Path getDataModelBaseDir(Configuration conf, String indexName) {
        String summaryId = SplunkMR.getDataModelSummaryId(conf);
        String childPath = StringUtils.join((Object[])new String[]{"datamodel", summaryId}, (String)"/");
        if (indexName != null) {
            childPath = childPath + "/" + indexName;
        }
        return new Path(SplunkMR.getHDFSSplunkHome(conf), childPath);
    }

    public static Path getDataModelDir(Configuration conf, String indexName, String bucketId) {
        return new Path(DataModelCreator.getDataModelBaseDir(conf, indexName), bucketId);
    }

    public static Path getDataModelStagingDir(Configuration conf, String indexName, String bucketId) {
        Path p = DataModelCreator.getDataModelDir(conf, indexName, bucketId);
        return new Path(p.getParent(), p.getName() + "_staging");
    }

    public static Path getDataModelStagingFile(Configuration conf, String indexName, String bucketId, long earliestTime, long latestTime, Path file) {
        Path stagingDir = DataModelCreator.getDataModelStagingDir(conf, indexName, bucketId);
        WriterFactory.Format format = WriterFactory.Format.valueOf(conf.get(SplunkMR.CONF_DATASOURCE_FORMAT, ORC_FILE_FORMAT));
        assert (format != null);
        String fileName = DataModelCreator.getDataModelFileName(file, earliestTime, latestTime, format);
        return new Path(stagingDir, fileName);
    }

    public static Path getDataModelFile(Configuration conf, String indexName, String bucketId, long earliestTime, long latestTime, Path file) {
        Path dataModelDir = DataModelCreator.getDataModelDir(conf, indexName, bucketId);
        WriterFactory.Format format = WriterFactory.Format.valueOf(conf.get(SplunkMR.CONF_DATASOURCE_FORMAT, ORC_FILE_FORMAT));
        assert (format != null);
        String fileName = DataModelCreator.getDataModelFileName(file, earliestTime, latestTime, format);
        return new Path(dataModelDir, fileName);
    }

    private static Path getLockFile(Configuration conf) {
        String summaryId = SplunkMR.getDataModelSummaryId(conf);
        return new Path(SplunkMR.getHDFSSplunkHome(conf), StringUtils.join((Object[])new String[]{"datamodel", summaryId, "updating.lock"}, (String)"/"));
    }

    private static Path getTempDir(Configuration conf, String indexName) {
        return new Path(DataModelCreator.getDataModelBaseDir(conf, indexName), "tmp");
    }

    private static String getDataModelFileName(Path file, long earliestTime, long latestTime, WriterFactory.Format format) {
        String hash = MD5Hash.digest((String)file.getParent().toUri().getPath()).toString();
        return hash + "_" + earliestTime + "_" + latestTime + "_" + file.getName() + "." + format.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object[] fieldNames = null;
        Object[] fieldValues = null;
        long time = System.currentTimeMillis();
        long recordCount = 0L;
        long lineNumber = 0L;
        int headerSize = 0;
        long bodySize = 0L;
        long remaining = 0L;
        int bytes = 0;
        FastByteArrayOutputStream out = new FastByteArrayOutputStream(256);
        HashMap<String, Object> keyValues = new HashMap<String, Object>();
        try {
            while ((bytes = StrUtil.readLine(this.in, out)) != 0) {
                ++lineNumber;
                String line = ((ByteArrayOutputStream)out).toString(StrUtil.UTF8.name());
                if (line.trim().length() == 0 || line.equals("\n")) continue;
                Matcher m = this.SPLUNK_HEADER_RE.matcher(line);
                if (!m.matches()) {
                    gLogger.error((Object)("Invalid header line: [" + line + "]"));
                    this.terminate(new IllegalStateException("Invalid header line. lineNumber=" + lineNumber));
                    return;
                }
                headerSize = Integer.parseInt(m.group(2));
                bodySize = Long.parseLong(m.group(3));
                remaining = (long)headerSize + bodySize;
                String msg = "Read a header at line " + lineNumber + ". headerSize=" + headerSize + ", bodySize=" + bodySize + ", recordCount=" + recordCount;
                gLogger.info((Object)msg);
                this.context.setStatus(msg);
                int n = 0;
                while (n < headerSize) {
                    if (this.in.read() != -1 || ++n >= headerSize) continue;
                    this.terminate(new IllegalStateException("Expected to read " + (headerSize - n) + " more bytes, but reach to EOF."));
                    return;
                }
                lineNumber += 2L;
                remaining -= (long)headerSize;
                if (bodySize <= 0L) {
                    gLogger.info((Object)"Chunk body size is 0, skip reading the rest of the chunk.");
                    ((ByteArrayOutputStream)out).reset();
                    continue;
                }
                ((ByteArrayOutputStream)out).reset();
                bytes = StrUtil.readLine(this.in, out);
                if (bytes == 0) {
                    gLogger.warn((Object)"Empty field names line encountered");
                    this.terminate(new IllegalStateException("Expected a header line, but reached to the end of stream. lineNumber=" + (lineNumber + 1L)));
                    return;
                }
                ++lineNumber;
                remaining -= (long)bytes;
                line = ((ByteArrayOutputStream)out).toString(StrUtil.UTF8.name());
                fieldNames = StrUtil.parseCSVLine(line, this.fields.size(), ',', '\"', '\\');
                if (gLogger.isDebugEnabled()) {
                    gLogger.debug((Object)("remaining=" + remaining + ", line=[" + line + "]"));
                }
                while (remaining != 0L) {
                    ((ByteArrayOutputStream)out).reset();
                    bytes = StrUtil.readLine(this.in, out);
                    ++lineNumber;
                    if (bytes == 0 && (remaining -= (long)bytes) != 0L) {
                        this.terminate(new IllegalStateException("Expected to read " + remaining + " more bytes, but reach to EOF."));
                        return;
                    }
                    line = ((ByteArrayOutputStream)out).toString(StrUtil.UTF8.name());
                    fieldValues = StrUtil.parseCSVLine(line, this.fields.size(), ',', '\"', '\"');
                    if (gLogger.isDebugEnabled()) {
                        gLogger.debug((Object)("remaining=" + remaining + ", line=[" + line + "]"));
                    }
                    if (fieldNames == null || fieldValues == null || fieldNames.length != fieldValues.length) {
                        gLogger.warn((Object)("Invalid body line. lineNumber=" + lineNumber + ", bodyLine=[" + line + "]"));
                        gLogger.warn((Object)("fieldNames.length=" + fieldNames.length + ", fieldNames=" + Arrays.toString(fieldNames)));
                        gLogger.warn((Object)("fieldValues.length=" + fieldValues.length + ", fieldValues=" + Arrays.toString(fieldValues)));
                        gLogger.warn((Object)("fields=" + this.fields));
                        this.terminate(new IllegalStateException("Failed to parse splunk search result. Header and value lines do not have same number of segments. lineNumber=" + lineNumber));
                        return;
                    }
                    keyValues.clear();
                    this.fillMap((String[])fieldNames, (String[])fieldValues, keyValues);
                    this.writer.write(keyValues);
                    ++recordCount;
                }
                ((ByteArrayOutputStream)out).reset();
            }
            gLogger.info((Object)String.format("Converted records=%d, elapsed_ms=%d to tmpFile=%s", recordCount, System.currentTimeMillis() - time, this.tmpFile));
        }
        catch (Exception e) {
            this.terminate("Failed to read and process splunk search result", e);
        }
        finally {
            try {
                this.writer.close();
                gLogger.info((Object)("Tmp File Information::" + this.fs.getFileStatus(this.tmpFile)));
            }
            catch (Exception e) {
                gLogger.error((Object)"Failed to close writer", (Throwable)e);
            }
            try {
                if (this.ex == null && this.fs.rename(this.tmpFile, this.file)) {
                    gLogger.info((Object)("Renamed tmpFile to file. tmpFile=" + this.tmpFile + ", file=" + this.file));
                }
            }
            catch (Exception e) {
                gLogger.error((Object)("Failed to rename tmpFile to file and clean up. tmpFile=" + this.tmpFile + ", file=" + this.file));
            }
        }
    }

    private void fillMap(String[] fieldNames, String[] fieldValues, Map<String, Object> keyValues) {
        for (int i = 0; i < fieldNames.length; ++i) {
            String fieldName = fieldNames[i];
            String[] fieldValue = fieldValues[i];
            if (fieldValue.isEmpty()) continue;
            String[] finalValue = fieldName.equals("nodename") ? fieldValue.split("\n") : fieldValue;
            keyValues.put(fieldName, finalValue);
        }
    }

    public void destroy() {
        try {
            this.interrupt();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void terminate(Exception e) {
        this.terminate(null, e);
    }

    private void terminate(String errorMessage, Exception e) {
        if (errorMessage != null) {
            gLogger.error((Object)errorMessage, (Throwable)e);
            this.ex = new RuntimeException(errorMessage, e);
        } else {
            this.ex = new RuntimeException(e);
        }
        this.flags.stopWriter = true;
        gLogger.info((Object)"set stopWriter to true");
        while (!this.flags.stopReader) {
            try {
                StrUtil.readline(this.in, StrUtil.UTF8.name());
                gLogger.info((Object)"Wait a second for writer thread to finish.");
                this.wait(1000L);
            }
            catch (Exception exception) {}
        }
        gLogger.info((Object)"terminated!!");
    }

    public RuntimeException getException() {
        return this.ex;
    }

    public static class PipedStreamFlags {
        public boolean stopWriter = false;
        public boolean stopReader = false;
    }
}

