/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.roll;

import com.splunk.mr.packaging.SynchronizedExecuter;
import java.io.File;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.FileUtils;

public class AbortConditionWithDeletionAndTimeout
implements SynchronizedExecuter.AbortCondition {
    private final File lockFile;
    private final Date timeToGiveUp;
    private final long timeToBecomeStaleMillis;
    private final TimeProvider timeProvider;
    private final AtomicBoolean hasAcquiredLock;

    private static final Date getDefaultTimeToGiveUp() {
        return new Date(System.currentTimeMillis() + TimeUnit.MILLISECONDS.convert(1L, TimeUnit.MINUTES));
    }

    private static final long getDefaultTimeForFileToGetStale() {
        return TimeUnit.MILLISECONDS.convert(5L, TimeUnit.MINUTES);
    }

    public AbortConditionWithDeletionAndTimeout(File lockFile, AtomicBoolean hasAcquiredLock) {
        this(lockFile, hasAcquiredLock, AbortConditionWithDeletionAndTimeout.getDefaultTimeToGiveUp(), AbortConditionWithDeletionAndTimeout.getDefaultTimeForFileToGetStale(), new TimeProvider());
    }

    AbortConditionWithDeletionAndTimeout(File lockFile, AtomicBoolean hasAcquiredLock, Date timeToGiveUp, long timeToBecomeStale, TimeProvider timeProvider) {
        this.lockFile = lockFile;
        this.hasAcquiredLock = hasAcquiredLock;
        this.timeToGiveUp = timeToGiveUp;
        this.timeToBecomeStaleMillis = timeToBecomeStale;
        this.timeProvider = timeProvider;
    }

    @Override
    public boolean shouldStopRetrying() {
        if (this.hasAcquiredLock.get()) {
            return true;
        }
        if (new Date(this.timeProvider.now()).after(this.timeToGiveUp)) {
            return true;
        }
        if (this.lockFile.exists() && this.isFileStale(this.lockFile)) {
            FileUtils.deleteQuietly((File)this.lockFile);
        }
        return false;
    }

    private boolean isFileStale(File lockFile) {
        Date longTimeAgo = new Date(this.timeProvider.now() - this.timeToBecomeStaleMillis);
        return new Date(lockFile.lastModified()).before(longTimeAgo);
    }

    public static class TimeProvider {
        public long now() {
            return System.currentTimeMillis();
        }
    }
}

