/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.filter.schema;

import com.splunk.datasource.parquet.converter.Group;
import com.splunk.filter.schema.BaseSchemaFilter;
import com.splunk.util.WildcardList;
import java.util.List;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.Type;

public class ParquetSchemaFilter
extends BaseSchemaFilter<Type, Type> {
    private boolean prefixMatch = true;

    public ParquetSchemaFilter() {
    }

    public ParquetSchemaFilter(boolean prefixMatch) {
        this.prefixMatch = prefixMatch;
    }

    @Override
    public MessageType filter(Type schema, WildcardList requiredFields) {
        return this.filter(schema, requiredFields, false);
    }

    @Override
    public MessageType filter(Type schema, WildcardList requiredFields, boolean ignoreRepeatableFieldSuffix) {
        return (MessageType)super.filter(schema, requiredFields, ignoreRepeatableFieldSuffix);
    }

    @Override
    public MessageType filter(Type schema, WildcardList requiredFields, boolean noMatchReturnAll, boolean matchAllNoFiltering) {
        return this.filter(schema, requiredFields, noMatchReturnAll, matchAllNoFiltering);
    }

    @Override
    public boolean isLeaf(Type field) {
        return field.isPrimitive();
    }

    @Override
    public boolean isRepeatable(Type field) {
        return field.isRepetition(Type.Repetition.REPEATED);
    }

    @Override
    public Type createSchema(List<Type> fields) {
        return new MessageType("filtered_schema", fields);
    }

    @Override
    public void processLeafField(List<Type> result, Type field, int fieldIndex, String candidate, WildcardList requiredFields) {
        if (requiredFields.matches(candidate)) {
            result.add(field);
        }
    }

    @Override
    public void processNonLeafField(List<Type> result, Type field, int fieldIndex, String candidate, WildcardList requiredFields) {
        List finalMatches;
        if (this.prefixMatch && (Group.isMap(field.asGroupType()) || Group.isList(field.asGroupType())) && requiredFields.isPrefixMatch(candidate)) {
            result.add(field);
        } else if (requiredFields.isPrefixMatch(candidate) && !(finalMatches = this.filter(candidate, field, requiredFields)).isEmpty()) {
            result.add((Type)new GroupType(field.getRepetition(), field.getName(), field.getOriginalType(), finalMatches));
        }
    }

    @Override
    protected List<Type> getFields(Type schema) {
        if (schema.isPrimitive()) {
            throw new RuntimeException("Not a group type: " + schema);
        }
        return schema.asGroupType().getFields();
    }

    @Override
    protected String getFieldName(Type field) {
        return field.getName();
    }

    public void setPrefixMatch(boolean prefixMatch) {
        this.prefixMatch = prefixMatch;
    }
}

