/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.sdk;

import com.splunk.df.util.SSLUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONTokener;

@Deprecated
public class SplunkMiniSDK {
    public static final String FORM_CONTENT_TYPE = "application/x-www-form";
    public static final String JSON_CONTENT_TYPE = "application/json";
    private static final String OUTPUT_MODE = "output_mode=json";
    private final URI uri;
    private String sessionToken;

    public SplunkMiniSDK(URI uri, String sessionToken) {
        this.uri = uri;
        if (this.isHttps()) {
            SSLUtil.trustEveryone();
        }
        this.sessionToken = sessionToken;
    }

    public SplunkMiniSDK(URI uri, String username, String password) throws IOException {
        this.uri = uri;
        if (this.isHttps()) {
            SSLUtil.trustEveryone();
        }
        this.sessionToken = this.getSessionToken(username, password);
    }

    public static SplunkMiniSDK create(URI uri, String user, String pass) throws IOException {
        return new SplunkMiniSDK(uri, new SplunkMiniSDK(uri, null).getSessionToken(user, pass));
    }

    private boolean isHttps() {
        return this.uri.getScheme().equals("https");
    }

    private String getSessionToken(String user, String pass) throws IOException {
        return this.post("/services/auth/login", "username", user, "password", pass).raw().getString("sessionKey");
    }

    private URI getEndpoint(String path, String ... kvs) throws UnsupportedEncodingException {
        return URI.create(this.uri.toString() + this.encodePath(path) + "?" + OUTPUT_MODE + this.createUrlParams(kvs));
    }

    private String encodePath(String path) throws UnsupportedEncodingException {
        ArrayList<String> pathParts = new ArrayList<String>();
        for (String p : path.split("/")) {
            pathParts.add(this.encode(p));
        }
        return StringUtils.join(pathParts, (String)"/");
    }

    private String encode(String s) throws UnsupportedEncodingException {
        return URLEncoder.encode(s, "UTF-8");
    }

    private String createUrlParams(String[] kvs) throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder();
        if (kvs.length % 2 != 0) {
            throw new IllegalArgumentException("kvs need to be divisible by two: " + Arrays.toString(kvs));
        }
        for (int i = 0; i < kvs.length; i += 2) {
            sb.append("&");
            sb.append(this.encode(kvs[i]));
            sb.append("=");
            sb.append(this.encode(kvs[i + 1]));
        }
        return sb.toString();
    }

    public SplunkResponse get(String path, String ... kvs) throws IOException {
        return this.executeHttpRequest(this.getEndpoint(path, kvs), new HttpMethod(){

            @Override
            public void handleConnection(HttpURLConnection conn) throws IOException {
                conn.setRequestMethod("GET");
            }
        });
    }

    public SplunkResponse post(String path, String ... kvs) throws IOException {
        return this.doPost(path, this.createUrlParams(kvs), FORM_CONTENT_TYPE);
    }

    public SplunkResponse postJSON(String path, String postData) throws IOException {
        return this.doPost(path, postData, JSON_CONTENT_TYPE);
    }

    private SplunkResponse doPost(String path, final String postData, final String contentType) throws IOException {
        return this.executeHttpRequest(this.getEndpoint(path, new String[0]), new HttpMethod(){

            @Override
            public void handleConnection(HttpURLConnection conn) throws IOException {
                conn.setDoOutput(true);
                conn.setRequestMethod("POST");
                conn.setRequestProperty("Content-Type", contentType);
                conn.setRequestProperty("Content-Length", "" + postData.length());
                OutputStream out = null;
                try {
                    out = conn.getOutputStream();
                    IOUtils.write((byte[])postData.getBytes(), (OutputStream)out);
                }
                finally {
                    IOUtils.closeQuietly((OutputStream)out);
                }
            }
        });
    }

    public SplunkResponse delete(String path, String ... kvs) throws IOException {
        return this.executeHttpRequest(this.getEndpoint(path, kvs), new HttpMethod(){

            @Override
            public void handleConnection(HttpURLConnection conn) throws IOException {
                conn.setRequestMethod("DELETE");
            }
        });
    }

    private SplunkResponse executeHttpRequest(URI endpoint, HttpMethod httpMethod) throws IOException {
        SplunkResponse resp;
        block4: {
            SplunkResponse splunkResponse;
            InputStream in = null;
            try {
                URL u = endpoint.toURL();
                HttpURLConnection conn = (HttpURLConnection)u.openConnection();
                if (this.sessionToken != null) {
                    conn.setRequestProperty("Authorization", "Splunk " + this.sessionToken);
                }
                httpMethod.handleConnection(conn);
                in = this.getInputStream(conn);
                resp = new SplunkResponse(conn.getResponseCode(), this.parseContent(in));
                if (!resp.is2xx()) break block4;
                splunkResponse = resp;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)in);
            return splunkResponse;
        }
        throw new SplunkResponseException(resp);
    }

    private InputStream getInputStream(HttpURLConnection conn) {
        try {
            return conn.getInputStream();
        }
        catch (Exception e) {
            return conn.getErrorStream();
        }
    }

    private synchronized JSONObject parseContent(InputStream content) throws IOException {
        try {
            JSONTokener tokener = new JSONTokener(content);
            return new JSONObject(tokener);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getURI() {
        return this.uri.toString();
    }

    public static class SplunkResponse {
        private final int statusCode;
        private final JSONObject raw;

        public SplunkResponse(int statusCode, JSONObject raw) {
            this.statusCode = statusCode;
            this.raw = raw;
        }

        public JSONObject raw() throws IOException {
            return this.raw;
        }

        public JSONArray entries() throws IOException {
            return this.raw.getJSONArray("entry");
        }

        public JSONObject firstEntry() throws IOException {
            return this.entries().getJSONObject(0);
        }

        public boolean is2xx() {
            return this.statusCode >= 200 && this.statusCode < 300;
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public String toString() {
            return "Status Code::" + this.statusCode + ", Message::" + this.raw.toString();
        }
    }

    public static class SplunkResponseException
    extends IOException {
        private static final long serialVersionUID = 1L;
        private final SplunkResponse response;

        public SplunkResponseException(SplunkResponse response) {
            super("Did not get a 2xx status code when executing request. Got status_code=" + response.getStatusCode() + ". See SplunkResponseException.getResponse() for more info.");
            this.response = response;
        }

        public SplunkResponse getResponse() {
            return this.response;
        }
    }

    private static interface HttpMethod {
        public void handleConnection(HttpURLConnection var1) throws IOException;
    }
}

