/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search;

import com.splunk.df.search.DFSSearchConstants;
import com.splunk.df.search.NIOSearchResultsReceiverManager;
import com.splunk.df.search.RemoteSearchInfo;
import com.splunk.df.search.compute.ComputeEngineConstants;
import com.splunk.df.search.compute.ComputeEngineContext;
import com.splunk.df.search.compute.DistributedDataset;
import com.splunk.df.search.compute.Exploder;
import com.splunk.df.search.compute.SearchResult;
import com.splunk.df.search.compute.transformers.FieldExtractor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class BaseInputDDFactory
implements DFSSearchConstants,
ComputeEngineConstants {
    static final Logger logger = Logger.getLogger(BaseInputDDFactory.class);
    private static long rdoutTimeoutMillis = 300000L;
    private static boolean abortOnRdoutTimeout;

    public static DistributedDataset createInputDD(DistributedDataset receiversDD, final RemoteSearchInfo[] remoteSearchInfos, final long parSize, ComputeEngineContext ctx) {
        logger.info((Object)String.format("Base rdin dd partition size: %d", parSize));
        final ArrayList emptyRes = new ArrayList();
        DistributedDataset srDD = receiversDD.transform(new Exploder(){
            private static final long serialVersionUID = 1L;

            @Override
            public Iterator<SearchResult> explode(SearchResult metaSr) {
                if (metaSr.getDataMap().isEmpty()) {
                    return emptyRes.iterator();
                }
                return new Iterator<SearchResult>(){
                    NIOSearchResultsReceiverManager.SearchResultChunk chunk = null;
                    long srReturnedSoFar = 0L;

                    @Override
                    public boolean hasNext() {
                        if (this.chunk != null && this.chunk.hasNext()) {
                            return true;
                        }
                        if (this.srReturnedSoFar > parSize) {
                            return false;
                        }
                        this.chunk = NIOSearchResultsReceiverManager.getInstance().getNextSearchResultChunk(remoteSearchInfos, true, rdoutTimeoutMillis, abortOnRdoutTimeout);
                        return this.chunk != null && this.chunk.hasNext();
                    }

                    @Override
                    public SearchResult next() {
                        SearchResult ret = this.chunk.next();
                        ++this.srReturnedSoFar;
                        return ret;
                    }

                    @Override
                    public void remove() {
                    }
                };
            }

            @Override
            public FieldExtractor.ExtractionHint fieldExtractionHint() {
                return FieldExtractor.ExtractionHint.UNKNOWN;
            }
        });
        if (remoteSearchInfos.length > 1) {
            srDD = srDD.cacheDisk();
            logger.info((Object)String.format("Since number of remote searches > 1: %d - the dd is cached (disk) for per remote sid filtration", remoteSearchInfos.length));
        } else {
            logger.info((Object)String.format("Since number of remote searches < 2: %d the dd is NOT cached for per remote sid filtration", remoteSearchInfos.length));
        }
        String cacheBaseDDStr = System.getenv("DFC_CACHE_BASE_DD");
        if (cacheBaseDDStr != null && Boolean.valueOf(cacheBaseDDStr).booleanValue()) {
            long start = System.currentTimeMillis();
            if (remoteSearchInfos.length == 1) {
                srDD = srDD.cacheDisk();
                logger.info((Object)String.format("as instructed by envvar - caching the base dd for read stats even though it is a single sourced dag", new Object[0]));
            }
            long count = srDD.count();
            long elapsed = System.currentTimeMillis() - start;
            logger.info((Object)String.format("number of records read by base dd: %d, total time: %d millis, recs read per millis: %d", count, elapsed, count / elapsed));
            logger.info((Object)String.format("sample records received by base dd: ", new Object[0]));
            List<SearchResult> sample = srDD.retrieve(10);
            for (SearchResult sr : sample) {
                logger.info((Object)String.format("sample based dd record: %s", sr.toString()));
            }
        }
        logger.info((Object)String.format("Number of partitions of rdin dataset: %d", srDD.partitions()));
        DistributedDataset sriDD = receiversDD.transform(new Exploder(){
            private static final long serialVersionUID = 1L;

            @Override
            public Iterator<SearchResult> explode(SearchResult sr) {
                if (sr.getDataMap().isEmpty()) {
                    return new ArrayList().iterator();
                }
                ArrayList<SearchResult> sris = new ArrayList<SearchResult>();
                SearchResult sri = NIOSearchResultsReceiverManager.getInstance().getLatestSRI(remoteSearchInfos, sr, rdoutTimeoutMillis, abortOnRdoutTimeout);
                if (sri != null) {
                    sris.add(sri);
                }
                return sris.iterator();
            }

            @Override
            public FieldExtractor.ExtractionHint fieldExtractionHint() {
                return FieldExtractor.ExtractionHint.NOT_PRECOMPUTED;
            }
        });
        sriDD = sriDD.repartition(1);
        srDD = srDD.setSriDD(sriDD);
        logger.info((Object)String.format("Number of partitions in sriDD: %d, and number of pars in receivers dd: %d", sriDD.partitions(), receiversDD.partitions()));
        return srDD;
    }

    static {
        String temp = System.getenv("NEXT_RDOUT_SR_TIMEOUT_MILLIS");
        if (temp != null) {
            rdoutTimeoutMillis = Long.parseLong(temp);
            logger.info((Object)String.format("rdout timeout millis set to: %d based on envvar", rdoutTimeoutMillis));
        } else {
            logger.info((Object)String.format("rdout timeout millis set to: %d", rdoutTimeoutMillis));
        }
        abortOnRdoutTimeout = false;
        temp = System.getenv("ABORT_ON_RDOUT_TIMEOUT");
        if (temp != null) {
            abortOnRdoutTimeout = Boolean.parseBoolean(temp);
            logger.info((Object)String.format("abort search on rdout timeout set to: %b based on envvar", abortOnRdoutTimeout));
        } else {
            logger.info((Object)String.format("abort search on rdout timeout: %b", abortOnRdoutTimeout));
        }
    }
}

