/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search;

import com.splunk.df.search.compute.SearchResult;
import com.splunk.df.search.compute.SearchResultFactory;
import java.io.Reader;
import java.util.Iterator;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.log4j.Logger;

public class SearchResultsReader
implements Iterator<SearchResult> {
    static Logger logger = null;
    private SearchResult nextsr;
    private Iterator<CSVRecord> recs;
    private CSVParser parser;
    private SearchResult.FieldMeta[] fields;

    public SearchResultsReader(Reader r) {
        try {
            this.parser = new CSVParser(r, CSVFormat.DEFAULT);
            this.recs = this.parser.iterator();
            if (this.recs.hasNext()) {
                CSVRecord header = this.recs.next();
                SearchResult.FieldMeta[] fields = SearchResultsReader.getFields(header);
                this.fields = fields;
            } else {
                logger.debug((Object)String.format("Could not find header in search results chunk, it will be considered as empty chunk", new Object[0]));
            }
        }
        catch (Throwable t) {
            logger.error((Object)String.format("Error creating search results iterator, error=%s", t.getMessage()), t);
            throw new RuntimeException(String.format("could not parse search results due to error: %s", t.getMessage()), t);
        }
    }

    private static SearchResult.FieldMeta[] getFields(CSVRecord rec) {
        int size = rec.size();
        SearchResult.FieldMeta[] fields = new SearchResult.FieldMeta[size];
        for (int i = 0; i < size; ++i) {
            String fieldName = rec.get(i);
            SearchResult.FieldMeta field = SearchResult.FieldMeta.newFieldMeta(fieldName);
            SearchResult.FieldType type = SearchResultFactory.getType(field);
            field.setType(type);
            field.setSequence(i);
            fields[i] = field;
        }
        return fields;
    }

    @Override
    public boolean hasNext() {
        SearchResult sr;
        if (this.fields == null) {
            logger.debug((Object)String.format("Header fields not set hence it is an empty search results csv chunk", new Object[0]));
            return false;
        }
        if (this.nextsr != null) {
            return true;
        }
        if (!this.recs.hasNext()) {
            try {
                this.parser.close();
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
            return false;
        }
        CSVRecord rec = this.recs.next();
        this.nextsr = sr = SearchResultFactory.getInstance().createSearchResult(this.fields, rec);
        return true;
    }

    @Override
    public SearchResult next() {
        SearchResult tempsr = this.nextsr;
        this.nextsr = null;
        return tempsr;
    }

    @Override
    public void remove() {
        logger.warn((Object)"Does not support remove() method.");
    }

    static {
        logger = Logger.getLogger(SearchResultsReader.class);
    }
}

