/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search;

import com.splunk.CollectionArgs;
import com.splunk.Entity;
import com.splunk.EntityCollection;
import com.splunk.Event;
import com.splunk.Job;
import com.splunk.JobArgs;
import com.splunk.JobCollection;
import com.splunk.ResultsReaderXml;
import com.splunk.SSLSecurityProtocol;
import com.splunk.Service;
import com.splunk.ServiceArgs;
import com.splunk.df.search.compute.ComputeEngineConstants;
import com.splunk.df.search.compute.SearchResult;
import com.splunk.df.search.compute.SearchResultFactory;
import com.splunk.df.search.compute.SplunkSearchEndpoint;
import com.splunk.df.search.compute.sdk.Pair;
import com.splunk.df.util.Utils;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class SplunkRestUtils
implements ComputeEngineConstants {
    static Logger logger = null;

    private static SearchResult toSearchResult(Event event, SearchResult metaInfo) {
        int size = event.size();
        SearchResult.SRHashMap<SearchResult.FieldMeta, Object> data = new SearchResult.SRHashMap<SearchResult.FieldMeta, Object>(size + 1, 1.0f);
        SearchResult.FieldMeta[] fields = new SearchResult.FieldMeta[size];
        Object[] values = new Object[size];
        Set keys = event.keySet();
        Iterator ki = keys.iterator();
        int i = 0;
        while (ki.hasNext()) {
            String key = (String)ki.next();
            String value = event.get(key);
            fields[i] = SearchResult.FieldMeta.newFieldMeta(key);
            values[i] = value;
            data.put(fields[i], value);
            ++i;
        }
        SearchResult nextResult = SearchResultFactory.getInstance().createSearchResult(data, fields, values);
        nextResult = Utils.mergeMetaInfo(nextResult, metaInfo);
        return nextResult;
    }

    public static Pair<String, Iterator<SearchResult>> getSplunkSearchResultIterator(SearchResult metaInfo, long numRecs) {
        if (metaInfo.isEmpty()) {
            return new Pair<Object, Object>(null, null);
        }
        logger.debug((Object)String.format("metaInfo = %s, numRecs = %d", metaInfo.toString(), numRecs));
        SplunkSearchEndpoint sh = (SplunkSearchEndpoint)metaInfo.getFieldValue(SPLUNK_SEARCH_HEAD);
        if (sh == null) {
            return new Pair<Object, Object>(null, null);
        }
        String spl = (String)metaInfo.getFieldValue(SPL);
        String host = sh.getHost();
        int port = sh.getPort();
        String usr = sh.getUser();
        String passwd = sh.getPassword();
        return SplunkRestUtils.getSplunkSearchResultIterator(host, port, usr, passwd, spl, numRecs, metaInfo);
    }

    public static Pair<String, Iterator<SearchResult>> getSplunkSearchResultIterator(String host, int port, String user, String password, String spl, long numRecs) {
        return SplunkRestUtils.getSplunkSearchResultIterator(host, port, user, password, spl, numRecs, null);
    }

    public static Pair<String, Iterator<SearchResult>> getSplunkSearchResultIterator(SplunkSearchEndpoint ssh, long numRecs) {
        return SplunkRestUtils.getSplunkSearchResultIterator(ssh.getHost(), ssh.getPort(), ssh.getUser(), ssh.getPassword(), ssh.getSPL(), numRecs);
    }

    public static Pair<String, Iterator<SearchResult>> getSplunkSearchResultIterator(String host, int port, String user, String password, String spl, long numRecs, SearchResult metaInfo) {
        logger.info((Object)("Host ->" + host + " port-->" + port + " user-->" + user + " spl==>" + spl));
        ServiceArgs loginArgs = new ServiceArgs();
        loginArgs.setUsername(user);
        loginArgs.setPassword(password);
        loginArgs.setHost(host);
        loginArgs.setPort(port);
        loginArgs.setSSLSecurityProtocol(SSLSecurityProtocol.TLSv1_2);
        Service service = Service.connect((Map)loginArgs);
        JobCollection jobs = service.getJobs();
        JobArgs jobArgs = new JobArgs();
        jobArgs.setExecutionMode(JobArgs.ExecutionMode.NORMAL);
        jobArgs.setMaximumCount(Integer.MAX_VALUE);
        jobArgs.setAutoCancel(0);
        Job job = jobs.create(spl, jobArgs);
        String sid = job.getSid();
        logger.info((Object)String.format("Running search on splunk search head: %s:%d, spl: %s, sid: %s", host, port, spl, sid));
        boolean[] abort = new boolean[1];
        long start = System.currentTimeMillis();
        while (!job.isReady()) {
            long elapsed;
            block4: {
                try {
                    if (job.isFailed()) {
                        abort[0] = true;
                        throw new RuntimeException(String.format("Search job failed for sid: %s", sid));
                    }
                    Thread.sleep(10L);
                }
                catch (Throwable t) {
                    if (!abort[0]) break block4;
                    throw new RuntimeException(String.format("Aborting search since search failed: %s", sid));
                }
            }
            if ((elapsed = System.currentTimeMillis() - start) <= 60000L) continue;
            throw new RuntimeException(String.format("Search job did not report as ready within timeout limits: sid: %s, elapsed: %d millis", sid, elapsed));
        }
        logger.info((Object)String.format("Splunk search: %s, ready to return results", sid));
        Entity restApi = (Entity)((EntityCollection)service.getConfs().get((Object)"limits")).get((Object)"restapi");
        int chunkSize = Integer.parseInt((String)restApi.get((Object)"maxresultrows"));
        SplunkResultIterator srs = new SplunkResultIterator(job, chunkSize, numRecs, metaInfo);
        return new Pair<String, Iterator<SearchResult>>(sid, srs);
    }

    public static void main(String[] args) {
        String host = "10.224.50.163";
        int port = 36584;
        String user = "fshdep1_163";
        String password = "changed";
        String spl = "search index=airlinedata| stats count by ArrDelay";
        long numRecs = Long.MAX_VALUE;
        Pair<String, Iterator<SearchResult>> myresult = SplunkRestUtils.getSplunkSearchResultIterator(host, port, user, password, spl, Long.MAX_VALUE, null);
        Iterator<SearchResult> srItr = myresult.second();
        while (srItr.hasNext()) {
            SearchResult sr = srItr.next();
            logger.debug((Object)("SR --> " + sr.toString()));
        }
    }

    static {
        PropertyConfigurator.configure((String)(System.getenv("SPARK_HOME") + "/conf/log4j.properties"));
        logger = Logger.getLogger(SplunkRestUtils.class);
    }

    private static class SplunkResultIterator
    implements Iterator<SearchResult> {
        private int eventsOffset;
        private Job job;
        Iterator<Event> currentChunk;
        CollectionArgs collectArgs;
        private long numRecs;
        private String sid;
        private SearchResult metaInfo;

        SplunkResultIterator(Job job, int chunkSize, long numRecs, SearchResult metaInfo) {
            this.numRecs = numRecs;
            this.job = job;
            this.sid = job.getSid();
            this.eventsOffset = 0;
            this.collectArgs = new CollectionArgs();
            this.collectArgs.setCount(chunkSize);
            this.currentChunk = this.getNextChunk(job, this.collectArgs);
            this.metaInfo = metaInfo;
        }

        @Override
        public boolean hasNext() {
            if ((long)this.eventsOffset > this.numRecs) {
                logger.info((Object)String.format("Stopping reading search results since num recs: %d is exceeded: %d", this.numRecs, this.eventsOffset));
                return false;
            }
            if (this.currentChunk.hasNext()) {
                return true;
            }
            long waitMillis = 100L;
            boolean jobFinished = false;
            while (true) {
                this.collectArgs.setOffset(this.eventsOffset);
                this.currentChunk = this.getNextChunk(this.job, this.collectArgs);
                if (this.currentChunk.hasNext()) {
                    return true;
                }
                if (jobFinished) {
                    logger.info((Object)"Job is finished, tried to fetch another chunk but did not get any results");
                    return false;
                }
                if (!this.job.isDone()) {
                    try {
                        Thread.sleep(waitMillis);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                jobFinished = true;
                logger.info((Object)"Job is finished, will keep reading the chunks till the end");
            }
        }

        @Override
        public SearchResult next() {
            ++this.eventsOffset;
            return SplunkRestUtils.toSearchResult(this.currentChunk.next(), this.metaInfo);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private Iterator<Event> getNextChunk(Job job, CollectionArgs collectArgs) {
            try {
                return new ResultsReaderXml(job.getResults((Map)collectArgs)).iterator();
            }
            catch (IOException e) {
                throw new RuntimeException(String.format("Error while reading from splunk rest endpoint: sid: %s", this.sid), e);
            }
        }
    }
}

