/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search.compute;

import com.splunk.df.search.SplunkReleaseVersion;
import java.io.Serializable;
import org.json.JSONObject;

public class SplunkSearchEndpoint
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String provider = "splunk";
    private String host;
    private int port;
    private String user;
    private String password;
    private String splToExecute;
    private SplunkReleaseVersion version;

    public SplunkSearchEndpoint(JSONObject metaInfo) {
        String hostport = metaInfo.getString("hostport");
        String[] tokens = hostport.split(":");
        this.host = tokens[0];
        this.port = Integer.valueOf(tokens[1]);
        this.user = metaInfo.getString("username");
        this.password = metaInfo.getString("password");
        this.splToExecute = metaInfo.getString("spl");
        this.version = null;
    }

    public SplunkSearchEndpoint(String host, int port, String user, String password) {
        this.host = host;
        this.port = port;
        this.user = user;
        this.password = password;
        this.splToExecute = null;
        this.version = null;
    }

    public SplunkSearchEndpoint(String host, int port, String user, String password, String spl, SplunkReleaseVersion version) {
        this.host = host;
        this.port = port;
        this.user = user;
        this.password = password;
        this.splToExecute = spl;
        this.version = version;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public String getProvider() {
        return provider;
    }

    public String getSPL() {
        return this.splToExecute;
    }

    public SplunkReleaseVersion getVersion() {
        return this.version;
    }

    public String toString() {
        return String.format("Splunk search endpoint: %s:%s@%s:%d -> \"%s\"", this.user, this.password, this.host, this.port, this.splToExecute);
    }
}

