/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search.compute.transformers;

import com.splunk.commons.ast.nodes.CommandNode;
import com.splunk.commons.ast.nodes.commands.DedupCommand;
import com.splunk.commons.ast.nodes.commands.EvalCommand;
import com.splunk.commons.ast.nodes.commands.FieldsCommand;
import com.splunk.commons.ast.nodes.commands.HeadCommand;
import com.splunk.commons.ast.nodes.commands.JoinCommand;
import com.splunk.commons.ast.nodes.commands.NoOpCommand;
import com.splunk.commons.ast.nodes.commands.RenameCommand;
import com.splunk.commons.ast.nodes.commands.ReverseCommand;
import com.splunk.commons.ast.nodes.commands.SearchCommand;
import com.splunk.commons.ast.nodes.commands.SortCommand;
import com.splunk.commons.ast.nodes.commands.StatsCommand;
import com.splunk.commons.ast.nodes.commands.TableCommand;
import com.splunk.commons.ast.nodes.commands.TailCommand;
import com.splunk.commons.ast.nodes.commands.UnionCommand;
import com.splunk.commons.ast.nodes.commands.UnknownCommand;
import com.splunk.commons.ast.nodes.commands.WhereCommand;
import com.splunk.commons.visitors.SplFormatter;
import com.splunk.df.search.compute.BaseTransformer;
import com.splunk.df.search.compute.ComputeEngineConstants;
import com.splunk.df.search.compute.ComputeEngineContext;
import com.splunk.df.search.compute.DistributedDataset;
import com.splunk.df.search.compute.SearchResult;
import com.splunk.df.search.compute.transformers.NativeSearchParallelizer;
import com.splunk.df.search.compute.transformers.RdInTransformer;
import com.splunk.df.search.compute.transformers.SplunkRestSearcher;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class BaseTransformerFactory
implements ComputeEngineConstants {
    static final Logger logger = Logger.getLogger(BaseTransformerFactory.class);
    private HashMap<String, BaseTransformer> transformers = new HashMap();
    private static BaseTransformerFactory singleton;

    private BaseTransformerFactory() {
        this.transformers.put("RdinTransformer", new RdInTransformer());
        this.transformers.put("NSPTransformer", new NativeSearchParallelizer());
        this.transformers.put("SplunkRestTransformer", new SplunkRestSearcher());
    }

    public static BaseTransformerFactory getInstance() {
        if (singleton == null) {
            singleton = new BaseTransformerFactory();
        }
        return singleton;
    }

    public boolean canExecuteExternal(CommandNode node, CommandNode parent) {
        if (node == null || parent == null) {
            throw new IllegalArgumentException("Command node cannot be null");
        }
        if (parent instanceof HeadCommand || parent instanceof JoinCommand || parent instanceof ReverseCommand || parent instanceof SortCommand || parent instanceof StatsCommand || parent instanceof TailCommand || parent instanceof UnionCommand || parent instanceof FieldsCommand || parent instanceof RenameCommand || parent instanceof UnknownCommand || parent instanceof DedupCommand || parent instanceof NoOpCommand || parent instanceof WhereCommand) {
            return true;
        }
        CommandNode[] sources = parent.getSources();
        if (sources == null || sources.length == 0) {
            return false;
        }
        parent = sources[0];
        return this.canExecuteExternal(node, parent);
    }

    public static String getActualSpl(CommandNode cmd) {
        SplFormatter fmt = new SplFormatter();
        if (cmd instanceof EvalCommand) {
            return fmt.visit((EvalCommand)cmd);
        }
        if (cmd instanceof FieldsCommand) {
            return fmt.visit((FieldsCommand)cmd);
        }
        if (cmd instanceof HeadCommand) {
            return fmt.visit((HeadCommand)cmd);
        }
        if (cmd instanceof ReverseCommand) {
            return fmt.visit((ReverseCommand)cmd);
        }
        if (cmd instanceof StatsCommand) {
            return fmt.visit((StatsCommand)cmd);
        }
        if (cmd instanceof SearchCommand) {
            return fmt.visit((SearchCommand)cmd);
        }
        if (cmd instanceof SortCommand) {
            return fmt.visit((SortCommand)cmd);
        }
        if (cmd instanceof TableCommand) {
            return fmt.visit((TableCommand)cmd);
        }
        if (cmd instanceof TailCommand) {
            return fmt.visit((TailCommand)cmd);
        }
        if (cmd instanceof UnionCommand) {
            return fmt.visit((UnionCommand)cmd);
        }
        if (cmd instanceof DedupCommand) {
            return fmt.visit((DedupCommand)cmd);
        }
        if (cmd instanceof RenameCommand) {
            return fmt.visit((RenameCommand)cmd);
        }
        if (cmd instanceof WhereCommand) {
            return fmt.visit((WhereCommand)cmd);
        }
        if (cmd instanceof NoOpCommand) {
            return fmt.visit((NoOpCommand)cmd);
        }
        throw new IllegalStateException("Unsupported search command: " + cmd);
    }

    private BaseTransformer getDefaultTransformer(ComputeEngineContext ctx) {
        String defaultExternal = (String)ctx.get("externalSource");
        logger.debug((Object)String.format("Default external : %s", defaultExternal));
        return this.transformers.get(defaultExternal);
    }

    public DistributedDataset transform(DistributedDataset dd, CommandNode node, ComputeEngineContext ctx) {
        return this.getDefaultTransformer(ctx).transform(dd, node, false, ctx);
    }

    public boolean isPreStaged(ComputeEngineContext ctx) {
        return ctx.get("externalSource").equals("NSPTransformer");
    }

    public boolean addTransformer(String name, BaseTransformer transformer) {
        if (this.transformers.containsKey(name)) {
            return false;
        }
        this.transformers.put(name, transformer);
        return true;
    }

    public List<SearchResult> getMetaInfo(DistributedDataset dd, CommandNode node, ComputeEngineContext ctx) {
        return this.getDefaultTransformer(ctx).getMetaInfo(dd, node, ctx);
    }

    public DistributedDataset explode(DistributedDataset dd, CommandNode node, ComputeEngineContext ctx, List<SearchResult> metainfo) {
        return this.getDefaultTransformer(ctx).explode(dd, node, ctx, metainfo);
    }
}

