/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search.compute.transformers;

import com.splunk.commons.ast.nodes.CommandNode;
import com.splunk.commons.ast.nodes.commands.JoinCommand;
import com.splunk.df.search.compute.ComputeEngineContext;
import com.splunk.df.search.compute.DistributedDataset;
import com.splunk.df.search.compute.Transformer;
import com.splunk.df.search.compute.TransformerRegistry;
import com.splunk.df.search.compute.transformers.BaseTransformerFactory;
import org.apache.log4j.Logger;

public class JoinTransformer
implements Transformer {
    static final Logger logger = Logger.getLogger(JoinTransformer.class);

    @Override
    public DistributedDataset transform(DistributedDataset dd, CommandNode qcmd, boolean streaming, ComputeEngineContext ctx) {
        return JoinTransformer._transform(ctx, dd, (JoinCommand)qcmd, streaming);
    }

    private static DistributedDataset _transform(ComputeEngineContext ctx, DistributedDataset dd, JoinCommand jcmd, boolean streaming) {
        if (jcmd.getMax() != 0) {
            logger.info((Object)String.format("DFS does not support non zero max value: %d, defaulting it to 0", jcmd.getMax()));
        }
        if (jcmd.isUsetime() || jcmd.isEarlier() || jcmd.isOverwrite()) {
            logger.info((Object)"DFS does not support usetime, earlier or overwrite options hence ignoring them");
        }
        CommandNode lhs = jcmd.getLhs();
        DistributedDataset lhsdd = dd;
        boolean lhsRepartition = false;
        boolean rhsRepartition = false;
        if (lhs != null) {
            boolean executeExternal;
            boolean bl = executeExternal = !BaseTransformerFactory.getInstance().canExecuteExternal((CommandNode)jcmd, lhs);
            if (executeExternal) {
                lhsdd = BaseTransformerFactory.getInstance().transform(lhsdd, lhs, ctx);
                logger.debug((Object)"Base transformer used to create lhs dataset");
                lhsRepartition = true;
            } else {
                Transformer t = ((TransformerRegistry)ctx.get("dfs.dataset.transformer.registry")).getTransformer(lhs);
                lhsdd = t.transform(lhsdd, lhs, streaming, ctx);
            }
        }
        int numFieldsLhs = 6;
        if (ctx.hasContext("numfields")) {
            numFieldsLhs = (Integer)ctx.get("numfields");
        }
        CommandNode rhs = jcmd.getRhs();
        DistributedDataset rhsdd = dd;
        if (rhs != null) {
            boolean executeExternal;
            boolean bl = executeExternal = !BaseTransformerFactory.getInstance().canExecuteExternal((CommandNode)jcmd, rhs);
            if (executeExternal) {
                rhsdd = BaseTransformerFactory.getInstance().transform(rhsdd, rhs, ctx);
                logger.debug((Object)"Base transformer used to create rhs dataset");
                rhsRepartition = true;
            } else {
                Transformer t = ((TransformerRegistry)ctx.get("dfs.dataset.transformer.registry")).getTransformer(rhs);
                rhsdd = t.transform(rhsdd, rhs, streaming, ctx);
            }
        }
        int numFieldsRhs = 6;
        if (ctx.hasContext("numfields")) {
            numFieldsRhs = (Integer)ctx.get("numfields");
        }
        int numFields = numFieldsRhs + numFieldsLhs;
        ctx.addContext("command.node", jcmd);
        ctx.addContext("numfields", numFields);
        logger.debug((Object)String.format("join: lhs pars: %d, rhs pars: %d", lhsdd.partitions(), rhsdd.partitions()));
        return lhsdd.join(rhsdd, jcmd, lhsRepartition, rhsRepartition);
    }

    @Override
    public String name() {
        return "com.splunk.df.search.compute.transformers.JoinTransformer";
    }
}

