/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search.compute.transformers;

import com.splunk.commons.ast.nodes.CommandNode;
import com.splunk.commons.ast.nodes.commands.SortCommand;
import com.splunk.df.search.compute.ComputeEngineContext;
import com.splunk.df.search.compute.DistributedDataset;
import com.splunk.df.search.compute.Transformer;
import com.splunk.df.search.compute.TransformerRegistry;
import com.splunk.df.search.compute.transformers.BaseTransformerFactory;
import org.apache.log4j.Logger;

public class SortTransformer
implements Transformer {
    static final Logger logger = Logger.getLogger(SortTransformer.class);

    @Override
    public DistributedDataset transform(DistributedDataset dd, CommandNode qcmd, boolean streaming, ComputeEngineContext ctx) {
        boolean executeExternal;
        CommandNode source;
        int headImposedLimit = -1;
        if (ctx.hasContext("headImposedLimit")) {
            headImposedLimit = (Integer)ctx.get("headImposedLimit");
            logger.info((Object)String.format("head imposed limit set to: %d", headImposedLimit));
        }
        if ((source = qcmd.getSource()) == null) {
            logger.debug((Object)"source for sort command not present!");
            throw new RuntimeException("source not found for sort command");
        }
        boolean bl = executeExternal = !BaseTransformerFactory.getInstance().canExecuteExternal(qcmd, source);
        if (executeExternal) {
            dd = BaseTransformerFactory.getInstance().transform(dd, qcmd, ctx);
            dd = dd.cacheDisk();
        } else {
            Transformer t = ((TransformerRegistry)ctx.get("dfs.dataset.transformer.registry")).getTransformer(source);
            dd = t.transform(dd, source, false, ctx);
        }
        ctx.addContext("command.node", qcmd);
        return dd.sort((SortCommand)qcmd, headImposedLimit);
    }

    @Override
    public String name() {
        return "SortTransformer";
    }
}

