/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search.compute.transformers.aggregatevalues;

import com.splunk.df.search.compute.sdk.Pair;
import com.splunk.df.search.compute.transformers.aggregatevalues.AggregateValue;
import org.apache.log4j.Logger;

public class RangeAggregateValue
implements AggregateValue {
    static final Logger logger = Logger.getLogger(RangeAggregateValue.class);
    private Double min = 0.0;
    private Double max = 0.0;

    @Override
    public AggregateValue accumulate(Object item) {
        Pair range = (Pair)item;
        this.min = (Double)range.first();
        this.max = (Double)range.second();
        return this;
    }

    @Override
    public AggregateValue accumulate(AggregateValue aggregateValue) {
        assert (aggregateValue instanceof RangeAggregateValue);
        Pair item = (Pair)aggregateValue.getValue();
        if (null != item.first() && this.min > (Double)item.first()) {
            this.min = (Double)item.first();
        }
        if (null != item.second() && this.max < (Double)item.second()) {
            this.max = (Double)item.second();
        }
        return this;
    }

    @Override
    public Object getValue() {
        return new Pair<Double, Double>(this.min, this.max);
    }
}

