/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.security;

import com.splunk.df.security.DFSSecurityConstants;
import com.splunk.df.security.DFSSecurityUtils;
import com.splunk.df.security.NIOTls;
import com.splunk.df.util.DFSException;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.log4j.Logger;
import org.apache.spark.SparkFiles;
import org.json.JSONException;
import org.json.JSONObject;

public class SSLConfig
implements Serializable {
    static final Logger logger = Logger.getLogger(SSLConfig.class);
    private static SSLConfig sslConfigInstance;
    private static final String TLS_ENABLED_DEFAULT = "false";
    private static final String SPLUNK_HOME;
    private static HashSet<String> supportedTLSVersions;
    public static final String SERVER_CONF_NAME = "server";
    private static final String SSL_CONFIG_STANZA = "sslConfig";
    private static final String PRIVATE_KEY_FILE = "private_key_file";
    private static final String CERT_FILE = "cert_file";
    private static final String PRIVATE_KEY_PASSWORD = "private_key_password";
    private static final String CA_CERT_FILE = "ca_cert_file";
    private static final String[] SSL_CONFIG_STANZA_LIST;
    public static final String DFS_SECURITY_STANZA = "dfs_security";
    private static final String TLS_ENABLED = "tls_enabled";
    private static final String TLS_PROTOCOL = "tls_protocol";
    private static final String OVERRIDE_DEFAULT_CERTIFICATE = "override_default_certificate";
    private static final String USE_SPARK_SECURITY_CONFIGS = "use_spark_security_configs";
    private static final String USE_NODE_SPECIFIC_CERTIFICATES = "use_node_specific_certificates";
    private static final String VERIFY_SEARCH_PEER_TO_DFW_CLIENT_CERTIFICATE = "verify_search_peer_to_dfw_client_certificate";
    private static final String SEARCH_PEER_TO_DFW_COMMON_NAME_LIST = "search_peer_to_dfw_common_name_list";
    private static final String SEARCH_PEER_TO_DFW_ALT_NAME_LIST = "search_peer_to_dfw_alt_name_list";
    private static final String LEGACY_CA_CERTIFICATE_FOLDER = "legacy_ca_certificate_folder";
    private static final String DFS_KEYSTORE_PATH = "dfs_keystore_path";
    private static final String DFS_TRUSTSTORE_PATH = "dfs_truststore_path";
    private static final String DFS_KEYSTORE_PASSWORD = "dfs_keystore_password";
    private static final String DFS_KEY_PASSWORD = "dfs_key_password";
    private static final String DFS_TRUSTSTORE_PASSWORD = "dfs_truststore_password";
    private static final String DFC_KEYSTORE_PATH = "dfc_keystore_path";
    private static final String DFC_TRUSTSTORE_PATH = "dfc_truststore_path";
    private static final String DFC_KEYSTORE_PASSWORD = "dfc_keystore_password";
    private static final String DFC_KEY_PASSWORD = "dfc_key_password";
    private static final String DFC_TRUSTSTORE_PASSWORD = "dfc_truststore_password";
    private static final String DFW_KEYSTORE_PATH = "dfw_keystore_path";
    private static final String DFW_TRUSTSTORE_PATH = "dfw_truststore_path";
    private static final String DFW_KEYSTORE_PASSWORD = "dfw_keystore_password";
    private static final String DFW_KEY_PASSWORD = "dfw_key_password";
    private static final String DFW_TRUSTSTORE_PASSWORD = "dfw_truststore_password";
    private static final String[] DFS_SECURITY_STANZA_LIST;
    public static final String TO_DFW = "to_dfw";
    public static final String DEFAULT_DFW_KEYSTORE_PASSWORD = "default_dfw_keystore_password";
    private static final String[] SEND_TO_DFW_LIST;
    private String serverConf;
    private String toDFW;
    private HashMap<String, String> sslConfigsStanzaConfigs = new HashMap();
    private HashMap<String, String> dfsSecurityStanzaConfigs = new HashMap();

    private SSLConfig() {
        this.dfsSecurityStanzaConfigs.put(TLS_ENABLED, TLS_ENABLED_DEFAULT);
        JSONObject dfsSecurityJson = new JSONObject();
        dfsSecurityJson.put(TLS_ENABLED, (Object)TLS_ENABLED_DEFAULT);
        JSONObject dfsSecurityStanzaJson = new JSONObject();
        dfsSecurityStanzaJson.put(DFS_SECURITY_STANZA, (Object)dfsSecurityJson);
        JSONObject serverConfJson = new JSONObject();
        serverConfJson.put(SERVER_CONF_NAME, (Object)dfsSecurityStanzaJson);
        this.serverConf = serverConfJson.toString();
        this.toDFW = serverConfJson.toString();
    }

    private SSLConfig(String input) throws JSONException {
        JSONObject dfsSecurityStanzaJson;
        this.serverConf = input;
        JSONObject inputJson = new JSONObject(input);
        if (inputJson.has(SERVER_CONF_NAME)) {
            String config;
            int n;
            int n2;
            String[] stringArray;
            JSONObject serverConfJson = inputJson.getJSONObject(SERVER_CONF_NAME);
            if (serverConfJson.has(SSL_CONFIG_STANZA)) {
                JSONObject sslConfigStanzaJson = serverConfJson.getJSONObject(SSL_CONFIG_STANZA);
                stringArray = SSL_CONFIG_STANZA_LIST;
                n2 = stringArray.length;
                for (n = 0; n < n2; ++n) {
                    config = stringArray[n];
                    if (!sslConfigStanzaJson.has(config)) continue;
                    if (!sslConfigStanzaJson.getString(config).equals("")) {
                        this.sslConfigsStanzaConfigs.put(config, sslConfigStanzaJson.getString(config));
                        continue;
                    }
                    sslConfigStanzaJson.remove(config);
                }
            }
            if (serverConfJson.has(DFS_SECURITY_STANZA)) {
                dfsSecurityStanzaJson = serverConfJson.getJSONObject(DFS_SECURITY_STANZA);
                stringArray = DFS_SECURITY_STANZA_LIST;
                n2 = stringArray.length;
                for (n = 0; n < n2; ++n) {
                    config = stringArray[n];
                    if (!dfsSecurityStanzaJson.has(config)) continue;
                    if (!dfsSecurityStanzaJson.getString(config).equals("")) {
                        this.dfsSecurityStanzaConfigs.put(config, dfsSecurityStanzaJson.getString(config));
                        continue;
                    }
                    dfsSecurityStanzaJson.remove(config);
                }
                if (inputJson.has(TO_DFW) && inputJson.get(TO_DFW) != null && inputJson.get(TO_DFW).equals("true") && dfsSecurityStanzaJson.has(DEFAULT_DFW_KEYSTORE_PASSWORD)) {
                    this.dfsSecurityStanzaConfigs.put(DEFAULT_DFW_KEYSTORE_PASSWORD, dfsSecurityStanzaJson.getString(DEFAULT_DFW_KEYSTORE_PASSWORD));
                }
            }
        }
        JSONObject sendToDFW = new JSONObject();
        for (JSONObject config : SEND_TO_DFW_LIST) {
            if (!this.dfsSecurityStanzaConfigs.containsKey(config)) continue;
            sendToDFW.put((String)config, (Object)this.dfsSecurityStanzaConfigs.get(config));
        }
        dfsSecurityStanzaJson = new JSONObject();
        dfsSecurityStanzaJson.put(DFS_SECURITY_STANZA, (Object)sendToDFW);
        JSONObject serverConfJson = new JSONObject();
        serverConfJson.put(SERVER_CONF_NAME, (Object)dfsSecurityStanzaJson);
        this.toDFW = serverConfJson.toString();
    }

    public static synchronized SSLConfig getInstance() {
        if (sslConfigInstance == null) {
            sslConfigInstance = new SSLConfig();
        }
        return sslConfigInstance;
    }

    public static synchronized SSLConfig getInstance(String input) {
        if (sslConfigInstance == null) {
            sslConfigInstance = new SSLConfig(input);
        }
        return sslConfigInstance;
    }

    public String getServerConf() {
        return this.serverConf;
    }

    public String getPrivateKeyFile() {
        return this.sslConfigsStanzaConfigs.get(PRIVATE_KEY_FILE);
    }

    public String getCertFile() {
        return this.sslConfigsStanzaConfigs.get(CERT_FILE);
    }

    public String getPrivateKeyPassword() {
        return this.sslConfigsStanzaConfigs.get(PRIVATE_KEY_PASSWORD);
    }

    public String getCaCertFile() {
        return this.sslConfigsStanzaConfigs.get(CA_CERT_FILE);
    }

    public boolean isTlsEnabled() {
        String tlsEnable = this.dfsSecurityStanzaConfigs.get(TLS_ENABLED);
        return tlsEnable != null && tlsEnable.equals("true");
    }

    public String getTlsProtocol() throws DFSException {
        String tlsProtocol = this.dfsSecurityStanzaConfigs.get(TLS_PROTOCOL);
        if (tlsProtocol == null || tlsProtocol.equals("")) {
            return "TLSv1.2";
        }
        if (!supportedTLSVersions.contains(tlsProtocol.toLowerCase())) {
            throw new DFSException("TLS protocol " + tlsProtocol + " is not supported in DFS");
        }
        return tlsProtocol;
    }

    public boolean isOverrideDefaultCertificate() {
        String isOverwrite = this.dfsSecurityStanzaConfigs.get(OVERRIDE_DEFAULT_CERTIFICATE);
        return isOverwrite != null && isOverwrite.equals("true");
    }

    public boolean isUseSparkSecurityConfigs() {
        String useSparkSecurityConfigs = this.dfsSecurityStanzaConfigs.get(USE_SPARK_SECURITY_CONFIGS);
        return useSparkSecurityConfigs != null && useSparkSecurityConfigs.equals("true");
    }

    public boolean isUseNodeSpecificCertificates() {
        String useNodeSpecificCertificates = this.dfsSecurityStanzaConfigs.get(USE_NODE_SPECIFIC_CERTIFICATES);
        return useNodeSpecificCertificates != null && useNodeSpecificCertificates.equals("true");
    }

    public boolean isVerifySearchPeerToDFWClientCertificate() {
        String requireCertificate = this.dfsSecurityStanzaConfigs.get(VERIFY_SEARCH_PEER_TO_DFW_CLIENT_CERTIFICATE);
        return requireCertificate != null && requireCertificate.equals("true");
    }

    public String[] getSearchPeerToDFWCommonNameList() {
        String cNames = this.dfsSecurityStanzaConfigs.get(SEARCH_PEER_TO_DFW_COMMON_NAME_LIST);
        if (cNames == null || cNames.equals("")) {
            return null;
        }
        String[] names = cNames.split(",");
        for (int i = 0; i < names.length; ++i) {
            names[i] = names[i].trim().toLowerCase();
        }
        return names;
    }

    public HashSet<String> getSearchPeerToDFWAltNameList() {
        String altNames = this.dfsSecurityStanzaConfigs.get(SEARCH_PEER_TO_DFW_ALT_NAME_LIST);
        if (altNames == null || altNames.equals("")) {
            return null;
        }
        String[] names = altNames.split(",");
        HashSet<String> nameSet = new HashSet<String>();
        for (String name : names) {
            nameSet.add(name.trim().toLowerCase());
        }
        return nameSet;
    }

    public String getOldCaCertificateFolder() {
        if (this.dfsSecurityStanzaConfigs.containsKey(LEGACY_CA_CERTIFICATE_FOLDER)) {
            return this.dfsSecurityStanzaConfigs.get(LEGACY_CA_CERTIFICATE_FOLDER);
        }
        return DFSSecurityConstants.DEFAULT_LEGACY_CA_CERTIFICATE_FOLDER_PATH;
    }

    public String getDFSKeystorePath() {
        return this.dfsSecurityStanzaConfigs.get(DFS_KEYSTORE_PATH);
    }

    public String getDFSTruststorePath() {
        return this.dfsSecurityStanzaConfigs.get(DFS_TRUSTSTORE_PATH);
    }

    public String getDFSKeystorePassword() {
        return this.dfsSecurityStanzaConfigs.get(DFS_KEYSTORE_PASSWORD);
    }

    public String getDFSKeyPassword() {
        return this.dfsSecurityStanzaConfigs.get(DFS_KEY_PASSWORD);
    }

    public String getDFSTruststorePassword() {
        return this.dfsSecurityStanzaConfigs.get(DFS_TRUSTSTORE_PASSWORD);
    }

    public String getDFCKeystorePath() {
        String ksPath = DFSSecurityConstants.DEFAULT_KEYSTORE_PATH;
        if (this.isUseNodeSpecificCertificates()) {
            ksPath = this.dfsSecurityStanzaConfigs.get(DFC_KEYSTORE_PATH);
            if (ksPath == null) {
                logger.error((Object)"DFC keystore needs to be configured properly");
                throw new DFSException(logger, "Invalid DFC keystore path");
            }
        } else if (this.isUseSparkSecurityConfigs()) {
            ksPath = NIOTls.getConf("spark.ssl.keyStore");
            if (ksPath == null) {
                logger.error((Object)"DFC keystore needs to be configured properly in spark");
                throw new DFSException(logger, "Invalid DFC keystore path");
            }
        } else if (this.isOverrideDefaultCertificate() && (ksPath = this.getDFSKeystorePath()) == null) {
            logger.error((Object)"DFS keystore needs to be configured properly");
            throw new DFSException(logger, "Invalid DFS keystore path");
        }
        logger.info((Object)("DFC keystore: " + ksPath));
        return ksPath;
    }

    public String getDFCTruststorePath() {
        String tsPath = DFSSecurityConstants.DEFAULT_TRUSTSTORE_PATH;
        if (this.isUseNodeSpecificCertificates()) {
            tsPath = this.dfsSecurityStanzaConfigs.get(DFC_TRUSTSTORE_PATH);
            if (tsPath == null) {
                logger.error((Object)"DFC truststore needs to be configured properly");
                throw new DFSException(logger, "Invalid DFC truststore path");
            }
        } else if (this.isUseSparkSecurityConfigs()) {
            tsPath = NIOTls.getConf("spark.ssl.trustStore");
            if (tsPath == null) {
                logger.error((Object)"DFC truststore needs to be configured properly in spark");
                throw new DFSException(logger, "Invalid DFC truststore path");
            }
        } else if (this.isOverrideDefaultCertificate() && (tsPath = this.getDFSTruststorePath()) == null) {
            logger.error((Object)"DFS truststore needs to be configured properly");
            throw new DFSException(logger, "Invalid DFS truststore path");
        }
        logger.info((Object)("DFC truststore: " + tsPath));
        return tsPath;
    }

    public String getDFCKeystorePassword() throws IOException {
        if (this.isUseNodeSpecificCertificates()) {
            String ksPasswd = this.dfsSecurityStanzaConfigs.get(DFC_KEYSTORE_PASSWORD);
            if (ksPasswd == null) {
                logger.error((Object)"DFC keystore password needs to be configured properly");
                throw new DFSException(logger, "Invalid DFC keystore password");
            }
            return ksPasswd;
        }
        if (this.isUseSparkSecurityConfigs()) {
            String ksPasswd = NIOTls.getConf("spark.ssl.keyStorePassword");
            if (ksPasswd == null) {
                logger.error((Object)"DFC keystore password needs to be configured properly in spark");
                throw new DFSException(logger, "Invalid DFC keystore password");
            }
            return ksPasswd;
        }
        if (this.isOverrideDefaultCertificate()) {
            String ksPasswd = this.getDFSKeystorePassword();
            if (ksPasswd == null) {
                logger.error((Object)"DFS keystore password needs to be configured properly");
                throw new DFSException(logger, "Invalid DFS keystore password");
            }
            return ksPasswd;
        }
        return DFSSecurityUtils.generateKeyStorePasswd();
    }

    public String getDFCKeyPassword() throws IOException {
        if (this.isUseNodeSpecificCertificates()) {
            String kPasswd = this.dfsSecurityStanzaConfigs.get(DFC_KEY_PASSWORD);
            if (kPasswd == null) {
                logger.error((Object)"DFC key password needs to be configured properly");
                throw new DFSException(logger, "Invalid DFC key password");
            }
            return kPasswd;
        }
        if (this.isUseSparkSecurityConfigs()) {
            String kPasswd = NIOTls.getConf("spark.ssl.keyPassword");
            if (kPasswd == null) {
                logger.error((Object)"DFC key password needs to be configured properly in spark");
                throw new DFSException(logger, "Invalid DFC key password");
            }
            return kPasswd;
        }
        if (this.isOverrideDefaultCertificate()) {
            String kPasswd = this.getDFSKeyPassword();
            if (kPasswd == null) {
                logger.error((Object)"DFS key password needs to be configured properly");
                throw new DFSException(logger, "Invalid DFS key password");
            }
            return kPasswd;
        }
        return DFSSecurityUtils.generateKeyStorePasswd();
    }

    public String getDFCTruststorePassword() throws IOException {
        if (this.isUseNodeSpecificCertificates()) {
            String tsPasswd = this.dfsSecurityStanzaConfigs.get(DFC_TRUSTSTORE_PASSWORD);
            if (tsPasswd == null) {
                logger.error((Object)"DFC truststore password needs to be configured properly");
                throw new DFSException(logger, "Invalid DFC truststore password");
            }
            return tsPasswd;
        }
        if (this.isUseSparkSecurityConfigs()) {
            String tsPasswd = NIOTls.getConf("spark.ssl.trustStorePassword");
            if (tsPasswd == null) {
                logger.error((Object)"DFC truststore password needs to be configured properly in spark");
                throw new DFSException(logger, "Invalid DFC truststore password");
            }
            return tsPasswd;
        }
        if (this.isOverrideDefaultCertificate()) {
            String tsPasswd = this.getDFSTruststorePassword();
            if (tsPasswd == null) {
                logger.error((Object)"DFS truststore password needs to be configured properly");
                throw new DFSException(logger, "Invalid DFS truststore password");
            }
            return tsPasswd;
        }
        return DFSSecurityUtils.generateKeyStorePasswd();
    }

    public String getDFWKeystorePath() {
        String ksPath = SparkFiles.get((String)"dfsks.jks");
        if (this.isUseNodeSpecificCertificates()) {
            ksPath = this.dfsSecurityStanzaConfigs.get(DFW_KEYSTORE_PATH);
            if (ksPath == null) {
                logger.error((Object)"DFW keystore needs to be configured properly");
                throw new DFSException(logger, "Invalid DFW keystore path");
            }
        } else if (this.isUseSparkSecurityConfigs()) {
            ksPath = NIOTls.getConf("spark.ssl.keyStore");
            if (ksPath == null) {
                logger.error((Object)"DFW keystore needs to be configured properly in spark");
                throw new DFSException(logger, "Invalid DFW keystore path");
            }
        } else if (this.isOverrideDefaultCertificate()) {
            File file = new File(this.getDFSKeystorePath());
            ksPath = SparkFiles.get((String)file.getName());
        }
        logger.info((Object)("DFW keystore: " + ksPath));
        return ksPath;
    }

    public String getDFWTruststorePath() {
        String tsPath = SparkFiles.get((String)"dfsts.jks");
        if (this.isUseNodeSpecificCertificates()) {
            tsPath = this.dfsSecurityStanzaConfigs.get(DFW_TRUSTSTORE_PATH);
            if (tsPath == null) {
                logger.error((Object)"DFW truststore needs to be configured properly");
                throw new DFSException(logger, "Invalid DFW truststore path");
            }
        } else if (this.isUseSparkSecurityConfigs()) {
            tsPath = NIOTls.getConf("spark.ssl.trustStore");
            if (tsPath == null) {
                logger.error((Object)"DFS truststore needs to be configured properly in spark");
                throw new DFSException(logger, "Invalid DFW truststore path");
            }
        } else if (this.isOverrideDefaultCertificate()) {
            File file = new File(this.getDFSTruststorePath());
            tsPath = SparkFiles.get((String)file.getName());
        }
        logger.info((Object)("DFW truststore: " + tsPath));
        return tsPath;
    }

    public String getDFWKeystorePassword() {
        if (this.isUseNodeSpecificCertificates()) {
            String ksPasswd = this.dfsSecurityStanzaConfigs.get(DFW_KEYSTORE_PASSWORD);
            if (ksPasswd == null) {
                logger.error((Object)"DFW keystore password needs to be configured properly");
                throw new DFSException(logger, "Invalid DFW keystore password");
            }
            return ksPasswd;
        }
        if (this.isUseSparkSecurityConfigs()) {
            String ksPasswd = NIOTls.getConf("spark.ssl.keyStorePassword");
            if (ksPasswd == null) {
                logger.error((Object)"DFW keystore password needs to be configured properly in spark");
                throw new DFSException(logger, "Invalid DFW keystore password");
            }
            return ksPasswd;
        }
        if (this.isOverrideDefaultCertificate()) {
            String ksPasswd = this.getDFSKeystorePassword();
            if (ksPasswd == null) {
                logger.error((Object)"DFS keystore password needs to be configured properly");
                throw new DFSException(logger, "Invalid DFS keystore password");
            }
            return ksPasswd;
        }
        return this.getDefaultDfwKeystorePassword();
    }

    public String getDFWKeyPassword() {
        if (this.isUseNodeSpecificCertificates()) {
            String kPasswd = this.dfsSecurityStanzaConfigs.get(DFW_KEY_PASSWORD);
            if (kPasswd == null) {
                logger.error((Object)"DFW key password needs to be configured properly");
                throw new DFSException(logger, "Invalid DFW key password");
            }
            return kPasswd;
        }
        if (this.isUseSparkSecurityConfigs()) {
            String kPasswd = NIOTls.getConf("spark.ssl.keyPassword");
            if (kPasswd == null) {
                logger.error((Object)"DFW key password needs to be configured properly in spark");
                throw new DFSException(logger, "Invalid DFW key password");
            }
            return kPasswd;
        }
        if (this.isOverrideDefaultCertificate()) {
            String kPasswd = this.getDFSKeyPassword();
            if (kPasswd == null) {
                logger.error((Object)"DFS key password needs to be configured properly");
                throw new DFSException(logger, "Invalid DFS key password");
            }
            return kPasswd;
        }
        return this.getDefaultDfwKeystorePassword();
    }

    public String getDFWTruststorePassword() {
        if (this.isUseNodeSpecificCertificates()) {
            String tsPasswd = this.dfsSecurityStanzaConfigs.get(DFW_TRUSTSTORE_PASSWORD);
            if (tsPasswd == null) {
                logger.error((Object)"DFW truststore password needs to be configured properly");
                throw new DFSException(logger, "Invalid DFW truststore password");
            }
            return tsPasswd;
        }
        if (this.isUseSparkSecurityConfigs()) {
            String tsPasswd = NIOTls.getConf("spark.ssl.trustStorePassword");
            if (tsPasswd == null) {
                logger.error((Object)"DFW truststore password needs to be configured properly in spark");
                throw new DFSException(logger, "Invalid DFW Truststore password");
            }
            return tsPasswd;
        }
        if (this.isOverrideDefaultCertificate()) {
            String tsPasswd = this.getDFSTruststorePassword();
            if (tsPasswd == null) {
                logger.error((Object)"DFS truststore password needs to be configured properly");
                throw new DFSException(logger, "Invalid DFS truststore password");
            }
            return tsPasswd;
        }
        return this.getDefaultDfwKeystorePassword();
    }

    public String getToDFW() {
        return this.toDFW;
    }

    private String getDefaultDfwKeystorePassword() {
        return this.dfsSecurityStanzaConfigs.get(DEFAULT_DFW_KEYSTORE_PASSWORD);
    }

    public String toString() {
        return this.serverConf;
    }

    static {
        SPLUNK_HOME = System.getenv("SPLUNK_HOME");
        supportedTLSVersions = new HashSet<String>(Arrays.asList("tlsv1.2"));
        SSL_CONFIG_STANZA_LIST = new String[]{PRIVATE_KEY_FILE, CERT_FILE, PRIVATE_KEY_PASSWORD, CA_CERT_FILE};
        DFS_SECURITY_STANZA_LIST = new String[]{TLS_ENABLED, TLS_PROTOCOL, OVERRIDE_DEFAULT_CERTIFICATE, USE_SPARK_SECURITY_CONFIGS, USE_NODE_SPECIFIC_CERTIFICATES, VERIFY_SEARCH_PEER_TO_DFW_CLIENT_CERTIFICATE, SEARCH_PEER_TO_DFW_COMMON_NAME_LIST, SEARCH_PEER_TO_DFW_ALT_NAME_LIST, LEGACY_CA_CERTIFICATE_FOLDER, DFS_KEYSTORE_PATH, DFS_TRUSTSTORE_PATH, DFS_KEYSTORE_PASSWORD, DFS_KEY_PASSWORD, DFS_TRUSTSTORE_PASSWORD, DFC_KEYSTORE_PATH, DFC_TRUSTSTORE_PATH, DFC_KEYSTORE_PASSWORD, DFC_KEY_PASSWORD, DFC_TRUSTSTORE_PASSWORD, DFW_KEYSTORE_PATH, DFW_TRUSTSTORE_PATH, DFW_KEYSTORE_PASSWORD, DFW_KEY_PASSWORD, DFW_TRUSTSTORE_PASSWORD};
        SEND_TO_DFW_LIST = new String[]{TLS_ENABLED, DEFAULT_DFW_KEYSTORE_PASSWORD, TLS_PROTOCOL, OVERRIDE_DEFAULT_CERTIFICATE, USE_SPARK_SECURITY_CONFIGS, USE_NODE_SPECIFIC_CERTIFICATES, VERIFY_SEARCH_PEER_TO_DFW_CLIENT_CERTIFICATE, SEARCH_PEER_TO_DFW_COMMON_NAME_LIST, SEARCH_PEER_TO_DFW_ALT_NAME_LIST, DFS_KEYSTORE_PATH, DFS_TRUSTSTORE_PATH, DFS_KEYSTORE_PASSWORD, DFS_KEY_PASSWORD, DFS_TRUSTSTORE_PASSWORD, DFW_KEYSTORE_PATH, DFW_TRUSTSTORE_PATH, DFW_KEYSTORE_PASSWORD, DFW_KEY_PASSWORD, DFW_TRUSTSTORE_PASSWORD};
    }
}

