/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;

public class WildcardList {
    List<WildcardListEntry> patterns = Collections.emptyList();
    boolean matchesAll = false;
    List<String> wildcardList = Collections.emptyList();

    public List<String> getWildcardList() {
        return this.wildcardList;
    }

    public WildcardList(List<String> wildcardList) {
        if (wildcardList == null) {
            return;
        }
        this.wildcardList = new ArrayList<String>();
        this.wildcardList.addAll(wildcardList);
        this.patterns = new ArrayList<WildcardListEntry>(wildcardList.size());
        for (String s : wildcardList) {
            if ((s = s.trim()).isEmpty()) continue;
            if (s.equals("*")) {
                this.matchesAll = true;
                this.patterns.clear();
                break;
            }
            this.patterns.add(new WildcardListEntry(s));
        }
    }

    public boolean matches(String candidate) {
        for (WildcardListEntry wle : this.patterns) {
            if (!wle.matches(candidate)) continue;
            return true;
        }
        return this.matchesAll;
    }

    public boolean isPrefixMatch(String candidate) {
        for (WildcardListEntry wle : this.patterns) {
            if (!wle.isPrefixMatch(candidate)) continue;
            return true;
        }
        return this.matchesAll;
    }

    public boolean matchesAll() {
        return this.matchesAll;
    }

    public void addEntry(String s) {
        if (s != null && !s.isEmpty()) {
            if (s.equals("*")) {
                this.matchesAll = true;
                this.patterns.clear();
            } else {
                this.patterns.add(new WildcardListEntry(s));
            }
            this.wildcardList.add(s);
        }
    }

    public boolean contains(String s) {
        return this.wildcardList.contains(s);
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            System.err.println("usage: WildcardList <comma delimited wildcard list> <test string>");
            System.exit(1);
        }
        WildcardList wl = new WildcardList(Arrays.asList(args[0].split(",")));
        boolean matches = wl.matches(args[1]);
        System.out.printf("Candidate: %s\nmatches: %b, prefixMatch: %b\n", args[1], matches, wl.isPrefixMatch(args[1]));
    }

    class WildcardListEntry {
        String str = null;
        Pattern p = null;

        public WildcardListEntry(String pattern) {
            this.str = pattern.trim();
            if (this.str.contains("*")) {
                boolean startsWithStar = pattern.startsWith("*");
                boolean endsWithStar = pattern.endsWith("*");
                String[] parts = pattern.split("\\*");
                StringBuilder sb = new StringBuilder();
                for (String p : parts) {
                    if (p.isEmpty()) continue;
                    if (sb.length() != 0 || startsWithStar) {
                        sb.append(".*");
                    }
                    sb.append(Pattern.quote(p));
                }
                if (endsWithStar) {
                    sb.append(".*");
                }
                pattern = sb.toString();
                this.p = Pattern.compile(pattern);
            }
        }

        public boolean matches(CharSequence candidate) {
            if (this.p == null) {
                return this.str.equals(candidate);
            }
            return this.p.matcher(candidate).matches();
        }

        public boolean isPrefixMatch(CharSequence candidate) {
            return this.str.startsWith("*") || this.str.startsWith(candidate.toString()) || this.matches(candidate);
        }
    }
}

