/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mr.input;

import com.splunk.mr.SplunkMR;
import com.splunk.mr.input.BaseSplunkRecordReader;
import com.splunk.mr.input.FileStatusExt;
import com.splunk.mr.input.ObjectAcceptor;
import com.splunk.mr.input.SplitGenerator;
import com.splunk.mr.input.VirtualIndex;
import com.splunk.mr.input.VixInputSplit;
import com.splunk.util.WildcardList;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.mapreduce.JobContext;

public abstract class BaseSplitGenerator
implements SplitGenerator {
    protected CompressionCodecFactory _codecFactory = null;
    protected VirtualIndex _vix;
    protected JobContext _job;
    protected WildcardList _requiredFields = SplunkMR.ACCEPT_ALL_WCL;
    protected Boolean _useFieldFilter = null;

    public void init(FileStatusExt fstat, JobContext job, VirtualIndex vix, ObjectAcceptor<VixInputSplit> acceptor) throws IOException {
        this._job = job;
        this._vix = vix;
        Configuration conf = job.getConfiguration();
        if (this._codecFactory == null) {
            this._codecFactory = new CompressionCodecFactory(conf);
        }
        this._requiredFields = BaseSplunkRecordReader.getRequiredFields(conf, this._vix, this._useFieldFilter, fstat.getInputId(), SplunkMR.ACCEPT_ALL_WCL);
    }

    public String getConfVar(String inputId, String name, String defaultVal) {
        String result = null;
        if (this._vix != null) {
            result = this._vix.getSplitterConf(inputId, this.getName(), name, defaultVal);
        }
        return result;
    }

    public String getRequiredConfVar(String inputId, String name) throws IllegalArgumentException {
        String value = this.getConfVar(inputId, name, null);
        if (StringUtils.isEmpty((String)value)) {
            throw new IllegalArgumentException("Property " + name + " is required and cannot be empty.");
        }
        return value;
    }

    public abstract String getName();
}

