/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mr.input;

import com.splunk.mr.SplunkMR;
import com.splunk.mr.input.VirtualIndex;
import com.splunk.mr.input.VixInputSplit;
import com.splunk.util.StrUtil;
import com.splunk.util.WildcardList;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.log4j.Logger;

public abstract class BaseSplunkRecordReader
extends RecordReader<Text, Text> {
    private static Logger gLogger = Logger.getLogger(BaseSplunkRecordReader.class);
    protected Configuration _conf = null;
    protected VirtualIndex _index = null;
    protected String _inputId = null;
    protected boolean _inited = false;
    protected WildcardList _requiredFields = SplunkMR.ACCEPT_ALL_WCL;
    protected Boolean _useFieldFilter = null;

    public static WildcardList getRequiredFields(Configuration conf, VirtualIndex vix, Boolean useFieldFilter, String inputId, WildcardList defaultRequiredFields) {
        if (useFieldFilter == null && (useFieldFilter = Boolean.valueOf(StrUtil.parseBoolean(conf.get("splunk.search.column.filter"), true))).booleanValue()) {
            if (vix != null) {
                String vixRF = vix.getRequiredFields(inputId);
                String reqFields = conf.get(SplunkMR.CONF_REQUIRED_FIELDS, "*");
                if (!vixRF.isEmpty() && !"*".equals(reqFields)) {
                    reqFields = reqFields + "," + vixRF;
                }
                gLogger.debug((Object)("requiredFields=" + reqFields));
                return new WildcardList(Arrays.asList(reqFields.split(",")));
            }
            gLogger.warn((Object)"Does not have a configured index for vixSplit. Not expected to happen in production.");
        }
        return defaultRequiredFields;
    }

    public final void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        Pattern regex;
        if (this._inited) {
            return;
        }
        VixInputSplit vixSplit = (VixInputSplit)split;
        this._conf = context.getConfiguration();
        this._index = VirtualIndex.parseIndex(this._conf, vixSplit.getIndex());
        this._inputId = vixSplit.getInputId();
        this._requiredFields = BaseSplunkRecordReader.getRequiredFields(this._conf, this._index, this._useFieldFilter, this._inputId, SplunkMR.ACCEPT_ALL_WCL);
        String confRegex = this.getConfVar("regex", null);
        Pattern pattern = regex = confRegex == null ? this.getFilePattern() : Pattern.compile(confRegex);
        if (regex == null) {
            throw new IOException("Regex cannot be null for record reader class=" + ((Object)((Object)this)).getClass().getName() + ", name=" + this.getName());
        }
        String p = vixSplit.getPath().toUri().getPath();
        if (!regex.matcher(p).find()) {
            throw new IOException(String.format("File path does not match regex to use this record reader, class=%s, name=%s, path=%s, regex=%s", ((Object)((Object)this)).getClass().getName(), this.getName(), vixSplit.getPath().toString(), regex.pattern()) + ".");
        }
        this.vixInitialize(vixSplit, context);
        String dataType = this.getOutputDataFormat().toLowerCase();
        if (dataType.equals("json") || dataType.equals("xml")) {
            vixSplit.setHeaderField("props.SHOULD_LINEMERGE", "0");
            vixSplit.setHeaderField("props.KV_MODE", dataType);
        }
        vixSplit.setHeaderField("props.INDEXED_EXTRACTIONS", "");
        this._inited = true;
    }

    public abstract String getName();

    public abstract Pattern getFilePattern();

    public abstract void vixInitialize(VixInputSplit var1, TaskAttemptContext var2) throws IOException, InterruptedException;

    public String getOutputDataFormat() {
        return "";
    }

    public boolean appendNewLine() {
        return true;
    }

    public boolean needsNewHeader(Map<String, Object> header) {
        return false;
    }

    public String getConfVar(String name, String defaultVal) {
        String rrName = this.getName();
        String result = null;
        if (this._index != null) {
            result = this._index.getRecordReaderConf(this._inputId, rrName, name);
        }
        if (result == null) {
            result = this._conf.get("splunk.search.recordreader." + rrName + "." + name, defaultVal);
        }
        return result;
    }

    public void serializeCurrentValueTo(OutputStream out) throws IOException, InterruptedException {
        Text cv = (Text)this.getCurrentValue();
        if (cv == null) {
            return;
        }
        out.write(cv.getBytes(), 0, cv.getLength());
    }

    public void close() throws IOException {
    }

    public float getProgress() throws IOException, InterruptedException {
        return 0.0f;
    }
}

