/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mr.input;

import com.splunk.datasource.hive.HiveMetaStoreUtils;
import com.splunk.datasource.hive.HivePPDUtil;
import com.splunk.datasource.hive.TableSchema;
import com.splunk.filter.schema.HiveSchemaFilter;
import com.splunk.mr.SplunkMR;
import com.splunk.mr.input.FileSplitGenerator;
import com.splunk.mr.input.HiveInputFormat;
import com.splunk.mr.input.ObjectAcceptor;
import com.splunk.mr.input.VixInputSplit;
import com.splunk.util.StrUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.io.RCFileInputFormat;
import org.apache.hadoop.hive.ql.io.orc.OrcInputFormat;
import org.apache.hadoop.hive.ql.io.orc.OrcSerde;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.MD5Hash;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.log4j.Logger;
import org.codehaus.jackson.map.ObjectMapper;

public class HiveSplitGenerator
extends FileSplitGenerator {
    public static final String HIVE_TABLE_SCHEMA = "splunk.hive.tableschema";
    private static Logger gLogger = Logger.getLogger(HiveSplitGenerator.class);
    private ObjectMapper mapper = new ObjectMapper();

    public HiveSplitGenerator() {
    }

    public HiveSplitGenerator(boolean dmaSplit) {
        this.dmaSplit = dmaSplit;
    }

    @Override
    public String getName() {
        return "hive";
    }

    @Override
    protected boolean sendSplitToAcceptor(ObjectAcceptor<VixInputSplit> acceptor, VixInputSplit split) throws IOException {
        Configuration conf = this._job.getConfiguration();
        String metaStoreUris = conf.get(HiveConf.ConfVars.METASTOREURIS.toString());
        if (gLogger.isDebugEnabled()) {
            gLogger.debug((Object)("Setting split with Id:: " + split.getSplitId() + " dma flag to " + this.dmaSplit));
        }
        split.setDmaSplit(this.dmaSplit);
        String dbName = this.getConfVar(split.getInputId(), "dbname", "default");
        String tableName = this.getRequiredConfVar(split.getInputId(), "tablename");
        String hash = MD5Hash.digest((String)(dbName + "." + tableName)).toString();
        String schema = conf.get(hash);
        TableSchema ts = null;
        if (schema == null) {
            ts = this.getTableSchema(split, metaStoreUris, dbName, tableName);
            schema = this.mapper.writeValueAsString((Object)ts);
            conf.set(hash, schema);
            gLogger.debug((Object)("cache MISS. path=" + split.getPath()));
        } else {
            gLogger.debug((Object)("cache HIT. path=" + split.getPath()));
        }
        split.putExtra(HIVE_TABLE_SCHEMA, schema);
        split.setInputFormatClass(HiveInputFormat.class);
        return acceptor.accept(split);
    }

    private TableSchema getTableSchema(VixInputSplit split, String metaStoreUris, String dbName, String tableName) {
        TableSchema ts = new TableSchema();
        Configuration conf = this._job.getConfiguration();
        gLogger.debug((Object)("Split with Id::" + split.getSplitId() + ", " + StrUtil.parseBoolean(conf.get(SplunkMR.CONF_DATAMODEL_READ), false)));
        if (!(metaStoreUris == null || split.isDmaSplit() && StrUtil.parseBoolean(conf.get(SplunkMR.CONF_DATAMODEL_READ), false))) {
            StorageDescriptor sd = HiveMetaStoreUtils.getTable(conf, dbName, tableName).getSd();
            HiveSchemaFilter filter = new HiveSchemaFilter();
            filter.filter(sd.getCols(), this._requiredFields);
            ts.readColIds = filter.readColumnIds();
            ts.tableColNames = filter.tableColumnNames();
            ts.tableColTypes = filter.tableColumnTypes();
            ts.inputFormat = sd.getInputFormat();
            try {
                Class<Object> clazz = Thread.currentThread().getContextClassLoader().loadClass(ts.inputFormat);
                if (clazz.isAssignableFrom(org.apache.hadoop.mapred.SequenceFileInputFormat.class) || clazz.isAssignableFrom(SequenceFileInputFormat.class)) {
                    ts.fileFormat = FileFormat.sequencefile;
                } else if (clazz.isAssignableFrom(TextInputFormat.class) || clazz.isAssignableFrom(org.apache.hadoop.mapreduce.lib.input.TextInputFormat.class)) {
                    ts.fileFormat = FileFormat.textfile;
                } else if (clazz.isAssignableFrom(RCFileInputFormat.class)) {
                    ts.fileFormat = FileFormat.rcfile;
                } else if (clazz.isAssignableFrom(OrcInputFormat.class)) {
                    ts.fileFormat = FileFormat.orc;
                }
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("inputformat class is not found, className=" + ts.inputFormat + ":" + e.getMessage(), e);
            }
            SerDeInfo si = sd.getSerdeInfo();
            ts.serdeInfo.serializationLib = si.getSerializationLib();
            ts.serdeInfo.parameters.putAll((Map<?, ?>)si.getParameters());
        } else {
            ArrayList types;
            ts.tableColNames = this.getRequiredConfVar(split.getInputId(), "columnnames");
            ts.tableColTypes = StringUtils.remove((String)this.getRequiredConfVar(split.getInputId(), "columntypes").toLowerCase(), (char)' ');
            if (split.isDmaSplit()) {
                this.modifyRequiredFieldsForDMASplit();
            }
            HiveSchemaFilter filter = new HiveSchemaFilter();
            String[] names = ts.tableColNames.split(",");
            if (names.length != (types = TypeInfoUtils.getTypeInfosFromTypeString((String)ts.tableColTypes)).size()) {
                throw new IllegalArgumentException("The number of column names is different from the number of column types.");
            }
            ArrayList<FieldSchema> schema = new ArrayList<FieldSchema>(names.length);
            for (int i = 0; i < names.length; ++i) {
                schema.add(new FieldSchema(names[i], ((TypeInfo)types.get(i)).getTypeName(), null));
            }
            filter.filter(schema, this._requiredFields, split.isDmaSplit());
            ts.readColIds = filter.readColumnIds();
            this.setOptionalProperty(split, ts, "line.delim", "rowformat.lines.terminated");
            this.setOptionalProperty(split, ts, "field.delim", "rowformat.fields.terminated");
            this.setOptionalProperty(split, ts, "escape.delim", "rowformat.escapted");
            this.setOptionalProperty(split, ts, "colelction.delim", "rowformat.collectionitems.terminated");
            this.setOptionalProperty(split, ts, "mapkey.delim", "rowformat.mapkeys.terminated");
            String serDeProperties = this.getConfVar(split.getInputId(), "serde.properties", null);
            if (!StringUtils.isEmpty((String)serDeProperties)) {
                String[] props;
                for (String p : props = serDeProperties.split(",")) {
                    String[] kv = p.split("=");
                    ts.serdeInfo.parameters.put(kv[0].trim(), kv[1].trim());
                }
            }
            ts.fileFormat = FileFormat.value(this.getConfVar(split.getInputId(), "fileformat", null));
            ts.serdeInfo.serializationLib = this.getConfVar(split.getInputId(), "serde", null);
            String defaultSerDeClass = LazySimpleSerDe.class.getName();
            switch (ts.fileFormat) {
                case textfile: {
                    ts.inputFormat = TextInputFormat.class.getName();
                    break;
                }
                case sequencefile: {
                    ts.inputFormat = org.apache.hadoop.mapred.SequenceFileInputFormat.class.getName();
                    break;
                }
                case rcfile: {
                    ts.inputFormat = RCFileInputFormat.class.getName();
                    if (!StringUtils.isEmpty((String)ts.serdeInfo.serializationLib)) break;
                    throw new RuntimeException("Please specify which serde class is used to generate the given rcfile.The default rcfile serde before hive 0.12 is org.apache.hadoop.hive.serde2.columnar.ColumnarSerDe.The default recfile serde starting from hive 0.12 is org.apache.hadoop.hive.serde2.columnar.LazyBinaryColumnarSerDe.You can get the serde classname from hive property " + HiveConf.ConfVars.HIVEDEFAULTRCFILESERDE.varname + ".");
                }
                case orc: {
                    defaultSerDeClass = OrcSerde.class.getName();
                    ts.inputFormat = OrcInputFormat.class.getName();
                    break;
                }
                case inputformat: {
                    ts.inputFormat = this.getRequiredConfVar(split.getInputId(), "fileformat.inputformat");
                    break;
                }
                default: {
                    defaultSerDeClass = null;
                }
            }
            if (StringUtils.isEmpty((String)ts.serdeInfo.serializationLib)) {
                if (defaultSerDeClass != null) {
                    ts.serdeInfo.serializationLib = defaultSerDeClass;
                } else {
                    throw new RuntimeException("Please specify hive splitter serde property: vix.<splitter prop prefix>.hive.serde");
                }
            }
        }
        ts.serdeInfo.parameters.setProperty("columns", ts.tableColNames);
        ts.serdeInfo.parameters.setProperty("columns.types", ts.tableColTypes);
        boolean ppd = StrUtil.parseBoolean(this.getConfVar(split.getInputId(), "ppd", "1"), true);
        if (ts.fileFormat == FileFormat.orc && this._vix.getSearchEvaluator() != null && ppd) {
            HivePPDUtil.HivePPDInfo info = HivePPDUtil.getHivePPDInfo(this._vix.getSearchEvaluator().getRoot(), ts.tableColNames.split(","), TypeInfoUtils.getTypeInfosFromTypeString((String)ts.tableColTypes));
            if (info.exprNodeDesc != null) {
                gLogger.debug((Object)("info.exprNodeDesc=" + info.exprNodeDesc));
                ts.filterExpr = Utilities.serializeExpression((ExprNodeGenericFuncDesc)info.exprNodeDesc);
            }
        }
        gLogger.debug((Object)("tableColNames=" + ts.tableColNames));
        gLogger.debug((Object)("tableColTypes=" + ts.tableColTypes));
        gLogger.debug((Object)("readColIds=" + ts.readColIds));
        gLogger.debug((Object)("filterExpr=" + ts.filterExpr));
        return ts;
    }

    protected void setOptionalProperty(VixInputSplit split, TableSchema ts, String hivePropertyName, String splunkPropertyName) {
        String value = this.getConfVar(split.getInputId(), splunkPropertyName, null);
        if (value != null) {
            ts.serdeInfo.parameters.setProperty(hivePropertyName, StrUtil.unescape(value));
        }
    }

    public static enum FileFormat {
        textfile,
        sequencefile,
        rcfile,
        orc,
        inputformat;


        public static FileFormat value(String s) {
            try {
                if (StringUtils.isEmpty((String)s)) {
                    return textfile;
                }
                return FileFormat.valueOf(s);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Invalid file format, format=" + s + ", valid formats are:" + Arrays.asList(FileFormat.values()));
            }
        }
    }
}

