/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common.type;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;

public class HiveDecimal
implements Comparable<HiveDecimal> {
    public static final HiveDecimal ZERO = new HiveDecimal(BigDecimal.ZERO);
    public static final int MAX_PRECISION = 38;
    public static final HiveDecimal ONE = new HiveDecimal(BigDecimal.ONE);
    public static final int ROUND_FLOOR = 3;
    public static final int ROUND_CEILING = 2;
    public static final int ROUND_HALF_UP = 4;
    private BigDecimal bd = BigDecimal.ZERO;

    public HiveDecimal(BigDecimal b) {
        this(b, false);
    }

    public HiveDecimal(BigDecimal b, boolean allowRounding) {
        this.bd = this.normalize(b, 38, allowRounding);
        if (this.bd == null) {
            throw new NumberFormatException("Assignment would result in truncation");
        }
    }

    public HiveDecimal(BigInteger unscaled, int scale) {
        this.bd = this.normalize(new BigDecimal(unscaled, scale), 38, false);
        if (this.bd == null) {
            throw new NumberFormatException("Assignment would result in truncation");
        }
    }

    public HiveDecimal(String dec) {
        this.bd = this.normalize(new BigDecimal(dec), 38, false);
        if (this.bd == null) {
            throw new NumberFormatException("Assignment would result in truncation");
        }
    }

    public HiveDecimal(BigInteger bi) {
        this.bd = this.normalize(new BigDecimal(bi), 38, false);
        if (this.bd == null) {
            throw new NumberFormatException("Assignment would result in truncation");
        }
    }

    public HiveDecimal(int i) {
        this.bd = new BigDecimal(i);
    }

    public HiveDecimal(long l) {
        this.bd = new BigDecimal(l);
    }

    public String toString() {
        return this.bd.toPlainString();
    }

    public HiveDecimal setScale(int i) {
        return new HiveDecimal(this.bd.setScale(i));
    }

    @Override
    public int compareTo(HiveDecimal dec) {
        return this.bd.compareTo(dec.bd);
    }

    public int hashCode() {
        return this.bd.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        return this.bd.equals(((HiveDecimal)obj).bd);
    }

    public int scale() {
        return this.bd.scale();
    }

    public int precision() {
        return this.bd.precision();
    }

    public int intValue() {
        return this.bd.intValue();
    }

    public double doubleValue() {
        return this.bd.doubleValue();
    }

    public long longValue() {
        return this.bd.longValue();
    }

    public short shortValue() {
        return this.bd.shortValue();
    }

    public float floatValue() {
        return this.bd.floatValue();
    }

    public BigDecimal bigDecimalValue() {
        return this.bd;
    }

    public byte byteValue() {
        return this.bd.byteValue();
    }

    public HiveDecimal setScale(int adjustedScale, int rm) {
        return new HiveDecimal(this.bd.setScale(adjustedScale, rm));
    }

    public HiveDecimal subtract(HiveDecimal dec) {
        return new HiveDecimal(this.bd.subtract(dec.bd));
    }

    public HiveDecimal multiply(HiveDecimal dec) {
        return new HiveDecimal(this.bd.multiply(dec.bd));
    }

    public BigInteger unscaledValue() {
        return this.bd.unscaledValue();
    }

    public HiveDecimal scaleByPowerOfTen(int n) {
        return new HiveDecimal(this.bd.scaleByPowerOfTen(n));
    }

    public HiveDecimal abs() {
        return new HiveDecimal(this.bd.abs());
    }

    public HiveDecimal negate() {
        return new HiveDecimal(this.bd.negate());
    }

    public HiveDecimal add(HiveDecimal dec) {
        return new HiveDecimal(this.bd.add(dec.bd));
    }

    public HiveDecimal pow(int n) {
        return new HiveDecimal(this.bd.pow(n));
    }

    public HiveDecimal remainder(HiveDecimal dec) {
        return new HiveDecimal(this.bd.remainder(dec.bd));
    }

    public HiveDecimal divide(HiveDecimal dec) {
        return new HiveDecimal(this.bd.divide(dec.bd, 38, RoundingMode.HALF_UP), true);
    }

    private BigDecimal trim(BigDecimal d) {
        if (d.compareTo(BigDecimal.ZERO) == 0) {
            d = BigDecimal.ZERO;
        } else if ((d = d.stripTrailingZeros()).scale() < 0) {
            d = d.setScale(0);
        }
        return d;
    }

    private BigDecimal normalize(BigDecimal d, int precision, boolean allowRounding) {
        if (d == null) {
            return null;
        }
        int valuePrecision = (d = this.trim(d)).precision() + Math.max(0, 1 + d.scale() - d.precision());
        if (valuePrecision > precision) {
            if (allowRounding) {
                int adjustedScale = d.scale() - (valuePrecision - precision);
                if (adjustedScale >= 0) {
                    d = d.setScale(adjustedScale, RoundingMode.HALF_UP);
                    d = this.trim(d);
                } else {
                    d = null;
                }
            } else {
                d = null;
            }
        }
        return d;
    }
}

