/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.api.r;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.spark.SparkConf;
import org.apache.spark.api.r.RBackend;
import org.apache.spark.api.r.RUtils$;
import org.apache.spark.api.r.SerDe$;
import org.apache.spark.api.r.SparkRDefaults$;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.Logging$class;
import org.slf4j.Logger;
import scala.Function0;
import scala.Serializable;
import scala.collection.mutable.StringBuilder;

public final class RBackend$
implements Logging {
    public static final RBackend$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new RBackend$();
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging$class.initializeLogIfNecessary(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging$class.initializeLogIfNecessary(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging$class.initializeLogIfNecessary$default$2(this);
    }

    public void main(String[] args) {
        if (args.length < 1) {
            System.err.println("Usage: RBackend <tempFilePath>");
            System.exit(-1);
        }
        RBackend sparkRBackend = new RBackend();
        try {
            int boundPort2 = sparkRBackend.init();
            ServerSocket serverSocket = new ServerSocket(0, 1, InetAddress.getByName("localhost"));
            int listenPort = serverSocket.getLocalPort();
            SparkConf conf = new SparkConf();
            int backendConnectionTimeout = conf.getInt("spark.r.backendConnectionTimeout", SparkRDefaults$.MODULE$.DEFAULT_CONNECTION_TIMEOUT());
            String path = args[0];
            File f = new File(new StringBuilder().append((Object)path).append((Object)".tmp").toString());
            DataOutputStream dos = new DataOutputStream(new FileOutputStream(f));
            dos.writeInt(boundPort2);
            dos.writeInt(listenPort);
            SerDe$.MODULE$.writeString(dos, (String)RUtils$.MODULE$.rPackages().getOrElse((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "";
                }
            }));
            dos.writeInt(backendConnectionTimeout);
            dos.close();
            f.renameTo(new File(path));
            new Thread(sparkRBackend, serverSocket){
                private final RBackend sparkRBackend$1;
                private final ServerSocket serverSocket$1;

                public void run() {
                    byte[] buf = new byte[1024];
                    this.serverSocket$1.setSoTimeout(10000);
                    try {
                        Socket inSocket = this.serverSocket$1.accept();
                        this.serverSocket$1.close();
                        inSocket.getInputStream().read(buf);
                        return;
                    }
                    finally {
                        this.sparkRBackend$1.close();
                        System.exit(0);
                    }
                }
                {
                    this.sparkRBackend$1 = sparkRBackend$1;
                    this.serverSocket$1 = serverSocket$1;
                    super("wait for socket to close");
                    this.setDaemon(true);
                }
            }.start();
            sparkRBackend.run();
        }
        catch (IOException iOException) {
            this.logError((Function0<String>)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Server shutting down: failed with exception ";
                }
            }, iOException);
            sparkRBackend.close();
            System.exit(1);
        }
        System.exit(0);
    }

    private RBackend$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        this.initializeLogIfNecessary(true);
    }
}

