/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.ast.antlr;

import com.splunk.commons.ast.antlr.ExpressionVisitor;
import com.splunk.commons.ast.nodes.CommandNode;
import com.splunk.commons.ast.nodes.IWherePredicate;
import com.splunk.commons.ast.nodes.Node;
import com.splunk.commons.ast.nodes.commands.HeadCommand;
import com.splunk.commons.ast.nodes.commands.SearchCommand;
import com.splunk.commons.ast.nodes.expressions.BooleanNode;
import com.splunk.commons.ast.nodes.expressions.NumberNode;
import com.splunk.spl.parser.SplunkCommandParser;
import com.splunk.spl.parser.SplunkCommandParserBaseVisitor;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.RuleNode;

public class CommandHeadVisitor
extends SplunkCommandParserBaseVisitor<Node> {
    private BooleanNode keeplast;
    private BooleanNode nullmatch;
    private NumberNode limit;
    private IWherePredicate conditions;
    private final ExpressionVisitor expressionVisitor = new ExpressionVisitor();

    @Override
    public Node visitHeadParse(SplunkCommandParser.HeadParseContext ctx) {
        Node node;
        SplunkCommandParser.HeadWhileClauseContext headWhileClauseContext = ctx.headWhileClause();
        if (headWhileClauseContext != null && (node = (Node)this.visit((ParseTree)headWhileClauseContext)) == null) {
            throw new IllegalArgumentException("HEAD has an illegal while option: " + headWhileClauseContext.getText());
        }
        SplunkCommandParser.HeadLimitContext limitContext = ctx.headLimit();
        if (limitContext != null && (node = (Node)this.visit((ParseTree)limitContext)) == null) {
            throw new IllegalArgumentException("HEAD has an illegal limit option: " + limitContext.getText());
        }
        return new HeadCommand((CommandNode)new SearchCommand(), this.limit, this.conditions, this.keeplast, this.nullmatch, false);
    }

    @Override
    public Node visitHeadWhileClause(SplunkCommandParser.HeadWhileClauseContext ctx) {
        Node node = null;
        SplunkCommandParser.HeadConditionContext headConditionContext = ctx.headCondition();
        if (headConditionContext != null && (node = (Node)this.visit((ParseTree)headConditionContext)) == null) {
            throw new IllegalArgumentException("HEAD has an illegal while condition: " + headConditionContext.getText());
        }
        for (SplunkCommandParser.HeadBoolContext optsContext : ctx.headBool()) {
            node = (Node)this.visit((ParseTree)optsContext);
            if (node != null) continue;
            throw new IllegalArgumentException("HEAD has an illegal option: " + optsContext.getText());
        }
        return node;
    }

    @Override
    public Node visitHeadCommand(SplunkCommandParser.HeadCommandContext ctx) {
        return (Node)this.visitChildren((RuleNode)ctx);
    }

    @Override
    public Node visitHeadLimit(SplunkCommandParser.HeadLimitContext ctx) {
        Integer n = Integer.valueOf(ctx.headOptValue.getText());
        this.limit = (NumberNode)CommandHeadVisitor.setArgIfNull(this.limit, new NumberNode(n), "limit", ctx.getText());
        return this.limit;
    }

    @Override
    public Node visitHeadBool(SplunkCommandParser.HeadBoolContext ctx) {
        Token fieldToken = ctx.headOptField;
        String value = ctx.headOptValue.getText();
        BooleanNode bNode = BooleanNode.load(value);
        switch (fieldToken.getType()) {
            case 151: {
                this.keeplast = (BooleanNode)CommandHeadVisitor.setArgIfNull(this.keeplast, bNode, fieldToken.getText(), ctx.getText());
                break;
            }
            case 154: {
                this.nullmatch = (BooleanNode)CommandHeadVisitor.setArgIfNull(this.nullmatch, bNode, fieldToken.getText(), ctx.getText());
                break;
            }
            default: {
                bNode = null;
            }
        }
        return bNode;
    }

    @Override
    public Node visitHeadCondition(SplunkCommandParser.HeadConditionContext ctx) {
        SplunkCommandParser.BoolExpressionContext beContexts = ctx.boolExpression();
        IWherePredicate cond = (IWherePredicate)this.expressionVisitor.visit((ParseTree)beContexts);
        this.conditions = (IWherePredicate)CommandHeadVisitor.setArgIfNull(this.conditions, cond, "condition", ctx.getText());
        return BooleanNode.TRUE;
    }

    private static Object setArgIfNull(Object dest, Object src, String arg, String text) {
        if (dest == null) {
            dest = src;
            return dest;
        }
        throw new IllegalArgumentException("HEAD has a duplicate option '" + arg + "': " + text);
    }
}

