/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.ast.antlr;

import com.splunk.commons.ast.antlr.ExpressionVisitor;
import com.splunk.commons.ast.nodes.IWherePredicate;
import com.splunk.commons.ast.nodes.Node;
import com.splunk.commons.ast.nodes.commands.McatalogCommand;
import com.splunk.commons.ast.nodes.expressions.AggregateFunction;
import com.splunk.commons.ast.nodes.expressions.AggregateNode;
import com.splunk.commons.ast.nodes.expressions.BooleanNode;
import com.splunk.commons.ast.nodes.search.IGroupBy;
import com.splunk.spl.parser.SplunkCommandParser;
import com.splunk.spl.parser.SplunkCommandParserBaseVisitor;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;

public class CommandMcatalogVisitor
extends SplunkCommandParserBaseVisitor<Node> {
    private BooleanNode prestats;
    private BooleanNode append;

    @Override
    public Node visitMcatalogParse(SplunkCommandParser.McatalogParseContext ctx) {
        ExpressionVisitor expVisitor = new ExpressionVisitor();
        Node wherePredicate = null;
        IGroupBy[] groupbyNodes = null;
        AggregateNode[] values = new AggregateNode[ctx.mcatalogValues().mcatalogValue().size()];
        AggregateFunction func = AggregateFunction.fromString("values");
        for (Object optsContext : ctx.mcatalogOpts()) {
            Node node = (Node)this.visit((ParseTree)optsContext);
            if (node != null) continue;
            throw new IllegalArgumentException("MCatalog has an illegal option: " + optsContext.getText());
        }
        int vIdx = 0;
        for (SplunkCommandParser.McatalogValueContext valueContext : ctx.mcatalogValues().mcatalogValue()) {
            String valueField = valueContext.mcatalogValueField.getText();
            values[vIdx] = valueContext.mcatalogValueAsField == null ? new AggregateNode(func, valueField) : new AggregateNode(func, valueField, valueContext.mcatalogValueAsField.getText());
            ++vIdx;
        }
        if (ctx.whereClause() != null) {
            wherePredicate = (Node)expVisitor.visit((ParseTree)ctx.whereClause().boolExpression());
        }
        if (ctx.groupbyClause() != null) {
            int numExpr = ctx.groupbyClause().groupByField().size();
            groupbyNodes = new IGroupBy[numExpr];
            for (int i = 0; i < numExpr; ++i) {
                groupbyNodes[i] = (IGroupBy)expVisitor.visit((ParseTree)ctx.groupbyClause().groupByField(i));
            }
        }
        return new McatalogCommand(values, (IWherePredicate)((Object)wherePredicate), groupbyNodes, this.prestats, this.append);
    }

    @Override
    public Node visitMcatalogOpts(SplunkCommandParser.McatalogOptsContext ctx) {
        Token fieldToken = ctx.mcatalogOptField;
        String value = ctx.mcatalogOptValue.getText();
        BooleanNode bNode = BooleanNode.load(value);
        switch (fieldToken.getType()) {
            case 157: {
                this.prestats = (BooleanNode)CommandMcatalogVisitor.setArgIfNull(this.prestats, bNode, fieldToken.getText(), ctx.getText());
                break;
            }
            case 140: {
                this.append = (BooleanNode)CommandMcatalogVisitor.setArgIfNull(this.append, bNode, fieldToken.getText(), ctx.getText());
                break;
            }
            default: {
                bNode = null;
            }
        }
        return bNode;
    }

    private static Object setArgIfNull(Object dest, Object src, String arg, String text) {
        if (dest == null) {
            dest = src;
            return dest;
        }
        throw new IllegalArgumentException("MCATALOG has a duplicate option '" + arg + "': " + text);
    }
}

