/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.ast.antlr;

import com.splunk.commons.ast.SPLParseException;
import com.splunk.commons.ast.antlr.ExpressionVisitor;
import com.splunk.commons.ast.nodes.Node;
import com.splunk.commons.ast.nodes.commands.RexCommand;
import com.splunk.commons.ast.nodes.commands.SearchCommand;
import com.splunk.commons.ast.nodes.expressions.FieldNode;
import com.splunk.spl.parser.SplunkCommandParser;
import com.splunk.spl.parser.SplunkCommandParserBaseVisitor;
import org.antlr.v4.runtime.tree.ParseTree;

public class CommandRexVisitor
extends SplunkCommandParserBaseVisitor<Node> {
    private final ExpressionVisitor expressionVisitor = new ExpressionVisitor();

    @Override
    public Node visitRexParse(SplunkCommandParser.RexParseContext ctx) {
        SplunkCommandParser.RexRegexOptsContext regexOps = ctx.rexRegexOpts();
        SplunkCommandParser.RexSedOptsContext sedOps = ctx.rexSedOpts();
        FieldNode field = null;
        if (ctx.rexFieldOpt() != null) {
            field = (FieldNode)this.expressionVisitor.visit((ParseTree)ctx.rexFieldOpt().field());
        }
        if (regexOps != null) {
            int maxMatch;
            FieldNode offsetField;
            block20: {
                offsetField = null;
                if (regexOps.offsetFieldOpt().size() == 1) {
                    offsetField = (FieldNode)this.expressionVisitor.visit((ParseTree)regexOps.offsetFieldOpt(0).field());
                } else if (regexOps.offsetFieldOpt().size() > 1) {
                    throw new SPLParseException("Failed to parse rex command: offset_field option can only occur at most once.");
                }
                maxMatch = 1;
                if (regexOps.maxMatchOpt().size() == 1) {
                    String error = "Failed to parse max_match option of rex command: Only integer greater than or equals to zero is allowed. Found max_match='" + regexOps.maxMatchOpt(0).INTEGER().getText() + "'.";
                    try {
                        maxMatch = Integer.parseInt(regexOps.maxMatchOpt(0).INTEGER().getText());
                        if (maxMatch < 0) {
                            throw new SPLParseException(error);
                        }
                        break block20;
                    }
                    catch (NumberFormatException e) {
                        throw new SPLParseException(error);
                    }
                }
                if (regexOps.maxMatchOpt().size() > 1) {
                    throw new SPLParseException("Failed to parse rex command: max_match option can only occur at most once.");
                }
            }
            String regexExp = this.expressionVisitor.visitGenericstring(regexOps.genericstring()).getValue();
            return RexCommand.rex(new SearchCommand(), regexExp, field, offsetField, maxMatch);
        }
        if (sedOps != null) {
            String sedExp = this.expressionVisitor.visitGenericstring(sedOps.genericstring()).getValue();
            String[] sedExps = sedExp.split("/");
            if (sedExps.length == 4 && "s".equals(sedExps[0])) {
                String error = "Failed to parse flag for sed expression: Only letter 'g' and a non-negative integer are supported. Found flag=" + sedExps[3];
                if (!"g".equals(sedExps[3])) {
                    try {
                        int i = Integer.parseInt(sedExps[3]);
                        if (i < 0) {
                            throw new SPLParseException(error);
                        }
                    }
                    catch (NumberFormatException e) {
                        throw new SPLParseException(error);
                    }
                }
            } else if (sedExps.length == 3) {
                if (!sedExps[0].equals("y")) {
                    throw new SPLParseException("Failed to parse rex command: The syntax for using sed to substitute characters is: \"y/<string1>/<string2>/\"");
                }
            } else {
                throw new SPLParseException("Failed to parse rex command: When using the rex command in sed mode, only two options are allowed: replace (s) or character substitution (y). SPL=[" + sedOps.genericstring().getText() + ']');
            }
            return RexCommand.sed(new SearchCommand(), sedExp, field);
        }
        throw new SPLParseException("Failed to parse rex command: Only regex and sed mode are accepted. SPL=[" + ctx.getText() + "].");
    }
}

