/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.ast.nodes.commands;

import com.splunk.commons.ast.nodes.CommandNode;
import com.splunk.commons.ast.nodes.CommandType;
import com.splunk.commons.ast.nodes.IFilteringCommand;
import com.splunk.commons.ast.nodes.IGroupingCommand;
import com.splunk.commons.ast.nodes.IPredicate;
import com.splunk.commons.ast.nodes.ISearchPredicate;
import com.splunk.commons.ast.nodes.IWherePredicate;
import com.splunk.commons.ast.nodes.commands.FieldsAndProperties;
import com.splunk.commons.ast.nodes.commands.FromCommand;
import com.splunk.commons.ast.nodes.commands.UnionCommand;
import com.splunk.commons.ast.nodes.expressions.AggregateNode;
import com.splunk.commons.ast.nodes.expressions.BinNode;
import com.splunk.commons.ast.nodes.expressions.FieldNode;
import com.splunk.commons.ast.nodes.expressions.TimeSpanNode;
import com.splunk.commons.ast.nodes.search.IGroupBy;
import com.splunk.commons.datasets.Dataset;
import com.splunk.commons.datasets.TransientDataset;
import com.splunk.commons.visitors.AssertingVisitor;
import com.splunk.commons.visitors.IndexEliminatingVisitor;
import com.splunk.commons.visitors.NodeVisitor;
import com.splunk.commons.visitors.RequiredDatasetVisitor;
import com.splunk.commons.visitors.SearchToWhereConverter;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

public final class MStatsCommand
extends CommandNode
implements IGroupingCommand,
IFilteringCommand {
    private final AggregateNode[] aggregates;
    private final IGroupBy[] byFields;
    private final ISearchPredicate where;

    public MStatsCommand(AggregateNode[] aggregates, ISearchPredicate where) {
        this(aggregates, new FieldNode[0], where);
    }

    public MStatsCommand(AggregateNode[] aggregates, IGroupBy[] byFields, ISearchPredicate where) {
        super("mstats", CommandType.SP_STREAMREPORT, new FieldsAndProperties().mstats(aggregates, byFields, where).array());
        MStatsCommand.assertParamMembersNotNull(aggregates, "aggregates");
        AssertingVisitor.assertOnlySearchComparisonsAndGroups(where, "MStats only supports comparisons, using TERMS and PHRASES outside comparisons is NOT supported.\"");
        this.aggregates = aggregates;
        if (byFields != null) {
            for (int i = byFields.length - 1; i >= 0; --i) {
                if (byFields[i] instanceof BinNode) {
                    BinNode bn = (BinNode)byFields[i];
                    if (i < byFields.length - 1) {
                        throw new IllegalArgumentException("When grouping by time-span, it shouldn't be followed by any other group-by fields. That is time-span should appear in the end of the group-by list");
                    }
                    if (!bn.getField().getFieldName().equals("_time")) {
                        throw new IllegalArgumentException("When grouping by time-span, only _time field is allowed");
                    }
                    if (bn.getSpan() != null && bn.getSpan() instanceof TimeSpanNode) continue;
                    throw new IllegalArgumentException("When grouping by _time, a time span is required.");
                }
                if (byFields[i] instanceof FieldNode) continue;
                throw new IllegalArgumentException("Invalid group-by field provided for Mstats command");
            }
        }
        this.byFields = byFields;
        this.where = where;
    }

    public AggregateNode[] getAggregates() {
        return this.aggregates;
    }

    @Override
    public List<IGroupBy> getByFields() {
        return this.byFields != null ? Arrays.asList(this.byFields) : null;
    }

    @Override
    public <T> T accept(NodeVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public CommandNode from() {
        Set<Dataset> datasets = this.accept(new RequiredDatasetVisitor());
        Dataset sourceDataset = null;
        if (!datasets.isEmpty()) {
            if (datasets.size() == 1) {
                sourceDataset = (Dataset)datasets.toArray()[0];
            } else {
                CommandNode[] nodes = new CommandNode[datasets.size()];
                int i = 0;
                for (Dataset d : datasets) {
                    nodes[i++] = d.from();
                }
                sourceDataset = new TransientDataset(new UnionCommand(nodes));
            }
        }
        IWherePredicate predicate = null;
        if (this.where != null) {
            ISearchPredicate searchPredicate = null;
            if (!datasets.isEmpty()) {
                searchPredicate = (ISearchPredicate)((Object)this.where.getSearchNode().accept(new IndexEliminatingVisitor()));
            }
            if (searchPredicate != null) {
                predicate = searchPredicate.getSearchNode().accept(new SearchToWhereConverter());
            }
        }
        return new FromCommand(sourceDataset, predicate, this.getByFields().toArray(new IGroupBy[0]), this.aggregates, null);
    }

    @Override
    public IPredicate getPredicate() {
        return this.where;
    }

    @Override
    public CommandNode getCommand() {
        return this;
    }
}

