/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.ast.nodes.commands;

import com.splunk.commons.ast.nodes.CommandNode;
import com.splunk.commons.ast.nodes.CommandType;
import com.splunk.commons.ast.nodes.commands.FieldProperties;
import com.splunk.commons.ast.nodes.commands.FieldsAndProperties;
import com.splunk.commons.ast.nodes.expressions.ParamNode;
import com.splunk.commons.ast.nodes.expressions.StringNode;
import com.splunk.commons.visitors.NodeVisitor;
import java.util.Set;

public class SendalertCommand
extends CommandNode {
    private final StringNode name;
    private final StringNode resultsLink;
    private final StringNode resultsPath;
    private final ParamNode[] params;

    public SendalertCommand(CommandNode source, StringNode name, StringNode resultsLink, StringNode resultsPath) {
        super(source, "sendalert", CommandType.SP_REPORT, new FieldsAndProperties().array());
        this.name = name;
        this.resultsLink = resultsLink;
        this.resultsPath = resultsPath;
        this.params = new ParamNode[0];
    }

    public SendalertCommand(CommandNode source, StringNode name, StringNode resultsLink, StringNode resultsPath, ParamNode[] paramNodes) {
        super(source, "sendalert", CommandType.SP_REPORT, new FieldsAndProperties().array());
        this.name = name;
        this.resultsLink = resultsLink;
        this.resultsPath = resultsPath;
        this.params = paramNodes;
    }

    public StringNode getName() {
        return this.name;
    }

    public StringNode getResultsLink() {
        return this.resultsLink;
    }

    public StringNode getResultsPath() {
        return this.resultsPath;
    }

    public ParamNode[] getParams() {
        return this.params;
    }

    @Override
    public <T> T accept(NodeVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public CommandNode setSource(CommandNode source) {
        return new SendalertCommand(source, this.name, this.resultsLink, this.resultsPath, this.params);
    }

    @Override
    public void setRequiredFields(Set<String> requiredFields) {
        for (FieldProperties fp : this.getFieldPropertiesArray()) {
            if (!fp.getReferenced()) continue;
            requiredFields.add(fp.getName());
        }
    }
}

