/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.ast.nodes.expressions;

import com.splunk.commons.ast.nodes.expressions.NumberNode;
import com.splunk.commons.ast.nodes.expressions.SpanNode;
import com.splunk.commons.visitors.NodeVisitor;
import com.splunk.commons.visitors.SplFormatter;

public class LogSpanNode
extends SpanNode {
    private NumberNode coefficient;
    private NumberNode base;

    public LogSpanNode(String logspan) {
        super("logspan");
        int i = logspan.indexOf("log");
        if (i < 0) {
            throw new IllegalArgumentException("Invalid logspan node: " + logspan);
        }
        if (i > 0) {
            this.coefficient = new NumberNode(Double.parseDouble(logspan.substring(0, i)));
        }
        if ((i += 3) < logspan.length()) {
            this.base = new NumberNode(Double.parseDouble(logspan.substring(i)));
        }
        LogSpanNode.validateArgs(this.coefficient, this.base);
    }

    public LogSpanNode(NumberNode coefficient, NumberNode base) {
        super("logspan");
        LogSpanNode.validateArgs(coefficient, base);
        this.coefficient = coefficient;
        this.base = base;
    }

    private static void validateArgs(NumberNode coefficient, NumberNode base) {
        double ba;
        double co = 1.0;
        if (coefficient != null && (co = ((Double)coefficient.getValue()).doubleValue()) < 1.0) {
            throw new IllegalArgumentException("Failed to parse log-span option: coefficient must be greater than 1.0. coeeficient=" + co);
        }
        if (base != null && ((ba = ((Double)base.getValue()).doubleValue()) <= 1.0 || co >= ba)) {
            throw new IllegalArgumentException("Failed to parse log-span option: base must be greater than 1.0 and coefficient. base=" + ba);
        }
    }

    public NumberNode getCoefficient() {
        return this.coefficient;
    }

    public NumberNode getBase() {
        return this.base;
    }

    public String toString() {
        return this.accept(new SplFormatter());
    }

    @Override
    public <T> T accept(NodeVisitor<T> visitor) {
        return visitor.visit(this);
    }
}

