/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.datasets;

import com.splunk.commons.RepresentativeRow;
import com.splunk.commons.ast.nodes.IPredicate;
import com.splunk.commons.datasets.Fields;
import com.splunk.commons.datasets.IDatasetInfo;
import com.splunk.commons.datasets.IField;
import com.splunk.commons.datasets.IPartitionEliminator;
import com.splunk.commons.datasets.Properties;
import com.splunk.commons.util.SafeArgs;
import com.splunk.commons.visitors.PredicateEvaluator;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bson.types.ObjectId;
import org.json.JSONObject;

public class BaseDataset
implements IDatasetInfo,
IPartitionEliminator {
    public static final String[] RESERVED = new String[]{"id", "name", "kind", "owner", "created", "modified", "createdBy", "modifiedBy", "version", "fields", "module"};
    private final ObjectId id;
    private final String name;
    private final String kind;
    private final String module;
    private final String owner;
    private final Timestamp created;
    private final Timestamp modified;
    private final String createdBy;
    private final String modifiedBy;
    private final Integer version;
    private final Properties properties;
    private final Map<String, IField> fieldNameMap = new HashMap<String, IField>();
    private final Map<ObjectId, IField> fieldIdMap = new HashMap<ObjectId, IField>();
    private final List<IField> fields;

    public BaseDataset(ObjectId id, String module, String name, String kind, String owner, Properties properties) {
        this(id, module, name, kind, owner, Timestamp.from(Instant.now()), Timestamp.from(Instant.now()), owner, owner, 1, properties, null);
    }

    public BaseDataset(ObjectId id, String module, String name, String kind, String owner, Properties properties, List<IField> fields) {
        this(id, module, name, kind, owner, Timestamp.from(Instant.now()), Timestamp.from(Instant.now()), owner, owner, 1, properties, fields);
    }

    private BaseDataset(ObjectId id, String module, String name, String kind, String owner, Timestamp created, Timestamp modified, String createdBy, String modifiedBy, Integer version, Properties properties, List<IField> fields) {
        this.id = SafeArgs.valueIsNotNull(id, "The id must not be null.");
        this.module = SafeArgs.valueIsNotNull(module, "The module must not be null.");
        this.name = SafeArgs.valueIsNotNull(name, "The name must not be null.");
        this.kind = SafeArgs.valueIsNotNull(kind, "The kind must not be null.");
        this.owner = SafeArgs.valueIsNotNull(owner, "The owner must not be null.");
        this.created = created;
        this.modified = modified;
        this.createdBy = createdBy;
        this.modifiedBy = modifiedBy;
        this.version = version;
        this.properties = properties;
        this.fields = fields;
    }

    BaseDataset(IDatasetInfo info) {
        if (info == null) {
            throw new IllegalArgumentException("Passed in null IDatasetInfo for construction");
        }
        this.id = SafeArgs.valueIsNotNull(info.getId(), "The id must not be null.");
        this.module = SafeArgs.valueIsNotNull(info.getModule(), "The module must not be null.");
        this.name = SafeArgs.valueIsNotNull(info.getName(), "The name must not be null.");
        this.kind = SafeArgs.valueIsNotNull(info.getKind(), "The kind must not be null.");
        this.owner = SafeArgs.valueIsNotNull(info.getOwner(), "The owner must not be null.");
        this.created = info.getCreated();
        this.modified = info.getModified();
        this.createdBy = info.getCreatedBy();
        this.modifiedBy = info.getModifiedBy();
        this.version = info.getVersion();
        this.properties = info.getProperties();
        this.fields = info.getFields();
    }

    BaseDataset(JSONObject jsonObject) {
        this(jsonObject.get("id") == null ? new ObjectId() : new ObjectId(jsonObject.getString("id")), jsonObject.getString("module"), jsonObject.getString("name"), jsonObject.getString("kind"), jsonObject.getString("owner"), jsonObject.get("created") == null ? null : new Timestamp(jsonObject.getLong("created")), jsonObject.optString("modified", null) == null ? null : new Timestamp(jsonObject.getLong("modified")), jsonObject.optString("createdBy", null) == null ? null : jsonObject.getString("createdBy"), jsonObject.optString("modifiedBy", null) == null ? null : jsonObject.getString("modifiedBy"), jsonObject.optInt("version", -1) == -1 ? null : Integer.valueOf(jsonObject.getInt("version")), jsonObject.optJSONObject("properties") == null ? null : Properties.fromJsonObject(jsonObject.getJSONObject("properties")), null);
    }

    @Override
    public String getModule() {
        return this.module;
    }

    public static BaseDataset load(JSONObject jsonObject) {
        return new BaseDataset(jsonObject);
    }

    @Override
    public ObjectId getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getQualifiedName() {
        if (this.kind == null) {
            return this.name;
        }
        return this.kind + ':' + this.name;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public String getOwner() {
        return this.owner;
    }

    @Override
    public Timestamp getCreated() {
        return this.created;
    }

    @Override
    public Timestamp getModified() {
        return this.modified;
    }

    @Override
    public String getCreatedBy() {
        return this.createdBy;
    }

    @Override
    public String getModifiedBy() {
        return this.modifiedBy;
    }

    @Override
    public Integer getVersion() {
        return this.version;
    }

    @Override
    public List<IField> getFields() {
        return this.fields;
    }

    public Map<String, IField> getFieldNameMap() {
        return this.fieldNameMap;
    }

    public Map<ObjectId, IField> getFieldIdMap() {
        return this.fieldIdMap;
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    public boolean validateProperties() {
        return true;
    }

    @Override
    public JSONObject getJSON() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("id", (Object)this.id.toString());
        jsonObject.put("module", (Object)this.module);
        jsonObject.put("name", (Object)this.name);
        jsonObject.put("kind", (Object)this.kind);
        jsonObject.put("owner", (Object)this.owner);
        jsonObject.put("created", this.created.getTime());
        jsonObject.put("modified", this.modified.getTime());
        jsonObject.put("createdBy", (Object)this.createdBy);
        jsonObject.put("modifiedBy", (Object)this.modifiedBy);
        jsonObject.put("version", (Object)this.version);
        jsonObject.put("fields", (Object)Fields.getJSON(this.fields));
        jsonObject.put("properties", (Object)this.properties.getJsonObject());
        return jsonObject;
    }

    @Override
    public boolean canEliminate(IPredicate predicate) {
        PredicateEvaluator evaluator = new PredicateEvaluator();
        evaluator.setPredicate(predicate);
        return !evaluator.evaluate(new RepresentativeRow(this.fields));
    }
}

