/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.util;

import java.sql.Timestamp;
import org.bson.types.ObjectId;

public final class SafeArgs {
    private SafeArgs() {
    }

    public static <T> T valueIsNotNull(T arg, String message) throws IllegalArgumentException {
        if (arg == null) {
            throw new IllegalArgumentException(message);
        }
        return arg;
    }

    public static <T> T defaultIfNull(T value, T defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public static long valueIsAtMost(long value, long lower) throws IllegalArgumentException {
        if (value > lower) {
            throw new IllegalArgumentException(String.format("The value provided (%1$d) is greater than %2$d", value, lower));
        }
        return value;
    }

    public static long valueIsAtMost(int value, int lower) throws IllegalArgumentException {
        if (value > lower) {
            throw new IllegalArgumentException(String.format("The value provided (%1$d) is greater than %2$d", value, lower));
        }
        return value;
    }

    public static long valueIsAtLeast(long value, long lower) throws IllegalArgumentException {
        if (value < lower) {
            throw new IllegalArgumentException(String.format("The value provided (%1$d) is less than %2$d", value, lower));
        }
        return value;
    }

    public static int valueIsAtLeast(int value, int lower) throws IllegalArgumentException {
        if (value < lower) {
            throw new IllegalArgumentException(String.format("The value provided (%1$d) is less than %2$d", value, lower));
        }
        return value;
    }

    public static Timestamp valueIsAtLeast(Timestamp value, Timestamp lower) throws IllegalArgumentException {
        SafeArgs.valueIsNotNull(value, "The value must not be null.");
        if (value.before(lower)) {
            throw new IllegalArgumentException(String.format("The value provided (%1$tQ) must be at least %2$tQ", value, lower));
        }
        return value;
    }

    public static ObjectId getOrNewId(ObjectId id) {
        if (id == null) {
            id = new ObjectId();
        }
        return id;
    }
}

