/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.visitors;

import com.splunk.commons.ast.nodes.CommandNode;
import com.splunk.commons.ast.nodes.IWherePredicate;
import com.splunk.commons.ast.nodes.Node;
import com.splunk.commons.ast.nodes.commands.AddInfoCommand;
import com.splunk.commons.ast.nodes.commands.AppendCommand;
import com.splunk.commons.ast.nodes.commands.ApplyCommand;
import com.splunk.commons.ast.nodes.commands.BinCommand;
import com.splunk.commons.ast.nodes.commands.Conditional;
import com.splunk.commons.ast.nodes.commands.DatamodelCommand;
import com.splunk.commons.ast.nodes.commands.DedupCommand;
import com.splunk.commons.ast.nodes.commands.EvalCommand;
import com.splunk.commons.ast.nodes.commands.FieldProperties;
import com.splunk.commons.ast.nodes.commands.FieldsCommand;
import com.splunk.commons.ast.nodes.commands.FitCommand;
import com.splunk.commons.ast.nodes.commands.FromCommand;
import com.splunk.commons.ast.nodes.commands.GroupByCommand;
import com.splunk.commons.ast.nodes.commands.HeadCommand;
import com.splunk.commons.ast.nodes.commands.IfCommand;
import com.splunk.commons.ast.nodes.commands.InputlookupCommand;
import com.splunk.commons.ast.nodes.commands.IntoCommand;
import com.splunk.commons.ast.nodes.commands.IplocationCommand;
import com.splunk.commons.ast.nodes.commands.JobPartitionerCommand;
import com.splunk.commons.ast.nodes.commands.JoinCommand;
import com.splunk.commons.ast.nodes.commands.LoadJobCommand;
import com.splunk.commons.ast.nodes.commands.LookupCommand;
import com.splunk.commons.ast.nodes.commands.MStatsCommand;
import com.splunk.commons.ast.nodes.commands.McatalogCommand;
import com.splunk.commons.ast.nodes.commands.MvexpandCommand;
import com.splunk.commons.ast.nodes.commands.RdOutCommand;
import com.splunk.commons.ast.nodes.commands.RegexCommand;
import com.splunk.commons.ast.nodes.commands.RenameCommand;
import com.splunk.commons.ast.nodes.commands.RenameNode;
import com.splunk.commons.ast.nodes.commands.ReplacementNode;
import com.splunk.commons.ast.nodes.commands.RexCommand;
import com.splunk.commons.ast.nodes.commands.SavedsearchCommand;
import com.splunk.commons.ast.nodes.commands.SearchCommand;
import com.splunk.commons.ast.nodes.commands.SelfJoinCommand;
import com.splunk.commons.ast.nodes.commands.SendalertCommand;
import com.splunk.commons.ast.nodes.commands.SortCommand;
import com.splunk.commons.ast.nodes.commands.StatsCommand;
import com.splunk.commons.ast.nodes.commands.TStatsCommand;
import com.splunk.commons.ast.nodes.commands.TableCommand;
import com.splunk.commons.ast.nodes.commands.TailCommand;
import com.splunk.commons.ast.nodes.commands.TimechartCommand;
import com.splunk.commons.ast.nodes.commands.UnionCommand;
import com.splunk.commons.ast.nodes.commands.UnknownCommand;
import com.splunk.commons.ast.nodes.commands.WhereCommand;
import com.splunk.commons.ast.nodes.expressions.AggregateFunction;
import com.splunk.commons.ast.nodes.expressions.AggregateNode;
import com.splunk.commons.ast.nodes.expressions.AndNode;
import com.splunk.commons.ast.nodes.expressions.AssignmentNode;
import com.splunk.commons.ast.nodes.expressions.BinNode;
import com.splunk.commons.ast.nodes.expressions.BinOptionsNode;
import com.splunk.commons.ast.nodes.expressions.BooleanFunctionNode;
import com.splunk.commons.ast.nodes.expressions.BooleanNode;
import com.splunk.commons.ast.nodes.expressions.ComparisonNode;
import com.splunk.commons.ast.nodes.expressions.EvalAggregateNode;
import com.splunk.commons.ast.nodes.expressions.FieldNode;
import com.splunk.commons.ast.nodes.expressions.FunctionNode;
import com.splunk.commons.ast.nodes.expressions.InNode;
import com.splunk.commons.ast.nodes.expressions.JoinNode;
import com.splunk.commons.ast.nodes.expressions.MeasureNode;
import com.splunk.commons.ast.nodes.expressions.MultiValueNode;
import com.splunk.commons.ast.nodes.expressions.NavigationNode;
import com.splunk.commons.ast.nodes.expressions.NotNode;
import com.splunk.commons.ast.nodes.expressions.NullNode;
import com.splunk.commons.ast.nodes.expressions.NumberNode;
import com.splunk.commons.ast.nodes.expressions.Operator;
import com.splunk.commons.ast.nodes.expressions.OrNode;
import com.splunk.commons.ast.nodes.expressions.ParamNode;
import com.splunk.commons.ast.nodes.expressions.PercentageAggregateNode;
import com.splunk.commons.ast.nodes.expressions.SortNode;
import com.splunk.commons.ast.nodes.expressions.SpanNode;
import com.splunk.commons.ast.nodes.expressions.SparklineAggregateNode;
import com.splunk.commons.ast.nodes.expressions.StringNode;
import com.splunk.commons.ast.nodes.expressions.TableColumnOptionsNode;
import com.splunk.commons.ast.nodes.expressions.XorNode;
import com.splunk.commons.ast.nodes.search.IGroupBy;
import com.splunk.commons.ast.nodes.search.SearchAndNode;
import com.splunk.commons.ast.nodes.search.SearchComparisonNode;
import com.splunk.commons.ast.nodes.search.SearchFunctionNode;
import com.splunk.commons.ast.nodes.search.SearchInNode;
import com.splunk.commons.ast.nodes.search.SearchLeafNode;
import com.splunk.commons.ast.nodes.search.SearchNode;
import com.splunk.commons.ast.nodes.search.SearchNotNode;
import com.splunk.commons.ast.nodes.search.SearchOrNode;
import com.splunk.commons.ast.nodes.search.SearchQuotableNode;
import com.splunk.commons.ast.nodes.search.SearchSubSearchPredicateNode;
import com.splunk.commons.ast.nodes.search.SearchXorNode;
import com.splunk.commons.datasets.TransientDataset;
import com.splunk.commons.search.HostPort;
import com.splunk.commons.visitors.NodeVisitor;
import com.splunk.commons.visitors.SplFormatter;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class JsonFormatter
extends NodeVisitor<JSONObject> {
    private final boolean enableDatasetSerializationShorthand;
    private final boolean enableByFieldsTypeNodeSerializationFormat;

    public JsonFormatter() {
        this(true, true);
    }

    public JsonFormatter(boolean enableDatasetSerializationShorthand, boolean enableByFieldsTypeNodeSerializationFormat) {
        this.enableDatasetSerializationShorthand = enableDatasetSerializationShorthand;
        this.enableByFieldsTypeNodeSerializationFormat = enableByFieldsTypeNodeSerializationFormat;
    }

    @Override
    public JSONObject visit(Node node) {
        throw new UnsupportedOperationException("JsonFormatter can not format this node: " + node);
    }

    @Override
    public JSONObject visit(AggregateNode node) {
        JSONObject ret = new JSONObject();
        AggregateFunction function = node.getFunction();
        FieldNode field = node.getField();
        FunctionNode evalFunc = node.getEvalFunc();
        if (function != null) {
            ret.put("agg_function", (Object)function.toString());
        }
        if (field != null) {
            ret.put("field", (Object)field.accept(this));
        }
        ret.put("as", (Object)node.getAsName());
        if (evalFunc != null) {
            ret.put("field", (Object)evalFunc.accept(this));
        }
        return ret;
    }

    @Override
    public JSONObject visit(EvalAggregateNode node) {
        JSONObject ret = new JSONObject();
        ret.put("agg_function", (Object)node.getEvalFunc().getFunctionName());
        ret.put("field", (Object)node.getEvalFunc().getArguments().get(0).accept(this));
        ret.put("as", (Object)node.getAsName());
        return ret;
    }

    @Override
    public JSONObject visit(PercentageAggregateNode node) {
        JSONObject ret = new JSONObject();
        AggregateFunction function = node.getFunction();
        FieldNode field = node.getField();
        if (function != null) {
            ret.put("agg_function", (Object)(function.toString() + node.getPercentage()));
        }
        if (field != null) {
            ret.put("field", (Object)field.accept(this));
        }
        ret.put("as", (Object)node.getAsName());
        return ret;
    }

    @Override
    public JSONObject visit(SparklineAggregateNode node) {
        JSONObject ret = new JSONObject();
        AggregateFunction function = node.getFunction();
        AggregateFunction sparklineAggregateFunction = node.getSparklineAggregateFunction();
        FieldNode field = node.getField();
        StringNode timeSpan = node.getTimeSpan();
        if (function != null) {
            ret.put("agg_function", (Object)function.toString());
        }
        if (sparklineAggregateFunction != null) {
            ret.put("sparkline_agg_function", (Object)sparklineAggregateFunction.toString());
        }
        if (field != null) {
            ret.put("field", (Object)field.accept(this));
        }
        if (timeSpan != null) {
            ret.put("timespan", (Object)timeSpan.getValue());
        }
        ret.put("as", (Object)node.getAsName());
        return ret;
    }

    @Override
    public JSONObject visit(Conditional node) {
        JSONObject ret = new JSONObject();
        ret.put("type", (Object)"conditional");
        if (node.getFilter() == null) {
            ret.putOpt("filter", null);
        } else {
            ret.put("filter", (Object)node.getFilter().getNode().accept(this));
        }
        ret.put("pipeline", (Object)node.getPipeline().accept(this));
        return ret;
    }

    @Override
    public JSONObject visit(FieldNode node) {
        JSONObject ret = new JSONObject();
        ret.put("type", (Object)"field");
        ret.put("value", (Object)node.getFieldName());
        if (node.getSource() != null) {
            ret.put("source", (Object)node.getSource().getNode().accept(this));
        }
        return ret;
    }

    @Override
    public JSONObject visit(NavigationNode node) {
        JSONObject ret = new JSONObject();
        ret.put("type", (Object)node.getType());
        ret.put("name", (Object)node.getName());
        ret.put("cardinality", (Object)node.getCardinality().toString());
        if (node.getSource() != null) {
            ret.put("source", (Object)node.getSource().getNode().accept(this));
        }
        return ret;
    }

    @Override
    public JSONObject visit(MeasureNode node) {
        JSONObject ret = new JSONObject();
        ret.put("type", (Object)"measure");
        ret.put("value", (Object)node.getReference().toString());
        return ret;
    }

    @Override
    public JSONObject visit(BooleanNode node) {
        JSONObject ret = new JSONObject();
        ret.put("type", (Object)node.getType());
        ret.put("value", (Object)node.getValue());
        return ret;
    }

    @Override
    public JSONObject visit(NullNode node) {
        JSONObject ret = new JSONObject();
        ret.put("type", (Object)node.getType());
        ret.put("value", NullNode.getValue());
        return ret;
    }

    @Override
    public JSONObject visit(NumberNode node) {
        JSONObject ret = new JSONObject();
        ret.put("type", (Object)node.getType());
        ret.put("value", node.getValue());
        return ret;
    }

    @Override
    public JSONObject visit(ParamNode node) {
        JSONObject ret = new JSONObject();
        ret.put("paramName", (Object)node.getParamName());
        ret.put("paramValue", (Object)node.getParamValue());
        return ret;
    }

    @Override
    public JSONObject visit(SortNode node) {
        JSONObject ret = new JSONObject();
        ret.put("function", (Object)node.getFieldType().toString().toLowerCase());
        ret.put("name", (Object)node.getField().getFieldName());
        ret.put("mode", (Object)node.getSortOrder().toString().toLowerCase());
        return ret;
    }

    @Override
    public JSONObject visit(StringNode node) {
        JSONObject ret = new JSONObject();
        ret.put("type", (Object)"string");
        ret.put("value", (Object)node.getValue());
        return ret;
    }

    @Override
    public JSONObject visit(FunctionNode node) {
        JSONObject ret = new JSONObject();
        ret.put("type", (Object)"function");
        ret.put("value", (Object)node.getFunctionName());
        JSONArray args = new JSONArray();
        for (int i = 0; i < node.getArguments().size(); ++i) {
            args.put((Object)node.getArguments().get(i).accept(this));
        }
        ret.put("args", (Object)args);
        return ret;
    }

    @Override
    public JSONObject visit(SearchSubSearchPredicateNode node) {
        JSONObject ret = (JSONObject)super.visit(node);
        ret.put("search", (Object)node.getSubsearch().accept(this));
        return ret;
    }

    @Override
    public JSONObject visit(ComparisonNode node) {
        JSONObject ret = new JSONObject();
        ret.put("type", (Object)"function");
        ret.put("value", (Object)node.getOperator().toString());
        JSONArray args = new JSONArray();
        args.put((Object)node.getLhs().accept(this));
        args.put((Object)node.getRhs().accept(this));
        ret.put("args", (Object)args);
        return ret;
    }

    @Override
    public JSONObject visit(AndNode node) {
        JSONObject ret = this.visit((FunctionNode)node);
        ret.put("value", (Object)"AND");
        return ret;
    }

    @Override
    public JSONObject visit(OrNode node) {
        JSONObject ret = this.visit((FunctionNode)node);
        ret.put("value", (Object)"OR");
        return ret;
    }

    @Override
    public JSONObject visit(XorNode node) {
        JSONObject ret = this.visit((FunctionNode)node);
        ret.put("value", (Object)"XOR");
        return ret;
    }

    @Override
    public JSONObject visit(NotNode node) {
        BooleanFunctionNode xorNode = new BooleanFunctionNode("XOR", BooleanNode.TRUE, node.getArguments().get(0));
        JSONObject ret = this.visit((FunctionNode)xorNode);
        ret.put("value", (Object)"XOR");
        return ret;
    }

    @Override
    public JSONObject visit(InNode node) {
        JSONObject ret = this.visit((FunctionNode)node);
        ret.put("value", (Object)"in");
        return ret;
    }

    @Override
    public JSONObject visit(SearchComparisonNode node) {
        JSONObject ret = this.visit((SearchNode)node);
        ret.put("value", (Object)node.getOperator().toString());
        ret.put("is_numeric", node.is_numeric());
        ret.put("is_indexed", node.is_indexed());
        if (node.is_lhs_quoted()) {
            ret.put("is_lhs_quoted", node.is_lhs_quoted());
        }
        if (node.is_rhs_quoted()) {
            ret.put("is_rhs_quoted", node.is_rhs_quoted());
        }
        JSONArray args = new JSONArray();
        args.put((Object)node.getLhs().accept(this));
        args.put((Object)node.getRhs().accept(this));
        ret.put("args", (Object)args);
        return ret;
    }

    @Override
    public JSONObject visit(SearchNode node) {
        JSONObject ret = new JSONObject();
        ret.put("type", (Object)node.getType());
        return ret;
    }

    @Override
    public JSONObject visit(SearchLeafNode node) {
        JSONObject ret = this.visit((SearchNode)node);
        ret.put("is_case_sensitive", node.is_case_sensitive());
        ret.put("is_negated", node.is_negated());
        ret.put("is_literal_term", node.is_literal_term());
        return ret;
    }

    @Override
    public JSONObject visit(SearchQuotableNode node) {
        JSONObject ret = this.visit((SearchLeafNode)node);
        ret.put("value", (Object)node.getValue());
        if (node.is_quoted()) {
            ret.put("is_quoted", node.is_quoted());
        }
        return ret;
    }

    @Override
    public JSONObject visit(FieldProperties node) {
        JSONObject ret = new JSONObject();
        ret.put("name", (Object)node.getName());
        if (node.getModified()) {
            ret.put("modified", node.getModified());
        }
        if (node.getReferenced()) {
            ret.put("referenced", node.getReferenced());
        }
        if (node.getRemoved()) {
            ret.put("removed", node.getRemoved());
        }
        if (node.getFilterable()) {
            ret.put("filterable", node.getFilterable());
        }
        return ret;
    }

    @Override
    public JSONObject visit(RenameNode node) {
        JSONObject ret = new JSONObject();
        ret.put("field", (Object)node.getFieldName());
        ret.put("newField", (Object)node.getNewFieldName());
        return ret;
    }

    @Override
    public JSONObject visit(SearchAndNode node) {
        JSONObject ret = this.visit((SearchFunctionNode)node);
        ret.put("value", (Object)"AND");
        return ret;
    }

    @Override
    public JSONObject visit(SearchNotNode node) {
        JSONObject ret = node.getArguments().get(0).accept(this);
        ret.put("is_negated", true);
        return ret;
    }

    @Override
    public JSONObject visit(SearchOrNode node) {
        JSONObject ret = this.visit((SearchFunctionNode)node);
        ret.put("value", (Object)"OR");
        return ret;
    }

    @Override
    public JSONObject visit(SearchXorNode node) {
        JSONObject ret = this.visit((SearchFunctionNode)node);
        ret.put("value", (Object)"XOR");
        return ret;
    }

    @Override
    public JSONObject visit(SearchFunctionNode node) {
        JSONObject ret = new JSONObject();
        ret.put("type", (Object)node.getType());
        int length = node.getArguments().size();
        if (length > 0) {
            JSONArray args = new JSONArray();
            for (int i = 0; i < node.getArguments().size(); ++i) {
                args.put((Object)node.getArguments().get(i).accept(this));
            }
            ret.put("args", (Object)args);
        }
        return ret;
    }

    @Override
    public JSONObject visit(SearchInNode node) {
        JSONObject ret = this.visit((SearchNode)node);
        ret.put("value", (Object)"in");
        JSONArray args = new JSONArray();
        args.put((Object)node.getLhs().accept(this));
        for (int i = 0; i < node.getRhs().length; ++i) {
            args.put((Object)node.getRhs()[i].accept(this));
        }
        ret.put("args", (Object)args);
        return ret;
    }

    @Override
    public JSONObject visit(AssignmentNode node) {
        JSONObject ret = new JSONObject();
        ret.put("field", (Object)node.getFieldName());
        ret.put("value", (Object)node.getExpression().accept(this));
        if (node.getBracketIndex() >= 0) {
            ret.put("bracketindex", node.getBracketIndex());
        }
        ret.put("expression", (Object)node.getExpression().accept(new SplFormatter(this.enableDatasetSerializationShorthand)));
        return ret;
    }

    @Override
    public JSONObject visit(CommandNode node) {
        JSONObject ret = new JSONObject();
        ret.put("command", (Object)node.getCommandName());
        ret.put("type", (Object)node.getCommandType().toString());
        JSONArray fieldsAndProperties = new JSONArray();
        for (int i = 0; i < node.getFieldPropertiesArray().length; ++i) {
            fieldsAndProperties.put((Object)node.getFieldPropertiesArray()[i].accept(this));
        }
        ret.put("fields_and_properties", (Object)fieldsAndProperties);
        if (node.getSources().length > 0) {
            JSONArray array = new JSONArray();
            for (int i = 0; i < node.getSources().length; ++i) {
                array.put((Object)node.getSources()[i].accept(this));
            }
            ret.put("sources", (Object)array);
        }
        ret.put("pipeline", (Object)node.getPipeline().toPipeline());
        return ret;
    }

    @Override
    public JSONObject visit(AddInfoCommand node) {
        AssignmentNode[] assignmentNodes;
        JSONObject ret = (JSONObject)super.visit(node);
        for (AssignmentNode assignmentNode : assignmentNodes = node.getInfoNodes()) {
            ret.put(assignmentNode.getFieldName(), (Object)assignmentNode.getExpression().getType());
        }
        return ret;
    }

    @Override
    public JSONObject visit(JobPartitionerCommand node) {
        JSONObject ret = (JSONObject)super.visit(node);
        ret.put("jobpartition", (Object)node.getJobPartitionName());
        ret.put("isInternal", node.isInternalJob());
        return ret;
    }

    @Override
    public JSONObject visit(AppendCommand node) {
        return (JSONObject)super.visit(node);
    }

    @Override
    public JSONObject visit(BinCommand node) {
        JSONObject ret = (JSONObject)super.visit(node);
        ret.put("bin_field", (Object)node.getBinNode().getField().getFieldName());
        BinOptionsNode binOpts = node.getBinNode().getBinOptions();
        if (binOpts != null) {
            if (binOpts.getBins() != null) {
                ret.put("bins", binOpts.getBins().getValue());
            }
            if (binOpts.getStart() != null) {
                ret.put("start", binOpts.getStart().getValue());
            }
            if (binOpts.getEnd() != null) {
                ret.put("end", binOpts.getEnd().getValue());
            }
            if (binOpts.getSpan() != null) {
                ret.put("span", (Object)binOpts.getSpan().toString());
            }
            if (binOpts.getMinspan() != null) {
                ret.put("minspan", (Object)binOpts.getMinspan().toString());
            }
        }
        if (node.getNewField() != null) {
            ret.put("rename", (Object)node.getNewField().getFieldName());
        }
        return ret;
    }

    @Override
    public JSONObject visit(DatamodelCommand node) {
        JSONObject ret = (JSONObject)super.visit(node);
        JSONObject object = new JSONObject();
        object.put("datasettype", (Object)"datamodel");
        object.put("dataset", (Object)(node.getDatamodelName() + '.' + node.getObjectName()));
        JSONObject search = new JSONObject();
        search.put("spl", (Object)node.getSpl());
        object.put("search", (Object)search);
        ret.put("object", (Object)object);
        ret.put("mode", (Object)node.getMode());
        return ret;
    }

    @Override
    public JSONObject visit(EvalCommand node) {
        JSONObject ret = (JSONObject)super.visit(node);
        JSONArray assignments = new JSONArray();
        for (int i = 0; i < node.getAssignments().length; ++i) {
            assignments.put((Object)node.getAssignments()[i].accept(this));
        }
        ret.put("assignments", (Object)assignments);
        return ret;
    }

    @Override
    public JSONObject visit(FieldsCommand node) {
        JSONObject ret = (JSONObject)super.visit(node);
        ret.put("remove_attributes", node.isRemoveFields());
        ret.put("table", false);
        ret.put("keep_underscored", true);
        ret.put("keep_column_order", node.isKeepColumnOrder());
        JSONArray fieldList = new JSONArray();
        for (int i = 0; i < node.getFields().length; ++i) {
            fieldList.put((Object)node.getFields()[i].getFieldName());
        }
        ret.put("field_list", (Object)fieldList);
        return ret;
    }

    @Override
    public JSONObject visit(FromCommand node) {
        int i;
        JSONObject dataset = new JSONObject();
        dataset.put("datasettype", node.getDataset().getKind().equals("unknown") ? JSONObject.NULL : node.getDataset().getKind());
        if (node.getDataset() instanceof TransientDataset) {
            JSONObject datasetNode = ((TransientDataset)node.getDataset()).getSource().accept(this);
            dataset.put("dataset", (Object)datasetNode);
        } else {
            dataset.put("dataset", (Object)node.getDataset().getName());
        }
        if (this.enableDatasetSerializationShorthand && node.supportsShorthand()) {
            return dataset;
        }
        JSONObject ret = (JSONObject)super.visit(node);
        ret.put("object", (Object)dataset);
        if (node.getWhere() != null) {
            ret.put("predicate", (Object)node.getWhere().getNode().accept(this));
        }
        if (node.getGroupBy() != null && node.getGroupBy().length > 0) {
            JSONArray groupby = new JSONArray();
            ret.put("groupby", (Object)this.handleByFields(node.getGroupBy()));
        }
        if (node.getSelections() != null && node.getSelections().length > 0) {
            JSONArray select = new JSONArray();
            ret.put("select", (Object)select);
            for (i = 0; i < node.getSelections().length; ++i) {
                select.put((Object)node.getSelections()[i].getTypeNode().accept(this));
            }
        }
        if (node.getOrderings() != null && node.getOrderings().length > 0) {
            JSONArray orderby = new JSONArray();
            ret.put("orderby", (Object)orderby);
            for (i = 0; i < node.getOrderings().length; ++i) {
                orderby.put((Object)node.getOrderings()[i].getTypeNode().accept(this));
            }
        }
        return ret;
    }

    @Override
    public JSONObject visit(GroupByCommand node) {
        throw new UnsupportedOperationException();
    }

    @Override
    public JSONObject visit(HeadCommand node) {
        IWherePredicate conditions;
        JSONObject ret = (JSONObject)super.visit(node);
        NumberNode limit = node.getLimit();
        if (limit != null) {
            ret.put("limit", limit.getValue());
        }
        if ((conditions = node.getPredicate()) != null) {
            JSONObject evalExpression = conditions.getTypeNode().accept(this);
            BooleanNode keeplast = node.getKeeplast();
            if (keeplast != null) {
                evalExpression.put("keeplast", (Object)keeplast.getValue());
            } else {
                evalExpression.put("keeplast", false);
            }
            BooleanNode nullsMatch = node.getNullIsMatch();
            if (nullsMatch != null) {
                evalExpression.put("null", (Object)nullsMatch.getValue());
            } else {
                evalExpression.put("null", false);
            }
            ret.put("eval_expression", (Object)evalExpression);
        }
        return ret;
    }

    @Override
    public JSONObject visit(DedupCommand node) {
        JSONObject ret = (JSONObject)super.visit(node);
        ret.put("N", node.getLimit());
        JSONArray fieldList = new JSONArray();
        if (node.getFields() != null) {
            for (int i = 0; i < node.getFields().length; ++i) {
                fieldList.put((Object)node.getFields()[i].getFieldName());
            }
            ret.put("field_list", (Object)fieldList);
        }
        ret.put("keepevents", node.isKeepEvents());
        ret.put("keepempty", node.isKeepEmpty());
        ret.put("consecutive", node.isConsecutive());
        if (node.getSortBy() != null && node.getSortBy().length > 0) {
            JSONArray orderby = new JSONArray();
            ret.put("by", (Object)orderby);
            for (int i = 0; i < node.getSortBy().length; ++i) {
                orderby.put((Object)node.getSortBy()[i].getTypeNode().accept(this));
            }
        }
        return ret;
    }

    @Override
    public JSONObject visit(IfCommand node) {
        JSONObject ret = (JSONObject)super.visit(node);
        JSONArray conditions = new JSONArray();
        for (int i = 0; i < node.getConditionals().length; ++i) {
            conditions.put((Object)node.getConditionals()[i].accept(this));
        }
        ret.put("conditions", (Object)conditions);
        return ret;
    }

    @Override
    public JSONObject visit(LoadJobCommand node) {
        JSONObject ret = (JSONObject)super.visit(node);
        ret.put("job", (Object)node.getJobName());
        return ret;
    }

    @Override
    public JSONObject visit(InputlookupCommand node) {
        JSONObject ret = (JSONObject)super.visit(node);
        ret.put("table", (Object)node.getLookupName());
        ret.put("start", node.getStart());
        ret.put("max", node.getMax());
        if (node.getWhere() != null) {
            ret.put("predicate", (Object)node.getWhere().getNode().accept(this));
        }
        return ret;
    }

    @Override
    public JSONObject visit(IntoCommand node) {
        JSONObject ret = (JSONObject)super.visit(node);
        JSONObject dataset = new JSONObject();
        dataset.put("datasettype", (Object)node.getTarget().getKind());
        dataset.put("dataset", (Object)node.getTarget().getName());
        ret.put("object", (Object)dataset);
        IntoCommand.IntoMode intoMode = node.getMode();
        if (intoMode != null) {
            ret.put("mode", (Object)node.getMode().toString());
        }
        return ret;
    }

    @Override
    public JSONObject visit(IplocationCommand node) {
        JSONObject ret = (JSONObject)super.visit(node);
        ret.put("ip", (Object)node.getIpField());
        ret.put("lang", (Object)node.getLang());
        ret.put("prefix", (Object)node.getPrefix());
        ret.put("allfields", node.isAllFields());
        return ret;
    }

    @Override
    public JSONObject visit(JoinCommand node) {
        JSONObject ret = (JSONObject)super.visit(node);
        ret.put("jointype", (Object)node.getJoinType().toString().toLowerCase());
        ret.put("usetime", node.isUsetime());
        ret.put("earlier", node.isEarlier());
        ret.put("overwrite", node.isOverwrite());
        ret.put("max", node.getMax());
        ret.put("lhsalias", (Object)node.getLhsAlias());
        ret.put("rhsalias", (Object)node.getRhsAlias());
        JSONArray joinClauses = new JSONArray();
        for (int i = 0; i < node.getJoinClauses().length; ++i) {
            joinClauses.put((Object)node.getJoinClauses()[i].accept(this));
        }
        ret.put("joinClauses", (Object)joinClauses);
        return ret;
    }

    @Override
    public JSONObject visit(JoinNode node) {
        JSONObject join = new JSONObject();
        join.put("joinField", (Object)node.getLeftSide().getFieldName());
        join.put("sourceField", (Object)node.getRightSide().getFieldName());
        return join;
    }

    @Override
    public JSONObject visit(LookupCommand node) {
        JSONObject ret = (JSONObject)super.visit(node);
        JSONObject object = new JSONObject();
        object.put("datasettype", (Object)"lookup");
        object.put("dataset", (Object)node.getLookupName());
        ret.put("object", (Object)object);
        JSONArray joins = new JSONArray();
        for (int i = 0; i < node.getJoinKeys().length; ++i) {
            joins.put((Object)node.getJoinKeys()[i].accept(this));
        }
        ret.put("joins", (Object)joins);
        if (node.getMode() != LookupCommand.LookupMode.ALL) {
            ret.put("mode", (Object)node.getMode().toString().toLowerCase());
            JSONArray selections = new JSONArray();
            for (int i = 0; i < node.getSelections().length; ++i) {
                JoinNode selection = node.getSelections()[i];
                JSONObject join = new JSONObject();
                join.put("field", (Object)selection.getLeftSide().getFieldName());
                join.put("newField", (Object)selection.getRightSide().getFieldName());
                selections.put((Object)join);
            }
            ret.put("selections", (Object)selections);
        }
        ret.put("local", node.isLocal());
        ret.put("update", node.isUpdate());
        ret.put("required", true);
        ret.put("forceIndexed", false);
        return ret;
    }

    @Override
    public JSONObject visit(MStatsCommand node) {
        JSONObject ret = (JSONObject)super.visit(node);
        JSONArray aggregates = new JSONArray();
        for (int i = 0; i < node.getAggregates().length; ++i) {
            aggregates.put((Object)node.getAggregates()[i].accept(this));
        }
        ret.put("aggregates", (Object)aggregates);
        if (!node.getByFields().isEmpty()) {
            ret.put("by", (Object)this.handleByFields(node.getByFields().toArray(new IGroupBy[0])));
        }
        if (node.getPredicate() != null) {
            ret.put("predicate", (Object)node.getPredicate().getNode().accept(this));
        }
        return ret;
    }

    @Override
    public JSONObject visit(McatalogCommand node) {
        JSONObject ret = (JSONObject)super.visit(node);
        if (node.getAppendNode() != null) {
            ret.put("append", (Object)node.getAppendNode().getValue());
        }
        if (node.getPrestatsNode() != null) {
            ret.put("prestats", (Object)node.getPrestatsNode().getValue());
        }
        JSONArray aggregates = new JSONArray();
        for (int i = 0; i < node.getAggregateNodes().length; ++i) {
            aggregates.put((Object)node.getAggregateNodes()[i].accept(this));
        }
        ret.put("aggregates", (Object)aggregates);
        if (node.getByFields() != null) {
            ret.put("by", (Object)this.handleByFields(node.getByFields().toArray(new IGroupBy[0])));
        }
        if (node.getPredicate() != null) {
            ret.put("predicate", (Object)node.getPredicate().getNode().accept(this));
        }
        return ret;
    }

    @Override
    public JSONObject visit(MvexpandCommand node) {
        JSONObject ret = (JSONObject)super.visit(node);
        NumberNode limit = node.getLimit();
        if (limit != null) {
            ret.put("limit", limit.getValue());
        }
        ret.put("field", (Object)node.getFieldNode().getFieldName());
        return ret;
    }

    @Override
    public JSONObject visit(RdOutCommand node) {
        JSONObject ret = (JSONObject)super.visit(node);
        HostPort[] dfsWorkerNodes = node.getDfsWorkerNodes();
        JSONArray workerNodeArray = new JSONArray((Object)dfsWorkerNodes);
        ret.put("dfs_nodes", (Object)workerNodeArray);
        return ret;
    }

    @Override
    public JSONObject visit(RegexCommand node) {
        JSONObject ret = (JSONObject)super.visit(node);
        ret.put("field", (Object)node.getFieldName());
        ret.put("op", (Object)(node.getOperator() == Operator.EQUAL ? Operator.EQUAL.toSplOperator() : Operator.NOT_EQUAL.toSplOperator()));
        ret.put("regex_expression", (Object)node.getRegex());
        return ret;
    }

    @Override
    public JSONObject visit(RenameCommand node) {
        JSONObject ret = (JSONObject)super.visit(node);
        JSONArray renames = new JSONArray();
        for (int i = 0; i < node.getRenames().length; ++i) {
            renames.put((Object)node.getRenames()[i].accept(this));
        }
        if (node.getRenames().length > 0) {
            ret.put("renames", (Object)renames);
        }
        return ret;
    }

    @Override
    public JSONObject visit(RexCommand node) {
        JSONObject ret = (JSONObject)super.visit(node);
        if (node.getField() != null) {
            ret.put("field", (Object)node.getField().getFieldName());
        }
        ret.put("sed_mode", node.isSedMode());
        if (node.isSedMode()) {
            ret.put("sed_expression", (Object)node.getSedExpression());
        } else {
            ret.put("regex_expression", (Object)node.getRegexExpression());
            if (node.getOffsetField() != null) {
                ret.put("offset_field", (Object)node.getOffsetField().getFieldName());
            }
            ret.put("max_match", node.getMaxMatch());
        }
        return ret;
    }

    @Override
    public JSONObject visit(SavedsearchCommand node) {
        JSONObject ret = (JSONObject)super.visit(node);
        JSONObject object = new JSONObject();
        object.put("dataset", (Object)node.savedsearchName());
        object.put("datasettype", (Object)"savedsearch");
        JSONObject search = new JSONObject();
        search.put("spl", (Object)"");
        object.put("search", (Object)search);
        ret.put("object", (Object)object);
        JSONArray replacements = new JSONArray();
        for (int i = 0; i < node.getReplacements().length; ++i) {
            replacements.put((Object)node.getReplacements()[i].accept(this));
        }
        ret.put("replacements", (Object)replacements);
        ret.put("nosubstitution", false);
        return ret;
    }

    @Override
    public JSONObject visit(ReplacementNode node) {
        JSONObject ret = new JSONObject();
        ret.put("placeholder", (Object)node.getPlaceholder());
        ret.put("replacement", (Object)node.getReplacement());
        return ret;
    }

    @Override
    public JSONObject visit(SearchCommand node) {
        JSONObject object = (JSONObject)super.visit(node);
        object.put("predicate", (Object)node.getPredicate().getNode().accept(this));
        return object;
    }

    @Override
    public JSONObject visit(SelfJoinCommand node) {
        JSONObject ret = (JSONObject)super.visit(node);
        ret.put("overwrite", node.isOverwrite());
        ret.put("max", node.getMax());
        ret.put("keepsingle", node.isKeepsingle());
        JSONArray joinClauses = new JSONArray();
        for (int i = 0; i < node.getJoinClauses().length; ++i) {
            joinClauses.put((Object)node.getJoinClauses()[i].accept(this));
        }
        ret.put("joinClauses", (Object)joinClauses);
        return ret;
    }

    @Override
    public JSONObject visit(SendalertCommand node) {
        JSONObject object = (JSONObject)super.visit(node);
        object.put("alert_action_name", (Object)node.getName().accept(this));
        JSONArray params = new JSONArray();
        object.put("results_link", (Object)node.getResultsLink().accept(this));
        object.put("results_path", (Object)node.getResultsPath().accept(this));
        for (int i = 0; i < node.getParams().length; ++i) {
            params.put((Object)node.getParams()[i].accept(this));
        }
        object.put("params", (Object)params);
        return object;
    }

    @Override
    public JSONObject visit(ApplyCommand node) {
        JSONObject object = (JSONObject)super.visit(node);
        object.put("raw", (Object)node.getSPL());
        return object;
    }

    @Override
    public JSONObject visit(FitCommand node) {
        JSONObject object = (JSONObject)super.visit(node);
        object.put("raw", (Object)node.getSPL());
        return object;
    }

    @Override
    public JSONObject visit(SortCommand node) {
        JSONObject object = (JSONObject)super.visit(node);
        object.put("count", node.getCount());
        JSONArray by = new JSONArray();
        for (int i = 0; i < node.getBy().length; ++i) {
            by.put((Object)node.getBy()[i].getTypeNode().accept(this));
        }
        object.put("by", (Object)by);
        return object;
    }

    @Override
    public JSONObject visit(BinOptionsNode binOpts) {
        JSONObject binOptions = new JSONObject();
        if (binOpts.getBins() != null) {
            binOptions.put("bins", binOpts.getBins().getValue());
        }
        if (binOpts.getStart() != null) {
            binOptions.put("start", binOpts.getStart().getValue());
        }
        if (binOpts.getEnd() != null) {
            binOptions.put("end", binOpts.getEnd().getValue());
        }
        if (binOpts.getSpan() != null) {
            binOptions.put("span", (Object)binOpts.getSpan().toString());
        }
        if (binOpts.getMinspan() != null) {
            binOptions.put("minspan", (Object)binOpts.getMinspan().toString());
        }
        if (binOpts instanceof TableColumnOptionsNode) {
            TableColumnOptionsNode node = (TableColumnOptionsNode)binOpts;
            if (node.getNullStr() != null) {
                binOptions.put("nullstr", (Object)node.getNullStr());
            }
            if (node.getOtherStr() != null) {
                binOptions.put("otherstr", (Object)node.getOtherStr());
            }
            if (node.getUseNull() != null) {
                binOptions.put("usenull", (Object)node.getUseNull().getValue());
            }
            if (node.getUseOther() != null) {
                binOptions.put("useother", (Object)node.getUseOther().getValue());
            }
        }
        return binOptions;
    }

    @Override
    public JSONObject visit(TimechartCommand node) {
        JSONObject object = (JSONObject)super.visit(node);
        if (node.getAgg() != null) {
            object.put("agg", (Object)node.getAgg().toString());
        }
        if (node.getLimit() != null) {
            object.put("limit", node.getLimit().getValue());
        }
        if (node.getCont() != null) {
            object.put("cont", (Object)node.getCont().getValue());
        }
        if (node.getFixedRange() != null) {
            object.put("fixedrange", (Object)node.getFixedRange().getValue());
        }
        if (node.getPartial() != null) {
            object.put("partial", (Object)node.getPartial().getValue());
        }
        if (node.getFormat() != null) {
            object.put("format", (Object)node.getFormat().toString());
        }
        if (node.getSep() != null) {
            object.put("sep", (Object)node.getSep().toString());
        }
        if (node.getAggregates() != null) {
            JSONArray aggregates = new JSONArray();
            for (int i = 0; i < node.getAggregates().length; ++i) {
                aggregates.put((Object)node.getAggregates()[i].accept(this));
            }
            object.put("aggregates", (Object)aggregates);
        }
        object.put("by", (Object)this.handleByFields(node.getByFields().toArray(new IGroupBy[0])));
        return object;
    }

    @Override
    public JSONObject visit(StatsCommand node) {
        JSONObject object = (JSONObject)super.visit(node);
        BooleanNode bNode = node.getAllnum();
        NumberNode nNode = node.getPartitions();
        StringNode sNode = node.getDelim();
        if (bNode != null) {
            object.put("allnum", (Object)bNode.getValue());
        }
        if (sNode != null) {
            object.put("delim", (Object)sNode.toString());
        }
        if (nNode != null) {
            object.put("partitions", (Object)nNode.toString());
        }
        if (!node.getAggregates().isEmpty()) {
            JSONArray aggregates = new JSONArray();
            for (int i = 0; i < node.getAggregates().size(); ++i) {
                aggregates.put((Object)node.getAggregates().get(i).accept(this));
            }
            object.put("aggregates", (Object)aggregates);
        }
        if (!node.getByFields().isEmpty()) {
            object.put("by", (Object)this.handleByFields(node.getByFields().toArray(new IGroupBy[0])));
        }
        return object;
    }

    @Override
    public JSONObject visit(TableCommand node) {
        JSONObject ret = (JSONObject)super.visit(node);
        JSONArray fieldList = new JSONArray();
        for (int i = 0; i < node.getFields().length; ++i) {
            fieldList.put((Object)node.getFields()[i].getFieldName());
        }
        ret.put("field_list", (Object)fieldList);
        ret.put("table", true);
        ret.put("keep_underscored", false);
        ret.put("keep_column_order", false);
        return ret;
    }

    @Override
    public JSONObject visit(TailCommand node) {
        JSONObject ret = (JSONObject)super.visit(node);
        ret.put("limit", node.getLimit());
        return ret;
    }

    @Override
    public JSONObject visit(TStatsCommand node) {
        JSONObject ret = (JSONObject)super.visit(node);
        JSONArray aggregates = new JSONArray();
        for (int i = 0; i < node.getAggregates().length; ++i) {
            aggregates.put((Object)node.getAggregates()[i].accept(this));
        }
        ret.put("aggregates", (Object)aggregates);
        if (node.getByFields() != null) {
            ret.put("by", (Object)this.handleByFields(node.getByFields()));
        }
        if (node.getPredicate() != null) {
            ret.put("predicate", (Object)node.getPredicate().getNode().accept(this));
        }
        if (node.getNamespace() != null) {
            JSONObject from = new JSONObject();
            if (node.getNamespace().startsWith("datamodel=")) {
                JSONObject object = new JSONObject();
                object.put("dataset", (Object)node.getNamespace().replace("datamodel=", ""));
                object.put("datasettype", (Object)"datamodel");
                from.put("object", (Object)object);
            } else if (node.getNamespace().startsWith("sid=")) {
                from.put("sid", (Object)node.getNamespace().replace("sid=", ""));
            } else {
                from.put("namespace", (Object)node.getNamespace());
            }
            ret.put("from", (Object)from);
        }
        ret.put("append", node.isAppend());
        ret.put("prestats", node.getOptions().isPrestats());
        ret.put("chunk_size", node.getOptions().getChunksize());
        ret.put("allow_old_summaries", node.getOptions().isAllowOldSummaries());
        ret.put("local", node.getOptions().isLocal());
        ret.put("summariesonly", node.getOptions().isSummariesonly());
        return ret;
    }

    @Override
    public JSONObject visit(UnionCommand node) {
        JSONObject ret = (JSONObject)super.visit(node);
        Map.Entry<String, String>[] options = node.getOptions();
        if (options != null) {
            for (Map.Entry<String, String> option : options) {
                ret.put(option.getKey(), (Object)option.getValue());
            }
        }
        return ret;
    }

    @Override
    public JSONObject visit(UnknownCommand node) {
        JSONObject ret = (JSONObject)super.visit(node);
        ret.put("raw", (Object)node.getArguments());
        return ret;
    }

    @Override
    public JSONObject visit(WhereCommand node) {
        JSONObject ret = (JSONObject)super.visit(node);
        ret.put("predicate", (Object)node.getPredicate().getNode().accept(this));
        return ret;
    }

    @Override
    public JSONObject visit(MultiValueNode node) {
        JSONObject ret = new JSONObject();
        ret.put("type", (Object)"multivalue");
        JSONArray mv = new JSONArray();
        if (node.getValue() != null) {
            for (int i = 0; i < node.getValue().length; ++i) {
                mv.put((Object)node.getValue()[i]);
            }
            ret.put("value", (Object)mv);
        }
        return ret;
    }

    @Override
    public JSONObject visit(BinNode node) {
        JSONObject ret = new JSONObject();
        ret.put("type", (Object)"function");
        ret.put("value", (Object)node.getFunctionName());
        JSONObject args = new JSONObject();
        ret.put("args", (Object)args);
        args.put("field", (Object)node.getField().getFieldName());
        if (node.getBinOptions() != null) {
            args.put("binoptions", (Object)node.getBinOptions().accept(this));
        }
        return ret;
    }

    @Override
    public JSONObject visit(SpanNode node) {
        JSONObject ret = new JSONObject();
        ret.put("type", (Object)node.getType());
        ret.put("value", (Object)node.toString());
        return ret;
    }

    private JSONArray handleByFields(IGroupBy[] byFields) {
        JSONArray by = new JSONArray();
        for (IGroupBy byField : byFields) {
            if (this.enableByFieldsTypeNodeSerializationFormat || byField instanceof BinNode) {
                by.put((Object)((Node)((Object)byField)).accept(this));
                continue;
            }
            JSONObject field = new JSONObject();
            field.put("name", (Object)byField.getByName());
            by.put((Object)field);
        }
        return by;
    }
}

