/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.visitors;

import com.splunk.commons.ast.nodes.CommandNode;
import com.splunk.commons.ast.nodes.Node;
import com.splunk.commons.ast.nodes.commands.FieldProperties;
import com.splunk.commons.ast.nodes.expressions.AggregateNode;
import com.splunk.commons.ast.nodes.expressions.BinNode;
import com.splunk.commons.ast.nodes.expressions.ComparisonNode;
import com.splunk.commons.ast.nodes.expressions.FieldNode;
import com.splunk.commons.ast.nodes.expressions.FunctionNode;
import com.splunk.commons.ast.nodes.expressions.TypeNode;
import com.splunk.commons.ast.nodes.search.SearchComparisonNode;
import com.splunk.commons.ast.nodes.search.SearchFunctionNode;
import com.splunk.commons.ast.nodes.search.SearchNode;
import com.splunk.commons.ast.nodes.search.SearchQuotableNode;
import com.splunk.commons.ast.nodes.search.SearchSubSearchPredicateNode;
import com.splunk.commons.visitors.NodeVisitor;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ReferencedFieldsVisitor
extends NodeVisitor<Set<String>> {
    @Override
    public Set<String> visit(Node node) {
        return new HashSet<String>();
    }

    @Override
    public Set<String> visit(CommandNode node) {
        HashSet<String> ret = new HashSet<String>();
        for (FieldProperties prop : node.getFieldPropertiesArray()) {
            if (!prop.getReferenced()) continue;
            ret.add(prop.getName());
        }
        return ret;
    }

    @Override
    public Set<String> visit(FieldNode node) {
        HashSet<String> ret = new HashSet<String>();
        ret.add(node.getFieldName());
        return ret;
    }

    @Override
    public Set<String> visit(FunctionNode node) {
        List<TypeNode> args = node.getArguments();
        HashSet<String> ret = new HashSet<String>();
        for (int i = 0; i < args.size(); ++i) {
            if (args.get(i) == null) continue;
            Set<String> argRefs = args.get(i).accept(this);
            ret.addAll(argRefs);
        }
        return ret;
    }

    @Override
    public Set<String> visit(BinNode node) {
        return this.visit(node.getField());
    }

    @Override
    public Set<String> visit(ComparisonNode node) {
        Set<String> lhs = node.getLhs().accept(this);
        lhs.addAll((Collection<String>)node.getRhs().accept(this));
        return lhs;
    }

    @Override
    public Set<String> visit(SearchFunctionNode node) {
        List<SearchNode> args = node.getArguments();
        HashSet<String> ret = new HashSet<String>();
        for (SearchNode arg : args) {
            Set<String> argRefs = arg.accept(this);
            ret.addAll(argRefs);
        }
        return ret;
    }

    @Override
    public Set<String> visit(SearchSubSearchPredicateNode node) {
        return node.getSubsearch().accept(this);
    }

    @Override
    public Set<String> visit(SearchComparisonNode node) {
        HashSet<String> fields = new HashSet<String>();
        fields.add(node.getLhs().getFieldName());
        return fields;
    }

    @Override
    public Set<String> visit(SearchQuotableNode node) {
        HashSet<String> fields = new HashSet<String>();
        fields.add("_raw");
        return fields;
    }

    @Override
    public Set<String> visit(AggregateNode node) {
        HashSet<String> fields = new HashSet<String>();
        fields.add(node.getField().getFieldName());
        return fields;
    }
}

