/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.roll;

import com.splunk.roll.util.Time;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Logger;

public class TempFileCleaner {
    private static final Logger gLogger = Logger.getLogger(TempFileCleaner.class);
    private final Configuration conf;
    private final Time cleanFilesOlderThan;

    public TempFileCleaner(Configuration conf, Time cleanFilesOlderThan) {
        this.conf = conf;
        this.cleanFilesOlderThan = cleanFilesOlderThan;
    }

    public <T> List<T> clean(Iterable<T> files) {
        ArrayList<T> cleaned = new ArrayList<T>();
        for (T f : files) {
            Cleaner<T> cleaner = this.getCleaner(f);
            if (!this.isFileOldEnoughToBeCleaned(cleaner.getLastModified(f))) continue;
            cleaner.delete(this.conf, f);
            cleaned.add(f);
        }
        return cleaned;
    }

    private boolean isFileOldEnoughToBeCleaned(long lastModified) {
        long now = System.currentTimeMillis();
        return now - this.cleanFilesOlderThan.getTime() > lastModified;
    }

    public <T> Cleaner<T> getCleaner(Object o) {
        if (o instanceof File) {
            return new Cleaner<File>(){

                @Override
                public void delete(Configuration conf, File t) {
                    FileUtils.deleteQuietly((File)t);
                }

                @Override
                public long getLastModified(File t) {
                    return t.lastModified();
                }
            };
        }
        if (o instanceof FileStatus) {
            return new Cleaner<FileStatus>(){

                @Override
                public void delete(Configuration conf, FileStatus t) {
                    Path p = t.getPath();
                    try {
                        p.getFileSystem(conf).delete(p, true);
                    }
                    catch (IOException ignore) {
                        gLogger.debug((Object)("Exception=" + ignore + " when deleting a path. Ignoring"));
                    }
                }

                @Override
                public long getLastModified(FileStatus t) {
                    return t.getModificationTime();
                }
            };
        }
        throw new UnsupportedOperationException("Unable to get cleaner implementation for object: " + o);
    }

    private static interface Cleaner<T> {
        public void delete(Configuration var1, T var2);

        public long getLastModified(T var1);
    }
}

