/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mr.packaging;

import com.splunk.mr.packaging.SynchronizedExecuter;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FileUtils;

public class CountingTempFileProvider
implements SynchronizedExecuter.TempProvider<File> {
    private static final String TMP_FILE_SUFFIX = ".tmp";
    private final File seedFile;
    private final IncrementCondition incrementCondition;
    private int countLimit;

    public CountingTempFileProvider(File seedFile, int countLimit, IncrementCondition incrementCondition) {
        this.seedFile = seedFile;
        this.incrementCondition = incrementCondition;
        this.countLimit = countLimit;
    }

    @Override
    public File getTemp() {
        return this.getTempFileWithCount();
    }

    private File getTempFileWithCount() {
        int count = 1;
        while (this.incrementCondition.shouldIncrementCount(this.getFileWithCurrentCount(count))) {
            if (count < this.countLimit) {
                ++count;
                continue;
            }
            throw new TempFileRetryException("Reached maximum retries for getting a temp file. Count: " + this.countLimit + ", File: " + this.getFileWithCurrentCount(count).getAbsolutePath() + ".");
        }
        return this.getFileWithCurrentCount(count);
    }

    private File getFileWithCurrentCount(int count) {
        return new File(this.seedFile.getAbsolutePath() + TMP_FILE_SUFFIX + count);
    }

    public static List<File> getProvidedFiles(File seedFile, int countLimit) {
        ArrayList<File> files = new ArrayList<File>();
        CountingTempFileProvider tempFileProvider = new CountingTempFileProvider(seedFile, countLimit, new IncrementEveryOtherFile());
        try {
            while (true) {
                files.add((File)tempFileProvider.getTemp());
            }
        }
        catch (TempFileRetryException tempFileRetryException) {
            return files;
        }
    }

    public static void reapAllProvidedFiles(File seedFile, int countLimit) {
        List<File> files = CountingTempFileProvider.getProvidedFiles(seedFile, countLimit);
        for (File f : files) {
            FileUtils.deleteQuietly((File)f);
        }
    }

    static class IncrementEveryOtherFile
    implements IncrementCondition {
        Set<String> filePaths = new HashSet<String>();

        IncrementEveryOtherFile() {
        }

        @Override
        public boolean shouldIncrementCount(File file) {
            if (this.filePaths.contains(file.getAbsolutePath())) {
                return true;
            }
            this.filePaths.add(file.getAbsolutePath());
            return false;
        }
    }

    public static class TempFileRetryException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public TempFileRetryException(String msg) {
            super(msg);
        }
    }

    public static interface IncrementCondition {
        public boolean shouldIncrementCount(File var1);
    }
}

